/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedOutputMode;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedOutputPoint;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EpicFightEntityRendererPatch;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.part.other.PartitionPartType;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class BakedAdapterJointTransform
implements ITransform,
IJointTransform {
    private final BakedSkinPart part;
    private final AnimatedOutputPoint output;
    private final boolean isPartitionPart;
    private final OpenPoseStack tester = new OpenPoseStack();

    public BakedAdapterJointTransform(BakedSkinPart part) {
        this.part = part;
        this.isPartitionPart = part.type() instanceof PartitionPartType;
        this.output = new AnimatedOutputPoint(null, AnimatedOutputMode.MAIN);
        AnimatedTransform transform = AnimatedTransform.of(part.transform());
        if (transform != null) {
            transform.setController(this.output);
        }
    }

    public void setup(@Nullable Entity entity, BakedArmature armature, SkinRenderContext context) {
        IJointTransform transform = armature.transformByJoint(armature.jointByPart(this.part));
        if (transform == null) {
            this.output.clear();
            return;
        }
        EntityRenderData renderData = context.renderData();
        if (renderData != null && renderData.renderPatch() instanceof EpicFightEntityRendererPatch) {
            this.setupEpicFight(transform, context);
        } else {
            this.setupVanilla(transform, context);
        }
    }

    private void setupVanilla(IJointTransform transform, SkinRenderContext context) {
        if (this.isPartitionPart) {
            this.output.clear();
            return;
        }
        this.tester.setIdentity();
        transform.apply(this.tester);
        OpenQuaternionf quaternion = OpenQuaternionf.fromUnnormalizedMatrix(this.tester.last().pose());
        OpenVector3f rotation = quaternion.eulerAnglesZYX();
        float xRot = OpenMath.toDegrees(rotation.x());
        float yRot = OpenMath.toDegrees(rotation.y());
        float zRot = OpenMath.toDegrees(rotation.z());
        this.output.setRotation(xRot, yRot, zRot);
    }

    private void setupEpicFight(IJointTransform transform, SkinRenderContext context) {
        this.tester.setIdentity();
        transform.apply(this.tester);
        this.tester.scale(-1.0f, -1.0f, 1.0f);
        OpenQuaternionf quaternion = OpenQuaternionf.fromUnnormalizedMatrix(this.tester.last().pose());
        OpenVector3f rotation = quaternion.eulerAnglesZYX();
        float xRot = OpenMath.toDegrees(rotation.x());
        float yRot = OpenMath.toDegrees(rotation.y());
        float zRot = OpenMath.toDegrees(rotation.z());
        this.output.setRotation(xRot * -1.0f, yRot * -1.0f, zRot * 1.0f);
    }

    @Override
    public void apply(IPoseStack poseStack) {
    }

    private boolean inEpicFight(SkinRenderContext context) {
        EntityRenderData renderData = context.renderData();
        if (renderData != null) {
            return renderData.renderPatch() instanceof EpicFightEntityRendererPatch;
        }
        return false;
    }
}

