/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedOutputMode;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedOutputPoint;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedPoint;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimationEffectState;
import moe.plushie.armourers_workshop.core.client.animation.AnimationEngine;
import moe.plushie.armourers_workshop.core.client.animation.AnimationPlayState;
import moe.plushie.armourers_workshop.core.client.animation.handler.AnimationInstructHandler;
import moe.plushie.armourers_workshop.core.client.animation.handler.AnimationParticleHandler;
import moe.plushie.armourers_workshop.core.client.animation.handler.AnimationSoundHandler;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationFunction;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationKeyframe;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationPoint;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Constant;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import moe.plushie.armourers_workshop.core.utils.OptimizedExpression;
import moe.plushie.armourers_workshop.init.ModLog;
import org.apache.commons.lang3.tuple.Pair;

public class AnimationController {
    private final int id = OpenRandomSource.nextInt(AnimationController.class);
    private final String name;
    private final SkinAnimation animation;
    private final double duration;
    private final SkinAnimationLoop loop;
    private final ArrayList<Animator<?>> animators = new ArrayList();
    private final AnimatedOutputMode mode;
    private final boolean isRequiresVirtualMachine;

    public AnimationController(SkinAnimation animation, Map<String, SkinPartTransform> partTransforms) {
        this.name = animation.name();
        this.animation = animation;
        this.loop = animation.loop();
        this.duration = animation.duration();
        this.mode = AnimationController.calcMixMode(this.name);
        animation.keyframes().forEach((partName, linkedValues) -> {
            SkinPartTransform partTransform = (SkinPartTransform)partTransforms.get(partName);
            if (partTransform != null) {
                this.animators.add(new Animator.Bone((String)partName, AnimationController.toTime(this.duration), (List<SkinAnimationKeyframe>)linkedValues, AnimatedTransform.of(partTransform), this.mode));
            }
            if (partName.equals("armourers:effects") || partName.equals("effects")) {
                this.animators.add(new Animator.Effect((String)partName, AnimationController.toTime(this.duration), (List<SkinAnimationKeyframe>)linkedValues));
            }
        });
        this.isRequiresVirtualMachine = this.calcRequiresVirtualMachine();
    }

    public static int toTime(double time) {
        return (int)(time * 1000.0);
    }

    public static Expression compileExpression(OpenPrimitive object, double defaultValue) {
        try {
            if (object.isNumber()) {
                return new Constant(object.doubleValue());
            }
            if (object.isString()) {
                return AnimationEngine.compile(object.stringValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new Constant(defaultValue);
    }

    public void process(double animationTime, AnimationPlayState playState, ExecutionContext context) {
        int time = AnimationController.toTime(animationTime);
        for (Animator<?> animator : this.animators) {
            animator.process(time, playState, context);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnimationController)) {
            return false;
        }
        AnimationController that = (AnimationController)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return Objects.toString(this, new Object[]{"name", this.name, "duration", this.duration, "loop", this.loop});
    }

    public Collection<AnimatedTransform> affectedTransforms() {
        return Collections.compactMap(this.animators, it -> {
            if (it instanceof Animator.Bone) {
                Animator.Bone bone = (Animator.Bone)it;
                return bone.transform;
            }
            return null;
        });
    }

    public String name() {
        return this.name;
    }

    public SkinAnimationLoop loop() {
        return this.loop;
    }

    public double duration() {
        return this.duration;
    }

    public boolean isRequiresVirtualMachine() {
        return this.isRequiresVirtualMachine;
    }

    public boolean isParallel() {
        return this.mode != AnimatedOutputMode.MAIN;
    }

    public boolean isEmpty() {
        return this.animators.isEmpty();
    }

    public static AnimatedOutputMode calcMixMode(String name) {
        if ((name = name.toLowerCase()).matches("^(.+\\.)?pre_parallel(\\d+)$")) {
            return AnimatedOutputMode.PRE_MAIN;
        }
        if (name.matches("^(.+\\.)?parallel(\\d+)$")) {
            return AnimatedOutputMode.POST_MAIN;
        }
        return AnimatedOutputMode.MAIN;
    }

    private boolean calcRequiresVirtualMachine() {
        for (Animator<?> animator : this.animators) {
            for (Channel channel : animator.channels) {
                for (Fragment fragment : channel.fragments) {
                    if (fragment.isConstant()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static abstract class Animator<T> {
        protected final String name;
        protected final List<Channel<T>> channels;

        public Animator(String name, int duration, List<SkinAnimationKeyframe> linkedKeyframes) {
            LinkedHashMap<String, ArrayList> namedKeyframes = new LinkedHashMap<String, ArrayList>();
            for (SkinAnimationKeyframe keyframe : linkedKeyframes) {
                namedKeyframes.computeIfAbsent(keyframe.key(), key -> new ArrayList()).add(keyframe);
            }
            this.name = name;
            this.channels = Collections.compactMap(namedKeyframes.entrySet(), it -> this.createChannel((String)it.getKey(), duration, (List)it.getValue()));
        }

        public void process(int time, AnimationPlayState playState, ExecutionContext context) {
            for (Channel<T> channel : this.channels) {
                this.apply(channel, time, playState, context);
            }
        }

        public abstract void apply(Channel<T> var1, int var2, AnimationPlayState var3, ExecutionContext var4);

        public abstract Channel<T> createChannel(String var1, int var2, List<SkinAnimationKeyframe> var3);

        public String toString() {
            return Objects.toString(this, "name", this.name);
        }

        private static class Effect
        extends Animator<Object> {
            public Effect(String name, int duration, List<SkinAnimationKeyframe> linkedKeyframes) {
                super(name, duration, linkedKeyframes);
            }

            @Override
            public void apply(Channel<Object> channel, int time, AnimationPlayState playState, ExecutionContext context) {
                Fragment<Object> fragment = channel.fragmentAtTime(time);
                OptimizedExpression currentValue = Objects.flatMap(fragment, it -> it.startValue);
                AnimationEffectState effectState = playState.effectByName(channel.name);
                if (effectState.value() == currentValue) {
                    return;
                }
                if (currentValue == null) {
                    effectState.setValue(null, null);
                    return;
                }
                Object result = currentValue.evaluate(context);
                effectState.setValue(currentValue, result);
            }

            @Override
            public Channel<Object> createChannel(String name, int duration, List<SkinAnimationKeyframe> keyframes) {
                return new Channel.Effect(name, duration, null, keyframes);
            }
        }

        private static class Bone
        extends Animator<OpenVector3f> {
            private final AnimatedOutputPoint output;
            private final AnimatedTransform transform;

            public Bone(String name, int duration, List<SkinAnimationKeyframe> linkedKeyframes, AnimatedTransform transform, AnimatedOutputMode mode) {
                super(name, duration, linkedKeyframes);
                this.output = new AnimatedOutputPoint(transform, mode);
                this.transform = transform;
                if (transform != null) {
                    transform.link(this.output);
                }
            }

            @Override
            public void apply(Channel<OpenVector3f> channel, int time, AnimationPlayState playState, ExecutionContext context) {
                Fragment<OpenVector3f> fragment = channel.fragmentAtTime(time);
                if (fragment == null) {
                    return;
                }
                Selector selector = channel.selector;
                OptimizedExpression startValue = fragment.startValue;
                int currentTime = time - fragment.startTime;
                if (currentTime <= 0) {
                    selector.apply((OpenVector3f)startValue.evaluate(context), this.output);
                    return;
                }
                int length = fragment.length;
                OptimizedExpression endValue = fragment.endValue;
                if (currentTime >= length) {
                    selector.apply((OpenVector3f)endValue.evaluate(context), this.output);
                    return;
                }
                SkinAnimationFunction function = fragment.function;
                OpenVector3f from = (OpenVector3f)startValue.evaluate(context);
                OpenVector3f to = (OpenVector3f)endValue.evaluate(context);
                float t = function.apply((float)currentTime / (float)length);
                float tx = OpenMath.lerp(t, from.x(), to.x());
                float ty = OpenMath.lerp(t, from.y(), to.y());
                float tz = OpenMath.lerp(t, from.z(), to.z());
                selector.apply(tx, ty, tz, this.output);
            }

            @Override
            public Channel<OpenVector3f> createChannel(String name, int duration, List<SkinAnimationKeyframe> keyframes) {
                Selector selector = this.select(name);
                if (selector != null) {
                    return new Channel.Bone(name, duration, selector, keyframes);
                }
                return null;
            }

            private Selector select(String name) {
                return switch (name) {
                    case "position" -> new Selector.Translation();
                    case "rotation" -> new Selector.Rotation();
                    case "scale" -> new Selector.Scale();
                    default -> null;
                };
            }
        }
    }

    private static abstract class Channel<T> {
        private final String name;
        private final Selector selector;
        private final List<Fragment<T>> fragments;
        private Fragment<T> current;

        public Channel(String name, int duration, Selector selector, List<SkinAnimationKeyframe> keyframes) {
            this.name = name;
            this.selector = selector;
            this.fragments = this.createFragments(duration, keyframes);
        }

        public abstract Pair<OptimizedExpression<T>, OptimizedExpression<T>> compile(List<SkinAnimationPoint> var1);

        public Fragment<T> fragmentAtTime(int time) {
            if (this.current != null && this.current.contains(time)) {
                return this.current;
            }
            for (Fragment<T> fragment : this.fragments) {
                this.current = fragment;
                if (!this.current.contains(time)) continue;
                break;
            }
            return this.current;
        }

        public boolean isEmpty() {
            return this.fragments == null || this.fragments.isEmpty();
        }

        public String toString() {
            return Objects.toString(this, "name", this.name);
        }

        private List<Fragment<T>> createFragments(int duration, List<SkinAnimationKeyframe> keyframes) {
            ArrayList<FragmentBuilder> builders = new ArrayList<FragmentBuilder>();
            for (SkinAnimationKeyframe keyframe : keyframes) {
                int time = AnimationController.toTime(keyframe.time());
                Pair<OptimizedExpression<T>, OptimizedExpression<T>> point = this.compile(keyframe.points());
                builders.add(new FragmentBuilder(time, keyframe.function(), (OptimizedExpression)point.getKey(), (OptimizedExpression)point.getValue()));
            }
            builders.sort(Comparator.comparingInt(it -> it.leftTime));
            if (!builders.isEmpty()) {
                builders.add(0, ((FragmentBuilder)builders.get(0)).copyToBegin());
                builders.add(((FragmentBuilder)builders.get(builders.size() - 1)).copyToEnd(duration));
            }
            for (int i = 1; i < builders.size(); ++i) {
                FragmentBuilder left = (FragmentBuilder)builders.get(i - 1);
                FragmentBuilder right = (FragmentBuilder)builders.get(i);
                left.rightTime = right.leftTime;
                left.rightValue = right.leftValue;
                right.leftTime = right.rightTime;
                right.leftValue = right.rightValue;
            }
            if (builders.size() > 1) {
                FragmentBuilder first = (FragmentBuilder)builders.get(0);
                builders.removeIf(it -> it.leftTime == it.rightTime);
                if (builders.isEmpty()) {
                    builders.add(first);
                }
            }
            return Collections.compactMap(builders, FragmentBuilder::build);
        }

        private static class Effect
        extends Channel<Object> {
            public Effect(String name, int duration, Selector selector, List<SkinAnimationKeyframe> keyframes) {
                super(name, duration, selector, keyframes);
            }

            @Override
            public Pair<OptimizedExpression<Object>, OptimizedExpression<Object>> compile(List<SkinAnimationPoint> points) {
                OptimizedExpression<Object> effect = this.compile0(points);
                return Pair.of(effect, effect);
            }

            private OptimizedExpression<Object> compile0(List<SkinAnimationPoint> points) {
                ArrayList<OptimizedExpression> effects = Collections.compactMap(points, this::compile0);
                if (effects.size() == 1) {
                    return effects.get(0);
                }
                return context -> Collections.compactMap(effects, it -> it.evaluate(context));
            }

            private OptimizedExpression<Object> compile0(SkinAnimationPoint point) {
                if (point instanceof SkinAnimationPoint.Instruct) {
                    SkinAnimationPoint.Instruct instruct = (SkinAnimationPoint.Instruct)point;
                    return new AnimationInstructHandler(AnimationController.compileExpression(OpenPrimitive.of(instruct.script()), 0.0));
                }
                if (point instanceof SkinAnimationPoint.Sound) {
                    SkinAnimationPoint.Sound sound = (SkinAnimationPoint.Sound)point;
                    return new AnimationSoundHandler(sound);
                }
                if (point instanceof SkinAnimationPoint.Particle) {
                    SkinAnimationPoint.Particle particle = (SkinAnimationPoint.Particle)point;
                    return new AnimationParticleHandler(particle);
                }
                ModLog.warn("Not support point type: {}", point);
                return null;
            }
        }

        private static class Bone
        extends Channel<OpenVector3f> {
            private final float defaultValue;

            public Bone(String name, int duration, Selector selector, List<SkinAnimationKeyframe> keyframes) {
                super(name, duration, selector, keyframes);
                this.defaultValue = this.calcDefaultValue(selector);
            }

            @Override
            public Pair<OptimizedExpression<OpenVector3f>, OptimizedExpression<OpenVector3f>> compile(List<SkinAnimationPoint> points) {
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                for (SkinAnimationPoint point : points) {
                    if (point instanceof SkinAnimationPoint.Bone) {
                        SkinAnimationPoint.Bone bone = (SkinAnimationPoint.Bone)point;
                        expressions.add(AnimationController.compileExpression(bone.x(), this.defaultValue));
                        expressions.add(AnimationController.compileExpression(bone.y(), this.defaultValue));
                        expressions.add(AnimationController.compileExpression(bone.z(), this.defaultValue));
                        continue;
                    }
                    ModLog.warn("Not support point type: {}", point);
                    expressions.add(Constant.ZERO);
                    expressions.add(Constant.ZERO);
                    expressions.add(Constant.ZERO);
                }
                OptimizedExpression<OpenVector3f> left = OptimizedExpression.of((Expression)expressions.get(0), (Expression)expressions.get(1), (Expression)expressions.get(2));
                if (expressions.size() <= 3) {
                    return Pair.of(left, left);
                }
                OptimizedExpression<OpenVector3f> right = OptimizedExpression.of((Expression)expressions.get(3), (Expression)expressions.get(4), (Expression)expressions.get(5));
                return Pair.of(left, right);
            }

            private float calcDefaultValue(Selector selector) {
                if (selector instanceof Selector.Scale) {
                    return 1.0f;
                }
                return 0.0f;
            }
        }
    }

    private static class Fragment<T> {
        private final int startTime;
        private final OptimizedExpression<T> startValue;
        private final int endTime;
        private final OptimizedExpression<T> endValue;
        private final int length;
        private final SkinAnimationFunction function;

        public Fragment(int startTime, OptimizedExpression<T> startValue, int endTime, OptimizedExpression<T> endValue, SkinAnimationFunction function) {
            this.startTime = startTime;
            this.startValue = startValue;
            this.endTime = endTime;
            this.endValue = endValue;
            this.length = endTime - startTime;
            this.function = function;
        }

        public boolean contains(int time) {
            return this.startTime <= time && time < this.endTime;
        }

        public boolean isConstant() {
            return this.startValue.isConstant() && this.endValue.isConstant();
        }
    }

    private static class FragmentBuilder<T> {
        private final SkinAnimationFunction function;
        private int leftTime;
        private OptimizedExpression<T> leftValue;
        private int rightTime;
        private OptimizedExpression<T> rightValue;

        FragmentBuilder(int time, SkinAnimationFunction function, OptimizedExpression<T> leftValue, OptimizedExpression<T> rightValue) {
            this.function = function;
            this.leftTime = time;
            this.leftValue = leftValue;
            this.rightTime = time;
            this.rightValue = rightValue;
        }

        public FragmentBuilder<T> copyToBegin() {
            return new FragmentBuilder<T>(0, SkinAnimationFunction.linear(), this.leftValue, this.leftValue);
        }

        public FragmentBuilder<T> copyToEnd(int time) {
            return new FragmentBuilder<T>(time, SkinAnimationFunction.linear(), this.rightValue, this.rightValue);
        }

        public Fragment<T> build() {
            return new Fragment<T>(this.leftTime, this.leftValue, this.rightTime, this.rightValue, this.function);
        }
    }

    private static abstract class Selector {
        private Selector() {
        }

        public abstract void apply(float var1, float var2, float var3, AnimatedPoint var4);

        public void apply(OpenVector3f value, AnimatedPoint snapshot) {
            this.apply(value.x(), value.y(), value.z(), snapshot);
        }

        public static class Scale
        extends Selector {
            @Override
            public void apply(float x, float y, float z, AnimatedPoint output) {
                output.setScale(x, y, z);
            }
        }

        public static class Rotation
        extends Selector {
            @Override
            public void apply(float x, float y, float z, AnimatedPoint output) {
                output.setRotation(x, y, z);
            }
        }

        public static class Translation
        extends Selector {
            @Override
            public void apply(float x, float y, float z, AnimatedPoint output) {
                output.setTranslation(x, y, z);
            }
        }
    }
}

