/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.ILootFunction;
import moe.plushie.armourers_workshop.api.common.ILootFunctionType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AbstractLootItemFunctionType<T extends ILootFunction>
implements ILootFunctionType<T> {
    private final LootItemFunctionType type;

    public AbstractLootItemFunctionType(LootItemFunctionType type) {
        this.type = type;
    }

    public LootItemFunctionType getType() {
        return this.type;
    }

    public static <T extends ILootFunction> AbstractLootItemFunctionType<T> conditional(MapCodec<T> codec) {
        LootItemFunctionType[] type = new LootItemFunctionType[]{null};
        Supplier<LootItemFunctionType> getter = () -> type[0];
        type[0] = new LootItemFunctionType(new ConditionalFunction.Factory(getter, codec.codec()));
        return new AbstractLootItemFunctionType<T>(type[0]);
    }

    public static class ConditionalFunction<T extends ILootFunction>
    extends LootItemConditionalFunction {
        private final T value;
        private final Supplier<LootItemFunctionType> type;

        protected ConditionalFunction(T value, LootItemCondition[] args, Supplier<LootItemFunctionType> type) {
            super(args);
            this.type = type;
            this.value = value;
        }

        protected ItemStack m_7372_(ItemStack arg, LootContext arg2) {
            return this.value.apply(arg, arg2);
        }

        public void m_6169_(ValidationContext arg) {
            this.value.m_6169_(arg);
        }

        public Set<LootContextParam<?>> m_6231_() {
            return this.value.m_6231_();
        }

        public LootItemFunctionType m_7162_() {
            return this.type.get();
        }

        public static class Factory<T extends ILootFunction>
        extends LootItemConditionalFunction.Serializer<ConditionalFunction<T>> {
            private final Supplier<LootItemFunctionType> type;
            private final Codec<T> codec;

            public Factory(Supplier<LootItemFunctionType> type, Codec<T> codec) {
                this.type = type;
                this.codec = codec;
            }

            public void serialize(JsonObject object, ConditionalFunction<T> arg, JsonSerializationContext context) {
                super.m_6170_(object, arg, context);
                this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, arg.value).get().ifLeft(it -> ((JsonObject)it).entrySet().forEach(entry -> object.add((String)entry.getKey(), (JsonElement)entry.getValue())));
            }

            public ConditionalFunction<T> deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] args) {
                ILootFunction value = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).result().orElse(null);
                return new ConditionalFunction<ILootFunction>(value, args, this.type);
            }
        }
    }
}

