/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractTooltipContext;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHorizontalBlockImpl
extends HorizontalDirectionalBlock {
    public AbstractHorizontalBlockImpl(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public final List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        return this.getDrops(blockState, new LootContextBuilder(builder));
    }

    public List<ItemStack> getDrops(BlockState blockState, ILootContext context) {
        return super.m_49635_(blockState, ((LootContextBuilder)context).builder);
    }

    public final void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        this.destroyByPlayer(level, blockPos, blockState, player);
    }

    public BlockState destroyByPlayer(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        super.m_5707_(level, blockPos, blockState, player);
        return blockState;
    }

    public ItemStack getCloneItemStack(LevelReader blockGetter, BlockPos blockPos, BlockState blockState) {
        return super.m_7397_((BlockGetter)blockGetter, blockPos, blockState);
    }

    public final ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return this.getCloneItemStack((LevelReader)blockGetter, blockPos, blockState);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        InteractionHand interactionHand = InteractionHand.MAIN_HAND;
        if (blockState.m_60734_() != this) {
            return blockState.m_60734_().m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult.m_82430_(blockPos));
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public final InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return this.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    public void appendHoverText(ItemStack itemStack, List<Component> tooltips, ITooltipContext context) {
        AbstractTooltipContext context1 = (AbstractTooltipContext)Objects.unsafeCast(context);
        super.m_5871_(itemStack, (BlockGetter)context1.context, tooltips, context1.flag);
    }

    public final void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> tooltips, TooltipFlag tooltipFlag) {
        this.appendHoverText(itemStack, tooltips, new AbstractTooltipContext<BlockGetter>(blockGetter, tooltipFlag));
    }

    public static class LootContextBuilder
    implements ILootContext {
        private static final Map<ILootContextParam<?>, LootContextParam<?>> KEYS = Collections.immutableMap(it -> {
            it.put(ILootContextParam.THIS_ENTITY, (Object)LootContextParams.f_81455_);
            it.put(ILootContextParam.LAST_DAMAGE_PLAYER, (Object)LootContextParams.f_81456_);
            it.put(ILootContextParam.DAMAGE_SOURCE, (Object)LootContextParams.f_81457_);
            it.put(ILootContextParam.ATTACKING_ENTITY, (Object)LootContextParams.f_81458_);
            it.put(ILootContextParam.DIRECT_ATTACKING_ENTITY, (Object)LootContextParams.f_81459_);
            it.put(ILootContextParam.ORIGIN, (Object)LootContextParams.f_81460_);
            it.put(ILootContextParam.BLOCK_STATE, (Object)LootContextParams.f_81461_);
            it.put(ILootContextParam.BLOCK_ENTITY, (Object)LootContextParams.f_81462_);
            it.put(ILootContextParam.TOOL, (Object)LootContextParams.f_81463_);
            it.put(ILootContextParam.EXPLOSION_RADIUS, (Object)LootContextParams.f_81464_);
        });
        private final LootParams.Builder builder;

        public LootContextBuilder(LootParams.Builder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T getParameter(ILootContextParam<T> param) {
            Object value = this.builder.m_287261_(KEYS.get(param));
            return param.valueType().cast(this.convert(value));
        }

        @Override
        @Nullable
        public <T> T getOptionalParameter(ILootContextParam<T> param) {
            Object value = this.builder.m_287159_(KEYS.get(param));
            if (value != null) {
                return param.valueType().cast(this.convert(value));
            }
            return null;
        }

        private Object convert(Object value) {
            Vec3 pos = Objects.safeCast(value, Vec3.class);
            if (pos != null) {
                return new OpenVector3f(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            }
            return value;
        }
    }
}

