/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractPlayerModel<T extends LivingEntity>
extends PlayerModel<T> {
    public AbstractPlayerModel(AbstractEntityRendererProviderImpl.Context context, float scale, Type type) {
        super(context.m_174023_(type.layer), type == Type.SLIM);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer builder, int light, int overlay, int color) {
        float r = (float)ColorUtils.getRed(color) / 255.0f;
        float g = (float)ColorUtils.getGreen(color) / 255.0f;
        float b = (float)ColorUtils.getBlue(color) / 255.0f;
        float a = (float)ColorUtils.getAlpha(color) / 255.0f;
        super.m_7695_(poseStack, builder, light, overlay, r, g, b, a);
    }

    public final void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float r, float g, float b, float a) {
        int color = ColorUtils.getARGB((int)(a * 255.0f), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
        this.renderToBuffer(poseStack, vertexConsumer, light, overlay, color);
    }

    public static enum Type {
        NORMAL(ModelLayers.f_171162_),
        SLIM(ModelLayers.f_171166_);

        final ModelLayerLocation layer;

        private Type(ModelLayerLocation layer) {
            this.layer = layer;
        }
    }
}

