/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.model;

import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.model.IModelPartCollector;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.client.model.geom.ModelPart;

public class AbstractModelCollector {
    public static void collect(String root, Iterable<ModelPart> parts, Map<String, ModelPart> collector) {
        int i = 0;
        for (ModelPart part : parts) {
            String name = String.format("%s[%d]", root, i++);
            AbstractModelCollector.collect(name, part, collector);
        }
    }

    public static void collect(String root, Map<String, ModelPart> parts, Map<String, ModelPart> collector) {
        for (Map.Entry<String, ModelPart> entry : parts.entrySet()) {
            String name = entry.getKey();
            AbstractModelCollector.collect(name, entry.getValue(), collector);
        }
    }

    public static void collect(String name, ModelPart part, Map<String, ModelPart> collector) {
        collector.put(name, part);
        IModelPartCollector provider = Objects.safeCast(part, IModelPartCollector.class);
        if (provider == null) {
            return;
        }
        LinkedHashMap<String, ModelPart> child = new LinkedHashMap<String, ModelPart>();
        provider.aw2$collect(child);
        child.forEach((key, value) -> collector.put(name + "." + key, (ModelPart)value));
    }

    public static Map<String, String> apply(Class<?> clazz, Map<String, String> mapper) {
        return mapper;
    }
}

