/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.core.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IQuaternionf;
import moe.plushie.armourers_workshop.core.data.cache.ObjectPool;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.utils.MatrixUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractPoseStackImpl {
    protected static final ObjectPool<OpenPoseStack> REUSABLE_QUEUE = ObjectPool.create(OpenPoseStack::new);
    private static final Matrix3f CONVERTER_MAT3 = new Matrix3f();
    private static final Matrix4f CONVERTER_MAT4 = new Matrix4f();
    private static final Quaternionf CONVERTER_QUAT = new Quaternionf();
    private static final FloatBuffer BUFFER3x3 = MatrixUtils.createFloatBuffer(9);
    private static final FloatBuffer BUFFER4x4 = MatrixUtils.createFloatBuffer(16);

    public static OpenPoseStack create(Matrix4f matrixStack) {
        OpenPoseStack poseStack = REUSABLE_QUEUE.get();
        poseStack.last().pose().set(AbstractPoseStackImpl.convertMatrix(matrixStack));
        poseStack.last().normal().setIdentity();
        poseStack.last().setProperties(0);
        return poseStack;
    }

    public static AbstractMatrix3f convertMatrix(Matrix3f mat) {
        return new AbstractMatrix3f(mat);
    }

    public static Matrix3f convertMatrix(IMatrix3f mat) {
        if (mat instanceof AbstractMatrix3f) {
            AbstractMatrix3f newValue = (AbstractMatrix3f)mat;
            return newValue.mat;
        }
        mat.store(BUFFER3x3);
        CONVERTER_MAT3.set(BUFFER3x3);
        return CONVERTER_MAT3;
    }

    public static AbstractMatrix4f convertMatrix(Matrix4f mat) {
        return new AbstractMatrix4f(mat);
    }

    public static Matrix4f convertMatrix(IMatrix4f mat) {
        if (mat instanceof AbstractMatrix4f) {
            AbstractMatrix4f newValue = (AbstractMatrix4f)mat;
            return newValue.mat;
        }
        mat.store(BUFFER4x4);
        CONVERTER_MAT4.set(BUFFER4x4);
        return CONVERTER_MAT4;
    }

    public static Quaternionf convertQuaternion(IQuaternionf q) {
        CONVERTER_QUAT.set(q.x(), q.y(), q.z(), q.w());
        return CONVERTER_QUAT;
    }

    public static Quaternionf copyQuaternion(IQuaternionf q) {
        return new Quaternionf(q.x(), q.y(), q.z(), q.w());
    }

    public static class AbstractMatrix4f
    implements IMatrix4f {
        private final Matrix4f mat;

        public AbstractMatrix4f(Matrix4f mat) {
            this.mat = mat;
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.mat.set(buffer);
        }

        @Override
        public void store(FloatBuffer buffer) {
            this.mat.get(buffer);
        }

        @Override
        public void scale(float x, float y, float z) {
            this.mat.scale(x, y, z);
        }

        @Override
        public void translate(float x, float y, float z) {
            this.mat.translate(x, y, z);
        }

        @Override
        public void rotate(IQuaternionf q) {
            this.mat.rotate((Quaternionfc)AbstractPoseStackImpl.convertQuaternion(q));
        }

        @Override
        public void set(IMatrix4f matrix) {
            this.mat.set((Matrix4fc)AbstractPoseStackImpl.convertMatrix(matrix));
        }

        @Override
        public void multiply(IMatrix4f matrix) {
            this.mat.mul((Matrix4fc)AbstractPoseStackImpl.convertMatrix(matrix));
        }

        @Override
        public void multiply(float[] values) {
            Vector4f vec = new Vector4f(values[0], values[1], values[2], values[3]);
            vec.mul((Matrix4fc)this.mat);
            values[0] = vec.x();
            values[1] = vec.y();
            values[2] = vec.z();
            values[3] = vec.w();
        }

        @Override
        public void invert() {
            this.mat.invert();
        }

        @Override
        public void transpose() {
            this.mat.transpose();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractMatrix4f)) {
                return false;
            }
            AbstractMatrix4f that = (AbstractMatrix4f)o;
            return this.mat.equals((Object)that.mat);
        }

        public int hashCode() {
            return this.mat.hashCode();
        }
    }

    public static class AbstractMatrix3f
    implements IMatrix3f {
        private final Matrix3f mat;

        public AbstractMatrix3f(Matrix3f mat) {
            this.mat = mat;
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.mat.set(buffer);
        }

        @Override
        public void store(FloatBuffer buffer) {
            this.mat.get(buffer);
        }

        @Override
        public void scale(float x, float y, float z) {
            this.mat.scale(x, y, z);
        }

        @Override
        public void rotate(IQuaternionf q) {
            this.mat.rotate((Quaternionfc)AbstractPoseStackImpl.convertQuaternion(q));
        }

        @Override
        public void set(IMatrix3f matrix) {
            this.mat.set((Matrix3fc)AbstractPoseStackImpl.convertMatrix(matrix));
        }

        public void set(IMatrix4f matrix) {
            this.mat.set((Matrix4fc)AbstractPoseStackImpl.convertMatrix(matrix));
        }

        @Override
        public void multiply(IMatrix3f matrix) {
            this.mat.mul((Matrix3fc)AbstractPoseStackImpl.convertMatrix(matrix));
        }

        @Override
        public void multiply(float[] values) {
            Vector3f vec = new Vector3f(values[0], values[1], values[2]);
            vec.mul((Matrix3fc)this.mat);
            values[0] = vec.x();
            values[1] = vec.y();
            values[2] = vec.z();
        }

        @Override
        public void invert() {
            this.mat.invert();
        }

        @Override
        public void transpose() {
            this.mat.transpose();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractMatrix3f)) {
                return false;
            }
            AbstractMatrix3f that = (AbstractMatrix3f)o;
            return this.mat.equals((Object)that.mat);
        }

        public int hashCode() {
            return this.mat.hashCode();
        }
    }
}

