/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.UUID;
import moe.plushie.armourers_workshop.core.utils.Executors;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractCustomProfileTextureLoader {
    public static void load(GameProfile profile, ResultHandler handler) {
        int timeout = 30000;
        AbstractCustomProfileTextureLoader.load(profile, System.currentTimeMillis() + (long)timeout, handler);
    }

    private static void load(GameProfile profile, long endTime, ResultHandler handler) {
        if (profile.getProperties().isEmpty()) {
            OpenResourceLocation location = OpenResourceLocation.create(DefaultPlayerSkin.m_118627_((UUID)profile.getId()));
            String modelType = DefaultPlayerSkin.m_118629_((UUID)profile.getId());
            handler.accept(location, null, modelType);
            return;
        }
        EnvironmentManager.getClient().m_91109_().m_118817_(profile, (type, texture, profile1) -> {
            if (type != MinecraftProfileTexture.Type.SKIN) {
                return;
            }
            OpenResourceLocation location = OpenResourceLocation.create(texture);
            String url = profile1.getUrl();
            String modelType = profile1.getMetadata("model");
            if (url == null && System.currentTimeMillis() < endTime) {
                Executors.sleep(500L);
                AbstractCustomProfileTextureLoader.load(profile, endTime, handler);
                return;
            }
            handler.accept(location, url, modelType);
        }, false);
    }

    public static interface ResultHandler {
        public void accept(OpenResourceLocation var1, String var2, String var3);
    }
}

