/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.builder.other.CubeChanges;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CubeWrapper
implements IBlockPaintable {
    private final Consumer<CubeChanges> consumer;
    private final Level level;
    private BlockPos pos;
    private Supplier<BlockState> state;
    private Supplier<BlockEntity> blockEntity;
    private Supplier<IBlockPaintable> target;
    private CubeChanges changes;

    public CubeWrapper(Level level, Consumer<CubeChanges> consumer) {
        this.consumer = consumer;
        this.level = level;
    }

    public boolean is(Class<?> clazz) {
        if (Block.class.isAssignableFrom(clazz)) {
            return clazz.isInstance(this.block());
        }
        return clazz.isInstance(this.blockEntity());
    }

    public boolean is(Block block) {
        return this.blockState().m_60713_(block);
    }

    public Block block() {
        return this.blockState().m_60734_();
    }

    public BlockState blockState() {
        if (this.state != null) {
            return this.state.get();
        }
        if (this.pos != null) {
            BlockState state = this.level.m_8055_(this.pos);
            this.state = () -> state;
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void setBlockState(BlockState state) {
        this.lastChanges().setBlockState(state);
    }

    public void setBlockStateAndTag(BlockState state, CompoundTag nbt) {
        this.lastChanges().setBlockState(state);
        this.lastChanges().setCompoundTag(nbt);
    }

    public void setBlockStateAndColors(BlockState state, Map<OpenDirection, SkinPaintColor> colors) {
        this.lastChanges().setBlockState(state);
        this.lastChanges().setColors(colors);
    }

    @Nullable
    public BlockEntity blockEntity() {
        if (this.blockEntity != null) {
            return this.blockEntity.get();
        }
        if (this.pos != null) {
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            this.blockEntity = () -> blockEntity;
            return blockEntity;
        }
        return null;
    }

    @Nullable
    public CompoundTag blockTag() {
        BlockEntity blockEntity = this.blockEntity();
        if (blockEntity != null) {
            return StorageAPI.saveFullData(blockEntity, this.level.m_9598_());
        }
        return null;
    }

    @Override
    public SkinPaintColor getColor(OpenDirection direction) {
        IBlockPaintable target = this.target();
        if (target != null) {
            return target.getColor(direction);
        }
        return null;
    }

    @Override
    public void setColor(OpenDirection direction, SkinPaintColor color) {
        this.lastChanges().setColor(direction, color);
    }

    @Override
    public void setColors(Map<OpenDirection, SkinPaintColor> colors) {
        this.lastChanges().setColors(colors);
    }

    @Override
    public boolean shouldChangeColor(OpenDirection direction) {
        IBlockPaintable target = this.target();
        if (target != null) {
            return target.shouldChangeColor(direction);
        }
        return false;
    }

    public BlockPos blockPos() {
        return this.pos;
    }

    public void setBlockPos(BlockPos pos) {
        if (this.pos != pos) {
            this.submit();
        }
        this.pos = pos;
    }

    private IBlockPaintable target() {
        if (this.target != null) {
            return this.target.get();
        }
        IBlockPaintable target = Objects.safeCast(this.blockEntity(), IBlockPaintable.class);
        if (target != null) {
            this.target = () -> target;
            return target;
        }
        return null;
    }

    private CubeChanges lastChanges() {
        if (this.changes == null) {
            this.changes = new CubeChanges(this.level, this.pos);
        }
        return this.changes;
    }

    private void submit() {
        if (this.changes != null) {
            this.consumer.accept(this.changes);
            this.changes = null;
        }
        this.pos = null;
        this.state = null;
        this.blockEntity = null;
        this.target = null;
    }
}

