/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideDataProvider;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideRendererManager;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinDynamicTexture;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.TextureUtils;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerBlockRenderer<T extends ArmourerBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private final PlayerTextureOverride override = new PlayerTextureOverride();
    private final OpenRectangle3f originBox = new OpenRectangle3f(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f);
    private final GuideRendererManager rendererManager = new GuideRendererManager();

    public ArmourerBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        CustomTextureProvider textureProvider = CustomTextureProvider.of(entity);
        if (textureProvider == null) {
            return;
        }
        SkinType skinType = ((ArmourerBlockEntity)entity).skinType();
        SkinProperties skinProperties = ((ArmourerBlockEntity)entity).skinProperties();
        EntityTextureDescriptor.Model textureModel = ((ArmourerBlockEntity)entity).textureModel();
        IResourceLocation playerTexture = textureProvider.displayTextureLocation;
        if (playerTexture != null) {
            this.override.setTexture(playerTexture);
            this.override.setBuffers(bufferSource);
            bufferSource = this.override;
        }
        Boolean isMultiBlocks = skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK);
        boolean isShowGuides = ((ArmourerBlockEntity)entity).isShowGuides();
        boolean isShowModelGuides = ((ArmourerBlockEntity)entity).isShowModelGuides();
        boolean isShowHelper = ((ArmourerBlockEntity)entity).isShowHelper();
        boolean isUseHelper = ((ArmourerBlockEntity)entity).isUseHelper();
        textureProvider.shouldRenderOverlay = !isUseHelper;
        textureProvider.skinProperties = skinProperties;
        poseStack.pushPose();
        this.transform(poseStack, entity);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        float polygonOffset = 0.0f;
        for (SkinPartType skinPartType : skinType.parts()) {
            GuideRenderer guideRenderer;
            OpenVector3i origin = skinPartType.offset();
            OpenRectangle3i rect = skinPartType.buildingSpace();
            OpenRectangle3i rect2 = skinPartType.guideSpace(textureModel);
            float r = 0.5f;
            float g = 0.5f;
            float b = 0.5f;
            float a = 0.25f;
            if (skinPartType == SkinPartTypes.BLOCK_MULTI && !isMultiBlocks.booleanValue()) continue;
            if (skinPartType == SkinPartTypes.BLOCK && isMultiBlocks.booleanValue()) {
                r = 1.0f;
                g = 1.0f;
                b = 0.0f;
                a = 0.2f;
            }
            boolean isModelOverridden = ((ArmourerBlockEntity)entity).isModelOverridden(skinPartType);
            if (isUseHelper) {
                isModelOverridden = !isShowHelper;
            }
            poseStack.pushPose();
            poseStack.translate(origin.x(), origin.y() + rect.minY(), origin.z());
            poseStack.translate(polygonOffset, polygonOffset, polygonOffset);
            if (!isModelOverridden && (guideRenderer = this.rendererManager.getRenderer(textureModel, skinPartType)) != null) {
                poseStack.pushPose();
                poseStack.translate(0.0f, -rect2.minY(), 0.0f);
                poseStack.scale(16.0f, 16.0f, 16.0f);
                guideRenderer.render(poseStack, textureProvider, 0xF000F0, OverlayTexture.f_118083_, bufferSource);
                poseStack.popPose();
            }
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            if (isShowGuides) {
                ShapeTesselator.cube(rect, r, g, b, a, poseStack, bufferSource);
                ShapeTesselator.cube((IRectangle3f)this.originBox, 0.0f, 1.0f, 0.0f, 0.5f, poseStack, bufferSource);
            }
            if (isShowModelGuides && isModelOverridden) {
                ShapeTesselator.cube(rect2, 0.0f, 0.0f, 1.0f, 0.25f, poseStack, bufferSource);
            }
            poseStack.popPose();
            polygonOffset += 0.001f;
        }
        poseStack.popPose();
        this.override.setBuffers(null);
    }

    public void transform(IPoseStack poseStack, T entity) {
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.rotate(CubeTransform.getRotationDegrees(((ArmourerBlockEntity)entity).facing()));
    }

    public int m_142163_() {
        return 272;
    }

    public boolean shouldRenderOffScreen(T entity) {
        return true;
    }

    public static class PlayerTextureOverride
    implements IBufferSource {
        protected final HashMap<IRenderType, Supplier<IRenderType>> overrides = new HashMap();
        protected IResourceLocation texture;
        protected IBufferSource bufferSource;

        public void setBuffers(IBufferSource bufferSource) {
            this.bufferSource = bufferSource;
        }

        public void setTexture(IResourceLocation texture) {
            if (Objects.equals(this.texture, texture)) {
                return;
            }
            this.overrides.clear();
            this.overrides.put(SkinRenderType.PLAYER_CUTOUT_NO_CULL, () -> SkinRenderType.entityCutoutNoCull(texture));
            this.overrides.put(SkinRenderType.PLAYER_CUTOUT, () -> SkinRenderType.entityCutoutNoCull(texture));
            this.overrides.put(SkinRenderType.PLAYER_TRANSLUCENT, () -> SkinRenderType.entityTranslucentCull(texture));
        }

        @Override
        public IVertexConsumer getBuffer(IRenderType renderType) {
            Supplier<IRenderType> overrideRenderType = this.overrides.get(renderType);
            if (overrideRenderType != null) {
                renderType = overrideRenderType.get();
            }
            return this.bufferSource.getBuffer(renderType);
        }

        @Override
        public void endBatch() {
            this.bufferSource.endBatch();
        }
    }

    public static class CustomTextureProvider
    implements GuideDataProvider {
        protected final SkinDynamicTexture displayTexture = new SkinDynamicTexture();
        protected final IResourceLocation displayTextureLocation;
        protected int lastVersion;
        protected boolean shouldRenderOverlay = false;
        protected ISkinProperties skinProperties;

        public CustomTextureProvider(ArmourerBlockEntity blockEntity) {
            this.displayTextureLocation = TextureUtils.registerTexture(CustomTextureProvider.identifier(blockEntity), this.displayTexture);
        }

        public static CustomTextureProvider of(ArmourerBlockEntity blockEntity) {
            BlockEntityRenderData renderData = BlockEntityRenderData.of(blockEntity);
            if (renderData == null) {
                return null;
            }
            Object object = renderData.customTextureProvider();
            if (object instanceof CustomTextureProvider) {
                CustomTextureProvider textureProvider = (CustomTextureProvider)object;
                textureProvider.tick(blockEntity);
                return textureProvider;
            }
            CustomTextureProvider textureProvider = new CustomTextureProvider(blockEntity);
            renderData.setCustomTextureProvider(textureProvider);
            textureProvider.tick(blockEntity);
            return textureProvider;
        }

        public static String identifier(ArmourerBlockEntity blockEntity) {
            BlockPos pos = blockEntity.m_58899_();
            return String.format("aw-armourer-%d-%d-%d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }

        public void tick(ArmourerBlockEntity blockEntity) {
            this.displayTexture.setRefer(TextureUtils.getPlayerTextureLocation(blockEntity.textureDescriptor()));
            this.displayTexture.setPaintData(blockEntity.paintData());
        }

        @Override
        public boolean shouldRenderOverlay(SkinProperty<Boolean> property) {
            if (this.shouldRenderOverlay) {
                return this.skinProperties.get(property) == false;
            }
            return false;
        }
    }
}

