/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.util;

import com.p1nero.tudigong.client.screen.StructureSearchScreen;
import com.p1nero.tudigong.util.BiomeUtil;
import com.p1nero.tudigong.util.StructureUtils;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.text.WordUtils;

public class TextUtil {
    private static final String[] DIRECTIONS = new String[]{"direction.tudigong.east", "direction.tudigong.southeast", "direction.tudigong.south", "direction.tudigong.southwest", "direction.tudigong.west", "direction.tudigong.northwest", "direction.tudigong.north", "direction.tudigong.northeast"};

    public static Component getCardinalDirection(Player player, BlockPos target) {
        Vec3 p = player.m_20182_();
        Vec3 t = Vec3.m_82512_((Vec3i)target);
        double angle = Mth.m_14136_((double)(t.m_7094_() - p.m_7094_()), (double)(t.m_7096_() - p.m_7096_())) * 57.29577951308232;
        angle = Mth.m_14109_((double)angle, (double)360.0);
        int index = (int)Math.floor((angle + 22.5) / 45.0) & 7;
        return Component.m_237115_((String)DIRECTIONS[index]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String tryToGetName(String key) {
        if (!ResourceLocation.m_135830_((String)key)) {
            return key;
        }
        ResourceLocation resourceLocation = ResourceLocation.parse((String)key);
        return TextUtil.tryToGetName(resourceLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String tryToGetName(ResourceLocation resourceLocation) {
        if (StructureSearchScreen.STRUCTURE_NAME_MAP.containsKey((Object)resourceLocation)) {
            return StructureUtils.getPrettyStructureName(resourceLocation);
        }
        return BiomeUtil.getBiomeName(resourceLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getDimensionName(ResourceLocation dimensionKey) {
        String name = I18n.m_118938_((String)Util.m_137492_((String)"dimension", (ResourceLocation)dimensionKey), (Object[])new Object[0]);
        if (name.equals(Util.m_137492_((String)"dimension", (ResourceLocation)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }
}

