/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.datafixers.util.Pair;
import com.p1nero.tudigong.TDGConfig;
import com.p1nero.tudigong.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class StructureUtils {
    public static ListMultimap<ResourceLocation, ResourceLocation> getTypeKeysToStructureKeys(ServerLevel level) {
        ArrayListMultimap typeKeysToStructureKeys = ArrayListMultimap.create();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            typeKeysToStructureKeys.put((Object)StructureUtils.getTypeForStructure(level, structure), (Object)StructureUtils.getKeyForStructure(level, structure));
        }
        return typeKeysToStructureKeys;
    }

    public static Map<ResourceLocation, ResourceLocation> getStructureKeysToTypeKeys(ServerLevel level) {
        HashMap<ResourceLocation, ResourceLocation> structureKeysToStructureKeys = new HashMap<ResourceLocation, ResourceLocation>();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            structureKeysToStructureKeys.put(StructureUtils.getKeyForStructure(level, structure), StructureUtils.getTypeForStructure(level, structure));
        }
        return structureKeysToStructureKeys;
    }

    public static ResourceLocation getTypeForStructure(ServerLevel level, Structure structure) {
        Registry<StructureSet> registry = StructureUtils.getStructureSetRegistry(level);
        for (StructureSet set : registry) {
            for (StructureSet.StructureSelectionEntry entry : set.f_210003_()) {
                if (!((Structure)entry.f_210026_().get()).equals(structure)) continue;
                return registry.m_7981_((Object)set);
            }
        }
        ResourceLocation structureKey = StructureUtils.getKeyForStructure(level, structure);
        if (structureKey != null) {
            return new ResourceLocation(structureKey.m_135827_(), "mod_provided");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"tudigong", (String)"none");
    }

    public static ResourceLocation getKeyForStructure(ServerLevel level, Structure structure) {
        return StructureUtils.getStructureRegistry(level).m_7981_((Object)structure);
    }

    public static Structure getStructureForKey(ServerLevel level, ResourceLocation key) {
        return (Structure)StructureUtils.getStructureRegistry(level).m_7745_(key);
    }

    public static Holder<Structure> getHolderForStructure(ServerLevel level, Structure structure) {
        return StructureUtils.getStructureRegistry(level).m_263177_((Object)structure);
    }

    public static List<ResourceLocation> getAllowedStructureKeys(ServerLevel level) {
        ArrayList<ResourceLocation> structures = new ArrayList<ResourceLocation>();
        for (Structure structure : StructureUtils.getStructureRegistry(level)) {
            if (structure == null || StructureUtils.getKeyForStructure(level, structure) == null || StructureUtils.structureIsBlacklisted(level, structure) || StructureUtils.structureIsHidden(level, structure)) continue;
            structures.add(StructureUtils.getKeyForStructure(level, structure));
        }
        return structures;
    }

    public static boolean structureIsBlacklisted(ServerLevel level, Structure structure) {
        ArrayList structureBlacklist = new ArrayList();
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getKeyForStructure(level, structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    public static boolean structureIsHidden(ServerLevel level, Structure structure) {
        Registry<Structure> structureRegistry = StructureUtils.getStructureRegistry(level);
        return structureRegistry.m_263177_((Object)structure).getTagKeys().anyMatch(tag -> tag.f_203868_().m_135815_().equals("c:hidden_from_locator_selection"));
    }

    public static List<ResourceLocation> getGeneratingDimensionKeys(ServerLevel serverLevel, Structure structure) {
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        for (ServerLevel level : serverLevel.m_7654_().m_129785_()) {
            Set biomeSet = level.m_7726_().m_8481_().m_62218_().m_207840_();
            if (!structure.m_226559_().m_203614_().anyMatch(biomeSet::contains)) continue;
            dimensions.add(level.m_46472_().m_135782_());
        }
        if (structure.m_213658_() == StructureType.f_226875_ && dimensions.isEmpty()) {
            dimensions.add(ResourceLocation.parse((String)"minecraft:overworld"));
        }
        return dimensions;
    }

    public static ListMultimap<ResourceLocation, ResourceLocation> getGeneratingDimensionsForAllowedStructures(ServerLevel serverLevel) {
        ArrayListMultimap dimensionsForAllowedStructures = ArrayListMultimap.create();
        for (ResourceLocation structureKey : StructureUtils.getAllowedStructureKeys(serverLevel)) {
            Structure structure = StructureUtils.getStructureForKey(serverLevel, structureKey);
            if (structure == null) continue;
            dimensionsForAllowedStructures.putAll((Object)structureKey, StructureUtils.getGeneratingDimensionKeys(serverLevel, structure));
        }
        return dimensionsForAllowedStructures;
    }

    public static int getHorizontalDistanceToLocation(Player player, int x, int z) {
        return StructureUtils.getHorizontalDistanceToLocation(player.m_20183_(), x, z);
    }

    public static int getHorizontalDistanceToLocation(BlockPos startPos, int x, int z) {
        return (int)Mth.m_14116_((float)((float)startPos.m_123331_((Vec3i)new BlockPos(x, startPos.m_123342_(), z))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getPrettyStructureName(ResourceLocation key) {
        String name = key.toString();
        boolean translate = true;
        if (translate) {
            name = I18n.m_118938_((String)Util.m_137492_((String)"structure", (ResourceLocation)key), (Object[])new Object[0]);
        }
        if (name.equals(Util.m_137492_((String)"structure", (ResourceLocation)key)) || !translate) {
            name = key.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getPrettyStructureSource(ResourceLocation key) {
        if (key == null) {
            return "";
        }
        String registryEntry = key.toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String dimensionKeysToString(List<ResourceLocation> dimensions) {
        HashSet dimensionNames = new HashSet();
        dimensions.forEach(key -> dimensionNames.add(TextUtil.getDimensionName(key)));
        return String.join((CharSequence)", ", dimensionNames);
    }

    private static Registry<Structure> getStructureRegistry(ServerLevel level) {
        return (Registry)level.m_9598_().m_6632_(Registries.f_256944_).orElseThrow();
    }

    private static Registry<StructureSet> getStructureSetRegistry(ServerLevel level) {
        return (Registry)level.m_9598_().m_6632_(Registries.f_256998_).orElseThrow();
    }

    private static String convertToRegex(String glob) {
        StringBuilder regex = new StringBuilder("^");
        block5: for (char c : glob.toCharArray()) {
            switch (c) {
                case '*': {
                    regex.append(".*");
                    continue block5;
                }
                case '?': {
                    regex.append(".");
                    continue block5;
                }
                case '.': {
                    regex.append("\\.");
                    continue block5;
                }
                default: {
                    regex.append(c);
                }
            }
        }
        regex.append("$");
        return regex.toString();
    }

    public static Optional<ResourceKey<Structure>> findStructureByTypeName(RegistryAccess registryAccess, String typeNameQuery) {
        Registry structureRegistry = registryAccess.m_175515_(Registries.f_256944_);
        Registry typeRegistry = registryAccess.m_175515_(Registries.f_256938_);
        String lowerCaseQuery = typeNameQuery.toLowerCase();
        return structureRegistry.m_6579_().stream().filter(entry -> {
            StructureType structureType = ((Structure)entry.getValue()).m_213658_();
            Optional typeKeyOpt = typeRegistry.m_7854_((Object)structureType);
            return typeKeyOpt.map(key -> key.m_135782_().m_135815_().toLowerCase().contains(lowerCaseQuery)).orElse(false);
        }).map(Map.Entry::getKey).findFirst();
    }

    @Nullable
    public static BlockPos getNearbyStructurePos(ServerPlayer serverPlayer, String structureId, int y) {
        BlockPos playerPos;
        ServerLevel serverLevel = serverPlayer.m_284548_();
        ResourceLocation structureResourceLocation = ResourceLocation.m_135820_((String)structureId);
        if (structureResourceLocation == null) {
            return null;
        }
        ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureResourceLocation);
        Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
        Optional structureHolderOpt = structureRegistry.m_203636_(structureKey);
        if (structureHolderOpt.isEmpty()) {
            return null;
        }
        HolderSet.Direct structureSet = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureHolderOpt.get()});
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        Pair result = chunkGenerator.m_223037_(serverLevel, (HolderSet)structureSet, playerPos = serverPlayer.m_20183_(), ((Integer)TDGConfig.STRUCTURE_SEARCH_RADIUS_CHUNKS.get()).intValue(), ((Boolean)TDGConfig.AVOID_DUPLICATE_SEARCHES.get()).booleanValue());
        if (result != null) {
            BlockPos structurePos = (BlockPos)result.getFirst();
            return new BlockPos(structurePos.m_123341_(), y, structurePos.m_123343_());
        }
        return null;
    }

    public static Optional<ResourceLocation> getRandomStructureForSet(ServerLevel level, String setName) {
        ResourceLocation setLocation = ResourceLocation.m_135820_((String)setName);
        if (setLocation == null) {
            return Optional.empty();
        }
        ResourceKey setKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)setLocation);
        Registry<StructureSet> registry = StructureUtils.getStructureSetRegistry(level);
        Optional structureSetHolder = registry.m_203636_(setKey);
        if (structureSetHolder.isEmpty()) {
            return Optional.empty();
        }
        List structures = ((StructureSet)((Holder.Reference)structureSetHolder.get()).get()).f_210003_();
        if (structures.isEmpty()) {
            return Optional.empty();
        }
        int totalWeight = 0;
        for (StructureSet.StructureSelectionEntry entry : structures) {
            totalWeight += entry.f_210027_();
        }
        if (totalWeight == 0) {
            return ((StructureSet.StructureSelectionEntry)structures.get(new Random().nextInt(structures.size()))).f_210026_().m_203543_().map(ResourceKey::m_135782_);
        }
        int randomWeight = new Random().nextInt(totalWeight);
        int currentWeight = 0;
        for (StructureSet.StructureSelectionEntry entry : structures) {
            if (randomWeight >= (currentWeight += entry.f_210027_())) continue;
            return entry.f_210026_().m_203543_().map(ResourceKey::m_135782_);
        }
        return Optional.empty();
    }
}

