/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.util;

import com.mojang.datafixers.util.Pair;
import com.p1nero.tudigong.TDGConfig;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class StructureUtil {
    public static boolean isInStructure(LivingEntity entity, String structure) {
        if (entity.m_9236_().f_46443_) {
            return false;
        }
        return StructureUtil.matches((ResourceKey<Structure>)ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)ResourceLocation.parse((String)structure)), (ServerLevel)entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public static boolean matches(ResourceKey<Structure> resourceKey, ServerLevel serverLevel, double x, double y, double z) {
        return StructureUtil.matches(resourceKey, serverLevel, (float)x, (float)y, (float)z);
    }

    public static boolean matches(ResourceKey<Structure> resourceKey, ServerLevel serverLevel, float x, float y, float z) {
        BlockPos blockpos = new BlockPos((int)x, (int)y, (int)z);
        return resourceKey != null && serverLevel.m_46749_(blockpos) && serverLevel.m_215010_().m_220488_(blockpos, resourceKey).m_73603_();
    }

    @Nullable
    public static BlockPos getNearbyStructurePos(ServerPlayer serverPlayer, String structureId, int y) {
        BlockPos playerPos;
        ServerLevel serverLevel = serverPlayer.m_284548_();
        ResourceLocation structureResourceLocation = ResourceLocation.m_135820_((String)structureId);
        if (structureResourceLocation == null) {
            return null;
        }
        ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureResourceLocation);
        Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
        Optional structureHolderOpt = structureRegistry.m_203636_(structureKey);
        if (structureHolderOpt.isEmpty()) {
            return null;
        }
        HolderSet.Direct structureSet = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureHolderOpt.get()});
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        Pair result = chunkGenerator.m_223037_(serverLevel, (HolderSet)structureSet, playerPos = serverPlayer.m_20183_(), ((Integer)TDGConfig.STRUCTURE_SEARCH_RADIUS_CHUNKS.get()).intValue(), false);
        if (result != null) {
            BlockPos structurePos = (BlockPos)result.getFirst();
            return new BlockPos(structurePos.m_123341_(), y, structurePos.m_123343_());
        }
        return null;
    }

    public static Optional<ResourceKey<Structure>> findStructureByTypeName(RegistryAccess registryAccess, String typeNameQuery) {
        Registry structureRegistry = registryAccess.m_175515_(Registries.f_256944_);
        Registry typeRegistry = registryAccess.m_175515_(Registries.f_256938_);
        String lowerCaseQuery = typeNameQuery.toLowerCase();
        return structureRegistry.m_6579_().stream().filter(entry -> {
            StructureType structureType = ((Structure)entry.getValue()).m_213658_();
            Optional typeKeyOpt = typeRegistry.m_7854_((Object)structureType);
            return typeKeyOpt.map(key -> key.m_135782_().m_135815_().toLowerCase().contains(lowerCaseQuery)).orElse(false);
        }).map(Map.Entry::getKey).findFirst();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureName(ResourceLocation key) {
        String name = I18n.m_118938_((String)Util.m_137492_((String)"structure", (ResourceLocation)key), (Object[])new Object[0]);
        if (name.equals(Util.m_137492_((String)"structure", (ResourceLocation)key))) {
            name = key.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }
}

