/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.p1nero.tudigong.TuDiGongMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;

public class StructureTagManager {
    private static final Gson GSON = new Gson();
    private static final File CONFIG_FILE = new File(FMLPaths.CONFIGDIR.get().toFile(), "tudigong/structure_tags.json");
    private static Map<String, Set<ResourceLocation>> tags = new HashMap<String, Set<ResourceLocation>>();

    public static void load() {
        tags.clear();
        if (!CONFIG_FILE.exists()) {
            StructureTagManager.createDefaultConfigFile();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root != null && root.has("tags")) {
                Type tagsType = new TypeToken<Map<String, List<String>>>(){}.getType();
                Map rawTags = (Map)GSON.fromJson(root.get("tags"), tagsType);
                if (rawTags != null) {
                    rawTags.forEach((tag, structures) -> {
                        Set locs = structures.stream().map(ResourceLocation::parse).collect(Collectors.toSet());
                        tags.put(tag.toLowerCase(), locs);
                    });
                }
            }
        }
        catch (Exception e) {
            TuDiGongMod.LOGGER.error("Failed to load structure tags", (Throwable)e);
        }
    }

    private static void createDefaultConfigFile() {
        CONFIG_FILE.getParentFile().mkdirs();
        LinkedHashMap<String, Object> defaultConfig = new LinkedHashMap<String, Object>();
        defaultConfig.put("//", "Maps a tag name to a list of structure resource locations. Example below.");
        LinkedHashMap<String, List> exampleTags = new LinkedHashMap<String, List>();
        exampleTags.put("village", Collections.singletonList("minecraft:village_plains"));
        exampleTags.put("ocean", Arrays.asList("minecraft:shipwreck", "minecraft:ocean_ruin_warm"));
        defaultConfig.put("tags", exampleTags);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            new GsonBuilder().setPrettyPrinting().create().toJson(defaultConfig, (Appendable)writer);
        }
        catch (Exception e) {
            TuDiGongMod.LOGGER.error("Failed to create default structure tags config", (Throwable)e);
        }
        exampleTags.forEach((tag, structures) -> {
            Set locs = structures.stream().map(ResourceLocation::parse).collect(Collectors.toSet());
            tags.put(tag.toLowerCase(), locs);
        });
    }

    public static Optional<ResourceLocation> getRandomStructureForTag(String tagName) {
        Set<ResourceLocation> structures = tags.get(tagName = tagName.toLowerCase());
        if (structures == null || structures.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>(structures);
        return Optional.of((ResourceLocation)structureList.get(new Random().nextInt(structureList.size())));
    }

    public static Map<String, Set<ResourceLocation>> getTags() {
        return tags;
    }

    public static boolean createTag(String tagName) {
        if (tags.containsKey(tagName = tagName.toLowerCase())) {
            return false;
        }
        tags.put(tagName, new HashSet());
        return true;
    }

    public static boolean addStructureToTag(String tagName, ResourceLocation structureId) {
        if (!tags.containsKey(tagName = tagName.toLowerCase())) {
            return false;
        }
        return tags.get(tagName).add(structureId);
    }

    public static boolean removeStructureFromTag(String tagName, ResourceLocation structureId) {
        if (!tags.containsKey(tagName = tagName.toLowerCase())) {
            return false;
        }
        return tags.get(tagName).remove(structureId);
    }

    public static void save() {
        CONFIG_FILE.getParentFile().mkdirs();
        HashMap serializableTags = new HashMap();
        tags.forEach((tag, locs) -> {
            List locStrings = locs.stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList());
            serializableTags.put(tag, locStrings);
        });
        LinkedHashMap<String, Object> configToWrite = new LinkedHashMap<String, Object>();
        configToWrite.put("//", "Maps a tag name to a list of structure resource locations.");
        configToWrite.put("tags", serializableTags);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            new GsonBuilder().setPrettyPrinting().create().toJson(configToWrite, (Appendable)writer);
        }
        catch (Exception e) {
            TuDiGongMod.LOGGER.error("Failed to save structure tags config", (Throwable)e);
        }
    }
}

