/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.util;

import com.p1nero.tudigong.util.CommandUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BiomeUtil {
    private static final Pattern LOCATE_BIOME_PATTERN = Pattern.compile(".*?\\[\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*\\].*");

    @Nullable
    public static BlockPos getNearbyBiomePos(ServerPlayer serverPlayer, String biomeId) {
        return BiomeUtil.getLocateBiomePos(serverPlayer, biomeId);
    }

    public static BlockPos getLocateBiomePos(ServerPlayer serverPlayer, String biomeId) {
        String output = CommandUtil.getCommandOutput(serverPlayer.m_284548_(), serverPlayer.m_20182_(), "/locate biome " + biomeId);
        Matcher matcher = LOCATE_BIOME_PATTERN.matcher(output);
        if (matcher.find()) {
            try {
                String xStr = matcher.group(1).trim();
                String yStr = matcher.group(2).trim();
                String zStr = matcher.group(3).trim();
                return new BlockPos(Integer.parseInt(xStr), Integer.parseInt(yStr), Integer.parseInt(zStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(ResourceLocation key) {
        return I18n.m_118938_((String)Util.m_137492_((String)"biome", (ResourceLocation)key), (Object[])new Object[0]);
    }
}

