/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.network.packet.server;

import com.p1nero.dialog_lib.network.packet.BasePacket;
import com.p1nero.tudigong.entity.TudiGongEntity;
import com.p1nero.tudigong.util.StructureTagManager;
import com.p1nero.tudigong.util.StructureUtils;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record HandleSearchPacket(int entityID, String searchString, boolean isStructure) implements BasePacket
{
    private static final String TAG_PREFIX = "#";
    private static final String SET_PREFIX = "$";

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID());
        buf.m_130070_(this.searchString());
        buf.writeBoolean(this.isStructure);
    }

    public static HandleSearchPacket decode(FriendlyByteBuf buf) {
        return new HandleSearchPacket(buf.readInt(), buf.m_130277_(), buf.readBoolean());
    }

    public void execute(@Nullable Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Entity entity = serverPlayer.m_9236_().m_6815_(this.entityID());
        if (!(entity instanceof TudiGongEntity)) {
            return;
        }
        TudiGongEntity tudiGongEntity = (TudiGongEntity)entity;
        this.resolveResourceLocation(serverPlayer).ifPresent(resourceLocation -> tudiGongEntity.handleSearch(serverPlayer, this.searchString, (ResourceLocation)resourceLocation, this.isStructure));
    }

    private Optional<ResourceLocation> resolveResourceLocation(ServerPlayer player) {
        if (this.isStructure) {
            if (this.searchString.startsWith(TAG_PREFIX)) {
                return this.handleTagSearch(player);
            }
            if (this.searchString.startsWith(SET_PREFIX)) {
                return this.handleStructureSetSearch(player);
            }
        }
        return this.handleDirectSearch(player);
    }

    private Optional<ResourceLocation> handleTagSearch(ServerPlayer player) {
        String tagName = this.searchString.substring(TAG_PREFIX.length());
        Optional<ResourceLocation> structureOpt = StructureTagManager.getRandomStructureForTag(tagName);
        if (structureOpt.isEmpty()) {
            player.m_213846_((Component)Component.m_237110_((String)"error.tudigong.tag_not_found", (Object[])new Object[]{tagName}));
        }
        return structureOpt;
    }

    private Optional<ResourceLocation> handleStructureSetSearch(ServerPlayer player) {
        String setName = this.searchString.substring(SET_PREFIX.length());
        Optional<ResourceLocation> structureOpt = StructureUtils.getRandomStructureForSet(player.m_284548_(), setName);
        if (structureOpt.isEmpty()) {
            player.m_213846_((Component)Component.m_237110_((String)"error.tudigong.set_not_found", (Object[])new Object[]{setName}));
        }
        return structureOpt;
    }

    private Optional<ResourceLocation> handleDirectSearch(ServerPlayer player) {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(this.searchString);
            return Optional.of(resourceLocation);
        }
        catch (ResourceLocationException e) {
            return StructureUtils.findStructureByTypeName((RegistryAccess)player.f_8924_.m_206579_(), this.searchString).map(key -> Optional.of(key.m_135782_())).orElseGet(() -> {
                player.m_213846_((Component)Component.m_237110_((String)"error.tudigong.invalid_resource_location", (Object[])new Object[]{this.searchString}));
                return Optional.empty();
            });
        }
    }
}

