/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.network.packet.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SyncStructureTypesPacket {
    private final Map<String, Set<ResourceLocation>> types;
    private final Map<ResourceLocation, ResourceLocation> structureToTypeMap;

    public SyncStructureTypesPacket(Map<ResourceLocation, Collection<ResourceLocation>> types, Map<ResourceLocation, ResourceLocation> structureToTypeMap) {
        this.types = new HashMap<String, Set<ResourceLocation>>();
        types.forEach((key, value) -> this.types.put(key.toString(), new HashSet(value)));
        this.structureToTypeMap = structureToTypeMap;
    }

    private SyncStructureTypesPacket(FriendlyByteBuf buf) {
        this.types = buf.m_236847_(FriendlyByteBuf::m_130277_, b -> (Set)b.m_236838_(HashSet::new, FriendlyByteBuf::m_130281_));
        this.structureToTypeMap = buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::m_130281_);
    }

    public static SyncStructureTypesPacket decode(FriendlyByteBuf buf) {
        return new SyncStructureTypesPacket(buf);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236831_(this.types, FriendlyByteBuf::m_130070_, (b, v) -> b.m_236828_((Collection)v, FriendlyByteBuf::m_130085_));
        buf.m_236831_(this.structureToTypeMap, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130085_);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx, BiConsumer<Map<String, Set<ResourceLocation>>, Map<ResourceLocation, ResourceLocation>> consumer) {
        ctx.get().enqueueWork(() -> consumer.accept(this.types, this.structureToTypeMap));
        ctx.get().setPacketHandled(true);
    }
}

