/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.network.packet.client;

import com.p1nero.dialog_lib.network.packet.BasePacket;
import com.p1nero.tudigong.client.screen.BiomeSearchScreen;
import com.p1nero.tudigong.client.screen.StructureSearchScreen;
import com.p1nero.tudigong.util.BiomeUtil;
import com.p1nero.tudigong.util.StructureUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record SyncResourceKeysPacket(List<ResourceLocation> resourceLocations, boolean isStructure) implements BasePacket
{
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isStructure);
        buf.writeInt(this.resourceLocations.size());
        this.resourceLocations.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
    }

    public static SyncResourceKeysPacket decode(FriendlyByteBuf buf) {
        boolean isStructure = buf.readBoolean();
        int size = buf.readInt();
        ArrayList<ResourceLocation> newResourceLocations = new ArrayList<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            newResourceLocations.add(buf.m_130281_());
        }
        return new SyncResourceKeysPacket(newResourceLocations, isStructure);
    }

    public void execute(@Nullable Player playerEntity) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            if (this.isStructure) {
                StructureSearchScreen.STRUCTURE_NAME_MAP.clear();
                StructureSearchScreen.STRUCTURE_MOD_IDS.clear();
                this.resourceLocations.forEach(resourceLocation -> {
                    StructureSearchScreen.STRUCTURE_NAME_MAP.put(resourceLocation, (Object)StructureUtils.getPrettyStructureName(resourceLocation));
                    String modId = resourceLocation.m_135827_().toLowerCase();
                    StructureSearchScreen.STRUCTURE_MOD_IDS.computeIfAbsent(modId, k -> new HashSet()).add(resourceLocation);
                });
            } else {
                BiomeSearchScreen.BIOME_NAME_MAP.clear();
                BiomeSearchScreen.BIOME_MOD_IDS.clear();
                this.resourceLocations.forEach(resourceLocation -> {
                    BiomeSearchScreen.BIOME_NAME_MAP.put(resourceLocation, (Object)BiomeUtil.getBiomeName(resourceLocation));
                    String modId = resourceLocation.m_135827_().toLowerCase();
                    BiomeSearchScreen.BIOME_MOD_IDS.computeIfAbsent(modId, k -> new HashSet()).add(resourceLocation);
                });
            }
        }
    }
}

