/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.p1nero.tudigong.entity.TudiGongEntity;
import com.p1nero.tudigong.entity.client.TudiGongModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class TudiGongRenderer
extends MobRenderer<TudiGongEntity, TudiGongModel<TudiGongEntity>> {
    public TudiGongRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new TudiGongModel(pContext.m_174023_(TudiGongModel.LAYER_LOCATION)), 0.2f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TudiGongEntity pEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"tudigong", (String)"textures/entity/tudigong.png");
    }

    public void render(@NotNull TudiGongEntity tudiGongEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int p_115460_) {
        poseStack.m_85836_();
        int tickCount = tudiGongEntity.f_19797_;
        int timeLeft = tudiGongEntity.getRemoveTimer();
        int max = tudiGongEntity.maxRemoveTime;
        float floatingHeight = this.calculateFloatingHeight(tudiGongEntity, partialTicks) + 0.5f;
        float spiralHeight = tudiGongEntity.canInteract() ? 0.0f : TudiGongRenderer.getSpiralHeight(tickCount, max, timeLeft) - 2.0f;
        poseStack.m_85837_(0.0, 0.2 + (double)floatingHeight + (double)spiralHeight, 0.0);
        if (!tudiGongEntity.canInteract()) {
            float rotationAngle = ((float)tudiGongEntity.m_9236_().m_46467_() + partialTicks) * 10.0f;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationAngle));
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        super.m_7392_((Mob)tudiGongEntity, entityYaw, partialTicks, poseStack, bufferSource, p_115460_);
        poseStack.m_85849_();
    }

    private static float getSpiralHeight(int tickCount, int max, int timeLeft) {
        float progress = (float)(timeLeft > 0 ? timeLeft : tickCount) / (float)max;
        return 2.0f * Mth.m_14031_((float)(progress * (float)Math.PI * 0.5f));
    }

    private float calculateFloatingHeight(TudiGongEntity entity, float partialTicks) {
        float SPEED = 0.1f;
        float BOBBING_SCALE = 0.05f;
        float time = ((float)entity.m_9236_().m_46467_() + partialTicks) * 0.1f;
        float entityPhase = (float)entity.m_19879_() * 0.1f;
        return Mth.m_14089_((float)(time + entityPhase)) * 0.05f;
    }
}

