/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.entity;

import com.p1nero.dialog_lib.api.entity.custom.IEntityNpc;
import com.p1nero.dialog_lib.api.entity.goal.LookAtConservingPlayerGoal;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.client.screen.builder.StreamDialogueScreenBuilder;
import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.tudigong.TDGConfig;
import com.p1nero.tudigong.block.custom.TuDiTempleBlockEntity;
import com.p1nero.tudigong.client.screen.BiomeSearchScreen;
import com.p1nero.tudigong.client.screen.StructureSearchScreen;
import com.p1nero.tudigong.compat.JourneyMapCompat;
import com.p1nero.tudigong.compat.XaeroMapCompat;
import com.p1nero.tudigong.entity.XianQiEntity;
import com.p1nero.tudigong.network.TDGPacketHandler;
import com.p1nero.tudigong.network.packet.client.SyncHistoryEntryPacket;
import com.p1nero.tudigong.util.BiomeUtil;
import com.p1nero.tudigong.util.StructureUtils;
import com.p1nero.tudigong.util.TextUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TudiGongEntity
extends PathfinderMob
implements IEntityNpc {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Boolean> IS_REMOVED = SynchedEntityData.m_135353_(TudiGongEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> REMOVE_TIMER = SynchedEntityData.m_135353_(TudiGongEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final int maxRemoveTime = 60;
    public final int maxLifeTime = 1200;
    private Vec3 from = Vec3.f_82478_;
    private Vec3 dir = Vec3.f_82478_;
    private int startTick = 0;
    public BlockPos homePos;

    public TudiGongEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LookAtConservingPlayerGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(REMOVE_TIMER, (Object)0);
        this.f_19804_.m_135372_(IS_REMOVED, (Object)false);
    }

    public void setMarkRemoved() {
        this.setRemoveTimer(60);
        this.m_20088_().m_135381_(IS_REMOVED, (Object)true);
    }

    public boolean isMarkRemoved() {
        return (Boolean)this.m_20088_().m_135370_(IS_REMOVED);
    }

    public void countRemove() {
        if (!this.isMarkRemoved()) {
            return;
        }
        int timer = this.getRemoveTimer();
        if (timer > 0) {
            this.setRemoveTimer(timer - 1);
        }
        if (timer <= 1) {
            this.noticeHomeAndDiscard();
        }
    }

    public void setHomePos(BlockPos homePos) {
        this.homePos = homePos;
    }

    public void setRemoveTimer(int timer) {
        this.f_19804_.m_135381_(REMOVE_TIMER, (Object)timer);
    }

    public int getRemoveTimer() {
        return (Integer)this.f_19804_.m_135370_(REMOVE_TIMER);
    }

    public boolean canInteract() {
        return !this.isMarkRemoved() && this.f_19797_ > 60;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.canInteract()) {
                for (int i = 0; i < 5; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    double velocityY = this.f_19796_.m_188500_() * 0.2 + 0.1;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), offsetX, velocityY, offsetZ);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), offsetX, velocityY, offsetZ);
                }
            } else {
                Vec3 position = this.m_20182_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, position.f_82479_, position.f_82480_ + 0.5, position.f_82481_, 0.0, 0.0, 0.0);
            }
        } else {
            if (!this.canInteract()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144210_, SoundSource.BLOCKS, this.f_19796_.m_188501_() + 0.5f, this.f_19796_.m_188501_() + 0.5f);
            }
            if (this.getRemoveTimer() > 1) {
                SimpleParticleType particle = ParticleTypes.f_123810_;
                int particleCount = 20;
                double step = 5.0 / (double)particleCount;
                for (int i = this.f_19797_ - this.startTick; i <= particleCount; ++i) {
                    double distance = (double)i * step;
                    Vec3 particlePos = this.from.m_82549_(this.dir.m_82490_(distance).m_82520_(0.0, (double)i * 0.1, 0.0));
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)particle, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0, this.dir.f_82479_, this.dir.f_82480_, this.dir.f_82481_, (double)0.1f);
                }
            }
            this.countRemove();
            if (this.canInteract() && this.f_19797_ > (Integer)TDGConfig.TUDIGONG_LIFETIME_TICKS.get()) {
                this.setMarkRemoved();
            }
            if (this.getConversingPlayer() != null) {
                this.f_19797_ = 60;
            }
        }
    }

    public void noticeHomeAndDiscard() {
        BlockEntity blockEntity;
        if (this.homePos != null && (blockEntity = this.m_9236_().m_7702_(this.homePos)) instanceof TuDiTempleBlockEntity) {
            TuDiTempleBlockEntity tuDiTempleBlockEntity = (TuDiTempleBlockEntity)blockEntity;
            tuDiTempleBlockEntity.reset();
        }
        this.m_146870_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float value) {
        if (!this.canInteract()) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (this.getConversingPlayer() != null) {
                return false;
            }
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128379_("from_hurt", true);
            this.sendDialogTo(serverPlayer, compoundTag);
            source.m_7639_().m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), value * 0.5f);
            EntityType.f_20465_.m_262496_(serverPlayer.m_284548_(), serverPlayer.m_20097_(), MobSpawnType.MOB_SUMMONED);
        }
        return source.m_19390_();
    }

    public boolean m_20068_() {
        return true;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.canInteract() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendDialogTo(serverPlayer);
        }
        return InteractionResult.CONSUME;
    }

    @OnlyIn(value=Dist.CLIENT)
    public DialogueScreen getDialogueScreen(CompoundTag compoundTag) {
        StreamDialogueScreenBuilder builder = new StreamDialogueScreenBuilder((Entity)this, "tudigong");
        if (compoundTag.m_128471_("from_hurt")) {
            builder.start(0).addFinalOption(0);
        } else {
            builder.start(1).addFinalOption(1, 2, dialogueScreen -> Minecraft.m_91087_().m_91152_((Screen)new StructureSearchScreen(this.m_19879_()))).addFinalOption(2, 2, dialogueScreen -> Minecraft.m_91087_().m_91152_((Screen)new BiomeSearchScreen(this.m_19879_()))).addFinalOption(3, 3);
        }
        return builder.build();
    }

    public void handleNpcInteraction(ServerPlayer serverPlayer, int i) {
        if (i == 3) {
            this.setMarkRemoved();
        }
        if (i != 2) {
            this.setConversingPlayer(null);
        }
    }

    public void handleSearch(ServerPlayer serverPlayer, String originalSearchTerm, ResourceLocation resourceLocation, boolean isStructure) {
        BlockPos blockpos;
        LOGGER.info("Player {} located {} (isStructure: {}) using term '{}'", (Object)serverPlayer.m_7755_().getString(), (Object)resourceLocation.toString(), (Object)isStructure, (Object)originalSearchTerm);
        this.setConversingPlayer(null);
        if (isStructure && ((List)TDGConfig.STRUCTURE_BLACKLIST.get()).contains(resourceLocation.toString())) {
            serverPlayer.m_5661_((Component)ComponentUtils.m_130748_((Component)this.m_5446_()).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"entity.tudigong.tudigong.tudigong.answer5")), false);
            return;
        }
        BlockPos blockPos = blockpos = isStructure ? StructureUtils.getNearbyStructurePos(serverPlayer, resourceLocation.toString(), -1145) : BiomeUtil.getNearbyBiomePos(serverPlayer, resourceLocation.toString());
        if (blockpos == null) {
            LOGGER.warn("Could not find location for {}, possibly blocked by other mods.", (Object)resourceLocation.toString());
            serverPlayer.m_5661_((Component)ComponentUtils.m_130748_((Component)this.m_5446_()).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"entity.tudigong.tudigong.tudigong.answer5")), false);
            return;
        }
        MutableComponent typeComponent = Component.m_237115_((String)(isStructure ? "history.tudigong.type.structure" : "history.tudigong.type.biome"));
        SyncHistoryEntryPacket historyPacket = new SyncHistoryEntryPacket(originalSearchTerm, (Component)typeComponent, blockpos, (ResourceKey<Level>)serverPlayer.m_9236_().m_46472_());
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)historyPacket, (ServerPlayer)serverPlayer);
        int distance = (int)Math.sqrt(serverPlayer.m_20183_().m_123331_((Vec3i)blockpos));
        Component direction = TextUtil.getCardinalDirection((Player)serverPlayer, blockpos);
        String structureName = TextUtil.tryToGetName(resourceLocation);
        MutableComponent message = Component.m_237110_((String)"message.tudigong.location_found", (Object[])new Object[]{direction, distance, structureName});
        serverPlayer.m_213846_((Component)ComponentUtils.m_130748_((Component)this.m_5446_()).m_130946_(": ").m_7220_((Component)message));
        Object s = blockpos.m_123342_() == -1145 ? "~" : String.valueOf(blockpos.m_123342_());
        s = " " + (String)s + " ";
        if (blockpos.m_123342_() == -1145) {
            blockpos = blockpos.m_175288_((int)serverPlayer.m_20188_());
        }
        if (((Boolean)TDGConfig.MARK_LOCATION.get()).booleanValue()) {
            BlockPos finalBlockpos = blockpos;
            Object finalS = s;
            MutableComponent location = ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{blockpos.m_123341_(), s, blockpos.m_123343_()})).m_130938_(arg_0 -> TudiGongEntity.lambda$handleSearch$2(finalBlockpos, (String)finalS, arg_0));
            serverPlayer.m_5661_((Component)ComponentUtils.m_130748_((Component)this.m_5446_()).m_130946_(": ").m_7220_((Component)location), false);
            XaeroMapCompat.sendWaypoint(serverPlayer, resourceLocation.toString(), blockpos);
            JourneyMapCompat.sendWaypoint(serverPlayer, resourceLocation.toString(), blockpos);
        }
        if (((Boolean)TDGConfig.SPAWN_GUIDER.get()).booleanValue()) {
            BoundingBox boundingBox = new BoundingBox(blockpos).m_191961_(16);
            XianQiEntity xianQiEntity = new XianQiEntity(this.m_9236_(), blockpos.m_252807_(), (LivingEntity)serverPlayer, boundingBox);
            this.m_9236_().m_7967_((Entity)xianQiEntity);
        }
        serverPlayer.m_5661_((Component)ComponentUtils.m_130748_((Component)this.m_5446_()).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"entity.tudigong.tudigong.tudigong.answer3")), false);
        serverPlayer.m_5661_((Component)ComponentUtils.m_130748_((Component)this.m_5446_()).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"entity.tudigong.tudigong.tudigong.answer4")), false);
        this.from = this.m_146892_();
        Vec3 target = blockpos.m_175288_((int)this.m_20188_()).m_252807_();
        this.dir = target.m_82546_(this.from).m_82541_();
        this.startTick = this.f_19797_;
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.setMarkRemoved();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_12506_;
    }

    private static /* synthetic */ Style lambda$handleSearch$2(BlockPos finalBlockpos, String finalS, Style p_214489_) {
        return p_214489_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + finalBlockpos.m_123341_() + finalS + finalBlockpos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip")));
    }
}

