/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.compat;

import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.tudigong.network.TDGPacketHandler;
import com.p1nero.tudigong.network.packet.client.AddXaeroMapWaypointPacket;
import com.p1nero.tudigong.util.TextUtil;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.minimap.XaeroMinimap;

public class XaeroWaypointHelper {
    public static void sendWaypoint(ServerPlayer player, String key, BlockPos pos) {
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new AddXaeroMapWaypointPacket(key, pos, WaypointColor.getRandom().name()), (ServerPlayer)player);
    }

    public static void sendWaypoint(ServerPlayer player, String key, BlockPos pos, int colorIndex) {
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new AddXaeroMapWaypointPacket(key, pos, WaypointColor.fromIndex((int)colorIndex).name()), (ServerPlayer)player);
    }

    public static void sendWaypoint(ServerPlayer player, String key, BlockPos pos, WaypointColor color) {
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new AddXaeroMapWaypointPacket(key, pos, color.name()), (ServerPlayer)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addWayPoint(BlockPos pos, String name, String color) {
        XaeroWaypointHelper.addWayPoint(pos, name, color.equals("null") ? null : WaypointColor.valueOf((String)color));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addWayPoint(BlockPos pos, String name, @Nullable WaypointColor color) {
        name = TextUtil.tryToGetName(name);
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null) {
            ArrayList<Waypoint> waypoints = XaeroWaypointHelper.getWaypoints(Minecraft.m_91087_().f_91074_);
            String finalName = name;
            if (waypoints.stream().anyMatch(waypoint -> XaeroWaypointHelper.isEqualWaypoint(waypoint, finalName, pos))) {
                return;
            }
            Waypoint instant = new Waypoint(pos.m_123341_(), pos.m_123342_() + 2, pos.m_123343_(), name, name.substring(0, 1), color == null ? WaypointColor.getRandom() : color, WaypointPurpose.NORMAL, false);
            instant.setVisibility(WaypointVisibilityType.LOCAL);
            waypoints.add(instant);
            XaeroWaypointHelper.save(Minecraft.m_91087_().f_91074_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void removeWayPoint(BlockPos pos, String name) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null) {
            XaeroWaypointHelper.getWaypoints(Minecraft.m_91087_().f_91074_).removeIf(waypoint -> XaeroWaypointHelper.isEqualWaypoint(waypoint, name, pos));
            XaeroWaypointHelper.save(Minecraft.m_91087_().f_91074_);
        }
    }

    public static boolean isEqualWaypoint(Waypoint waypoint, String name, BlockPos pos) {
        return waypoint.getName().equals(name) && waypoint.getX() == pos.m_123341_() && waypoint.getY() == pos.m_123342_() + 2 && waypoint.getZ() == pos.m_123343_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ArrayList<Waypoint> getWaypoints(LocalPlayer localPlayer) {
        IXaeroMinimapClientPlayNetHandler clientLevel = (IXaeroMinimapClientPlayNetHandler)localPlayer.f_108617_;
        XaeroMinimapSession session = clientLevel.getXaero_minimapSession();
        WaypointsManager waypointsManager = session.getWaypointsManager();
        return waypointsManager.getWaypoints().getList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static WaypointsManager getWaypointManager(LocalPlayer localPlayer) {
        IXaeroMinimapClientPlayNetHandler clientLevel = (IXaeroMinimapClientPlayNetHandler)localPlayer.f_108617_;
        XaeroMinimapSession session = clientLevel.getXaero_minimapSession();
        return session.getWaypointsManager();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void save(LocalPlayer localPlayer) {
        try {
            XaeroMinimap.instance.getSettings().saveWaypoints(XaeroWaypointHelper.getWaypointManager(localPlayer).getCurrentWorld());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

