/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.tudigong.network.TDGPacketHandler;
import com.p1nero.tudigong.network.packet.client.SyncStructureTagsPacket;
import com.p1nero.tudigong.util.StructureTagManager;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.network.simple.SimpleChannel;

public class TagCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tag").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"tagName", (ArgumentType)StringArgumentType.word()).executes(c -> TagCommand.executeTagCreate((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"tagName")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"tagName", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(StructureTagManager.getTags().keySet(), (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(((CommandSourceStack)c.getSource()).m_81377_().m_206579_().m_175515_(Registries.f_256944_).m_6566_().stream().map(ResourceLocation::toString), (SuggestionsBuilder)b)).executes(c -> TagCommand.executeTagAdd((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"tagName"), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"structure"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"tagName", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(StructureTagManager.getTags().keySet(), (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> {
            String tagName = StringArgumentType.getString((CommandContext)c, (String)"tagName");
            Set<ResourceLocation> structures = StructureTagManager.getTags().get(tagName.toLowerCase());
            return SharedSuggestionProvider.m_82981_(structures != null ? structures.stream().map(ResourceLocation::toString) : Stream.empty(), (SuggestionsBuilder)b);
        }).executes(c -> TagCommand.executeTagRemove((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"tagName"), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"structure"))))))).then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"tagName", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(StructureTagManager.getTags().keySet(), (SuggestionsBuilder)b)).executes(c -> TagCommand.executeTagList((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"tagName")))))).then(Commands.m_82127_((String)"list_all").executes(c -> TagCommand.executeTagListAll((CommandSourceStack)c.getSource()))));
    }

    private static void syncTagsWithAllPlayers(MinecraftServer server) {
        PlayerList playerList = server.m_6846_();
        SyncStructureTagsPacket packet = new SyncStructureTagsPacket(StructureTagManager.getTags());
        playerList.m_11314_().forEach(player -> DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)packet, (ServerPlayer)player));
    }

    private static int executeTagCreate(CommandSourceStack source, String tagName) {
        if (StructureTagManager.createTag(tagName)) {
            StructureTagManager.save();
            TagCommand.syncTagsWithAllPlayers(source.m_81377_());
            source.m_288197_(() -> Component.m_237113_((String)("Tag '" + tagName + "' created.")), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Tag '" + tagName + "' already exists.")));
        return 0;
    }

    private static int executeTagAdd(CommandSourceStack source, String tagName, ResourceLocation structureId) {
        if (source.m_81377_().m_206579_().m_175515_(Registries.f_256944_).m_7745_(structureId) == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Structure '" + String.valueOf(structureId) + "' does not exist.")));
            return 0;
        }
        if (StructureTagManager.addStructureToTag(tagName, structureId)) {
            StructureTagManager.save();
            TagCommand.syncTagsWithAllPlayers(source.m_81377_());
            source.m_288197_(() -> Component.m_237113_((String)("Added " + String.valueOf(structureId) + " to tag '" + tagName + "'.")), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Tag '" + tagName + "' does not exist or already contains the structure.")));
        return 0;
    }

    private static int executeTagRemove(CommandSourceStack source, String tagName, ResourceLocation structureId) {
        if (StructureTagManager.removeStructureFromTag(tagName, structureId)) {
            StructureTagManager.save();
            TagCommand.syncTagsWithAllPlayers(source.m_81377_());
            source.m_288197_(() -> Component.m_237113_((String)("Removed " + String.valueOf(structureId) + " from tag '" + tagName + "'.")), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Tag '" + tagName + "' does not exist or does not contain the structure.")));
        return 0;
    }

    private static int executeTagList(CommandSourceStack source, String tagName) {
        String lowerCaseTagName = tagName.toLowerCase();
        Set<ResourceLocation> structures = StructureTagManager.getTags().get(lowerCaseTagName);
        if (structures != null) {
            source.m_288197_(() -> Component.m_237113_((String)("Structures in tag '" + lowerCaseTagName + "' (" + structures.size() + "):")), false);
            structures.forEach(loc -> source.m_288197_(() -> Component.m_237113_((String)("- " + loc.toString())), false));
            return structures.size();
        }
        source.m_81352_((Component)Component.m_237113_((String)("Tag '" + lowerCaseTagName + "' not found.")));
        return 0;
    }

    private static int executeTagListAll(CommandSourceStack source) {
        Set<String> tags = StructureTagManager.getTags().keySet();
        if (!tags.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)("All tags (" + tags.size() + "):")), false);
            tags.forEach(tag -> source.m_288197_(() -> Component.m_237113_((String)("- " + tag)), false));
            return tags.size();
        }
        source.m_288197_(() -> Component.m_237113_((String)"No tags defined."), false);
        return 0;
    }
}

