/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.text.WordUtils;

public class ExportCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"export_structures").requires(source -> source.m_6761_(2))).executes(ExportCommand::executeOriginal)).then(Commands.m_82129_((String)"lang", (ArgumentType)StringArgumentType.word()).executes(ExportCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String langCode;
        try {
            langCode = StringArgumentType.getString(context, (String)"lang");
        }
        catch (IllegalArgumentException e) {
            return ExportCommand.executeOriginal(context);
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.m_81377_();
        File outputDir = server.m_129971_("exported_structures");
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to create directory: " + outputDir.getAbsolutePath())));
            return 0;
        }
        HashMap translations = new HashMap();
        server.m_177941_().m_214159_("lang", path -> path.m_135815_().endsWith(langCode + ".json")).forEach((rl, resource) -> {
            try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (jsonObject != null) {
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        translations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                }
            }
            catch (Exception ex) {
                source.m_81352_((Component)Component.m_237113_((String)("Error reading lang file " + rl.toString() + ": " + ex.getMessage())));
            }
        });
        if (translations.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)("Warning: Could not load any translations for language '" + langCode + "'. Using fallback names.")), false);
        }
        HashMap<String, Map> modStructures = new HashMap<String, Map>();
        Registry structureRegistry = server.m_206579_().m_175515_(Registries.f_256944_);
        for (Object key : structureRegistry.m_214010_()) {
            String string = key.m_135782_().m_135827_();
            String structureId = key.m_135782_().toString();
            String translationKey = Util.m_137492_((String)"structure", (ResourceLocation)key.m_135782_());
            String translatedName = (String)translations.get(translationKey);
            if (translatedName == null) {
                String path2 = key.m_135782_().m_135815_();
                translatedName = WordUtils.capitalizeFully((String)path2.replace('_', ' '));
            }
            modStructures.computeIfAbsent(string, k -> new HashMap()).put(structureId, translatedName);
        }
        int filesWritten = 0;
        for (Map.Entry entry : modStructures.entrySet()) {
            String modId = (String)entry.getKey();
            Map structures = (Map)entry.getValue();
            File outputFile = new File(outputDir, modId + "_" + langCode + ".json");
            try (FileWriter writer = new FileWriter(outputFile);){
                GSON.toJson((Object)structures, (Appendable)writer);
                ++filesWritten;
            }
            catch (IOException e) {
                source.m_81352_((Component)Component.m_237113_((String)("Failed to write file for mod '" + modId + "': " + e.getMessage())));
            }
        }
        int finalFilesWritten = filesWritten;
        File file = outputDir;
        source.m_288197_(() -> Component.m_237113_((String)("Successfully exported " + finalFilesWritten + " files for language '" + langCode + "' to '" + finalOutputDir.getName() + "' directory.")), true);
        return filesWritten;
    }

    private static int executeOriginal(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.m_81377_();
        File outputDir = server.m_129971_("exported_structures");
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to create directory: " + outputDir.getAbsolutePath())));
            return 0;
        }
        HashMap<String, List> modStructures = new HashMap<String, List>();
        Registry structureRegistry = server.m_206579_().m_175515_(Registries.f_256944_);
        for (Object key : structureRegistry.m_214010_()) {
            String string = key.m_135782_().m_135827_();
            modStructures.computeIfAbsent(string, k -> new ArrayList()).add(key.m_135782_().toString());
        }
        int filesWritten = 0;
        for (Map.Entry entry : modStructures.entrySet()) {
            String modId = (String)entry.getKey();
            List structures = (List)entry.getValue();
            File outputFile = new File(outputDir, modId + ".json");
            try (FileWriter writer = new FileWriter(outputFile);){
                GSON.toJson((Object)structures, (Appendable)writer);
                ++filesWritten;
            }
            catch (IOException e) {
                source.m_81352_((Component)Component.m_237113_((String)("Failed to write file for mod '" + modId + "': " + e.getMessage())));
            }
        }
        int finalFilesWritten = filesWritten;
        File file = outputDir;
        source.m_288197_(() -> Component.m_237113_((String)("Successfully exported " + finalFilesWritten + " files to '" + finalOutputDir.getName() + "' directory.")), true);
        return filesWritten;
    }
}

