/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.client.widget;

import com.google.common.collect.BiMap;
import com.p1nero.tudigong.compat.JECharactersIntegration;
import com.p1nero.tudigong.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ResourceList
extends ObjectSelectionList<Entry> {
    private final BiMap<ResourceLocation, String> map;
    private final Map<String, Set<ResourceLocation>> tags;
    private final Map<String, Set<ResourceLocation>> modIds;
    private final Map<String, Set<ResourceLocation>> sets;
    private final Map<String, Set<ResourceLocation>> types;
    private final Map<ResourceLocation, ResourceLocation> structureToTypeMap;
    private final Map<ResourceLocation, List<ResourceLocation>> dimensions;
    private final EditBox box;
    private final Map<ResourceLocation, Set<String>> resourceToTagsMap;

    public ResourceList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight, BiMap<ResourceLocation, String> map, EditBox box, Map<String, Set<ResourceLocation>> tags, Map<String, Set<ResourceLocation>> modIds, Map<String, Set<ResourceLocation>> sets, Map<ResourceLocation, List<ResourceLocation>> dimensions, Map<String, Set<ResourceLocation>> types, Map<ResourceLocation, ResourceLocation> structureToTypeMap) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.m_93488_(false);
        this.map = map;
        this.box = box;
        this.tags = tags;
        this.modIds = modIds;
        this.sets = sets;
        this.dimensions = dimensions;
        this.types = types;
        this.structureToTypeMap = structureToTypeMap;
        this.resourceToTagsMap = new HashMap<ResourceLocation, Set<String>>();
        if (tags != null) {
            tags.forEach((tagName, resources) -> {
                for (ResourceLocation resource : resources) {
                    this.resourceToTagsMap.computeIfAbsent(resource, k -> new HashSet()).add(tagName);
                }
            });
        }
    }

    protected void m_7733_(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.m_280024_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_, -1072689136, -804253680);
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    public void setSelected(Entry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            this.box.m_94144_(entry.value);
        }
    }

    public void refresh(String keyword) {
        this.m_93410_(0.0);
        this.m_6702_().clear();
        List<String> results = StringUtil.m_14408_((String)keyword) ? new ArrayList<String>(this.map.values()) : this.findMatches(keyword);
        results.stream().sorted().map(x$0 -> new Entry((String)x$0)).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
    }

    private List<String> findMatches(String keyword) {
        String lowerCaseKeyword = keyword.toLowerCase();
        if (keyword.startsWith("#") || keyword.startsWith("@") || keyword.startsWith("$") || keyword.startsWith("~")) {
            Map<String, Set<ResourceLocation>> lookupMap;
            char prefix = keyword.charAt(0);
            String term = keyword.length() > 1 ? keyword.substring(1) : "";
            switch (prefix) {
                case '#': {
                    lookupMap = this.tags;
                    term = term.toLowerCase();
                    break;
                }
                case '@': {
                    lookupMap = this.modIds;
                    term = term.toLowerCase();
                    break;
                }
                case '$': {
                    lookupMap = this.sets;
                    term = term.toLowerCase();
                    break;
                }
                case '~': {
                    lookupMap = this.types;
                    term = term.toLowerCase();
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            if (lookupMap != null) {
                String finalTerm = term;
                Set matches = lookupMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(finalTerm)).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
                return matches.stream().map(arg_0 -> this.map.get(arg_0)).filter(Objects::nonNull).sorted().collect(Collectors.toList());
            }
        }
        HashSet matches = new HashSet();
        this.map.forEach((id, name) -> {
            if (JECharactersIntegration.match(name, lowerCaseKeyword)) {
                matches.add(name);
                return;
            }
            if (JECharactersIntegration.match(id.toString(), lowerCaseKeyword)) {
                matches.add(name);
                return;
            }
            Set<String> associatedTags = this.resourceToTagsMap.get(id);
            if (associatedTags != null) {
                for (String tagName : associatedTags) {
                    if (!JECharactersIntegration.match(tagName, lowerCaseKeyword)) continue;
                    matches.add(name);
                    return;
                }
            }
        });
        return new ArrayList<String>(matches);
    }

    public void handleTabCompletion() {
        Map<String, Set<ResourceLocation>> lookupMap;
        String keyword = this.box.m_94155_();
        if (keyword.length() < 2 || !keyword.startsWith("#") && !keyword.startsWith("@") && !keyword.startsWith("$") && !keyword.startsWith("~")) {
            return;
        }
        char prefix = keyword.charAt(0);
        String term = keyword.substring(1).toLowerCase();
        switch (prefix) {
            case '#': {
                lookupMap = this.tags;
                break;
            }
            case '@': {
                lookupMap = this.modIds;
                break;
            }
            case '$': {
                lookupMap = this.sets;
                break;
            }
            case '~': {
                lookupMap = this.types;
                break;
            }
            default: {
                return;
            }
        }
        if (lookupMap == null) {
            return;
        }
        List<String> potentialCompletions = lookupMap.keySet().stream().filter(key -> key.toLowerCase().startsWith(term)).collect(Collectors.toList());
        if (potentialCompletions.isEmpty()) {
            return;
        }
        if (potentialCompletions.size() == 1) {
            this.box.m_94144_(prefix + (String)potentialCompletions.get(0));
        } else {
            String commonPrefix = StringUtils.getCommonPrefix((String[])potentialCompletions.toArray(new String[0]));
            if (!commonPrefix.isEmpty()) {
                this.box.m_94144_(prefix + commonPrefix);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final String value;

        public Entry(String value) {
            this.value = value;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, this.value, left + 5, top + 2, 0xFFFFFF, true);
            ResourceLocation resourceKey = (ResourceLocation)ResourceList.this.map.inverse().get((Object)this.value);
            if (resourceKey != null) {
                List<ResourceLocation> dims;
                ResourceLocation typeKey;
                int yOffset = top + 12;
                int availableWidth = width - 10;
                if (ResourceList.this.structureToTypeMap != null && (typeKey = ResourceList.this.structureToTypeMap.get(resourceKey)) != null && !typeKey.m_135815_().equals("none")) {
                    MutableComponent typeComponent = Component.m_237113_((String)("Type: " + typeKey.toString())).m_130940_(ChatFormatting.DARK_GREEN);
                    guiGraphics.m_280614_(((ResourceList)ResourceList.this).f_93386_.f_91062_, (Component)typeComponent, left + 5, yOffset, 0xAAAAAA, true);
                    yOffset += 10;
                }
                if (ResourceList.this.dimensions != null && (dims = ResourceList.this.dimensions.get(resourceKey)) != null && !dims.isEmpty()) {
                    Object dimString = dims.stream().map(TextUtil::getDimensionName).collect(Collectors.joining(", "));
                    MutableComponent dimComponent = Component.m_237113_((String)("Dims: " + (String)dimString)).m_130940_(ChatFormatting.GRAY);
                    if (((ResourceList)ResourceList.this).f_93386_.f_91062_.m_92852_((FormattedText)dimComponent) > availableWidth) {
                        dimString = "Dims: " + ((ResourceList)ResourceList.this).f_93386_.f_91062_.m_92834_((String)dimString, availableWidth - ((ResourceList)ResourceList.this).f_93386_.f_91062_.m_92895_("Dims: ..."));
                        dimComponent = Component.m_237113_((String)((String)dimString + "...")).m_130940_(ChatFormatting.GRAY);
                    }
                    guiGraphics.m_280614_(((ResourceList)ResourceList.this).f_93386_.f_91062_, (Component)dimComponent, left + 5, yOffset, 0xAAAAAA, true);
                }
            }
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237115_((String)"narrator.select");
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                ResourceList.this.setSelected(this);
                return true;
            }
            return false;
        }
    }
}

