/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.client.widget;

import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.tudigong.client.util.SearchHistoryManager;
import com.p1nero.tudigong.compat.JECharactersIntegration;
import com.p1nero.tudigong.network.TDGPacketHandler;
import com.p1nero.tudigong.network.packet.server.TeleportToServerPacket;
import com.p1nero.tudigong.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public class HistoryList
extends ObjectSelectionList<Entry> {
    private static final ResourceLocation HISTORY_ENTRY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tudigong", (String)"textures/gui/history_entry.png");

    public HistoryList(Minecraft minecraft, int width, int height, int y0, int y1) {
        super(minecraft, width, height, y0, y1, 40);
        this.m_93488_(true);
    }

    public void filter(String keyword) {
        this.m_93516_();
        Stream<Object> stream = SearchHistoryManager.getHistory().stream();
        if (!StringUtil.m_14408_((String)keyword)) {
            String lowerCaseKeyword = keyword.toLowerCase();
            stream = stream.filter((? super T entry) -> {
                String posString;
                String translatedName = TextUtil.tryToGetName(entry.searchTerm());
                if (JECharactersIntegration.match(translatedName, lowerCaseKeyword)) {
                    return true;
                }
                if (JECharactersIntegration.match(entry.searchTerm(), lowerCaseKeyword)) {
                    return true;
                }
                if (JECharactersIntegration.match(entry.type().getString(), lowerCaseKeyword)) {
                    return true;
                }
                if (entry.position() != null && (posString = entry.position().m_123341_() + ", " + entry.position().m_123342_() + ", " + entry.position().m_123343_()).contains(lowerCaseKeyword)) {
                    return true;
                }
                if (entry.dimension() != null && entry.dimension().m_135782_().toString().toLowerCase().contains(lowerCaseKeyword)) {
                    return true;
                }
                String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(entry.timestamp()));
                return timestamp.contains(lowerCaseKeyword);
            });
        }
        stream.forEach(entry -> this.m_7085_((AbstractSelectionList.Entry)new Entry(this, (SearchHistoryManager.SearchHistoryEntry)entry)));
        this.m_93410_(0.0);
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    public static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final HistoryList parentList;
        private final SearchHistoryManager.SearchHistoryEntry historyEntry;
        private final Button deleteButton;
        private final Button teleportButton;
        private final Minecraft minecraft;
        private final ItemStack icon;

        public Entry(HistoryList parentList, SearchHistoryManager.SearchHistoryEntry historyEntry) {
            this.parentList = parentList;
            this.historyEntry = historyEntry;
            this.minecraft = Minecraft.m_91087_();
            this.deleteButton = Button.m_253074_((Component)Component.m_237113_((String)"X").m_130940_(ChatFormatting.RED), button -> {
                SearchHistoryManager.remove(historyEntry);
                this.parentList.filter(null);
            }).m_252987_(0, 0, 20, 20).m_253136_();
            this.teleportButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.tudigong.history.teleport"), button -> {
                if (historyEntry.position() != null && historyEntry.dimension() != null) {
                    DialoguePacketRelay.sendToServer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new TeleportToServerPacket(historyEntry.position(), historyEntry.dimension()));
                }
            }).m_252987_(0, 0, 30, 20).m_253136_();
            this.teleportButton.f_93624_ = historyEntry.position() != null;
            boolean isStructure = historyEntry.type().getString().equalsIgnoreCase(Component.m_237115_((String)"history.tudigong.type.structure").getString());
            this.icon = new ItemStack((ItemLike)(isStructure ? Items.f_42522_ : Items.f_42276_));
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            guiGraphics.m_280203_(this.icon, left + 8, top + 12);
            String translatedName = TextUtil.tryToGetName(this.historyEntry.searchTerm());
            MutableComponent mainText = Component.m_237113_((String)translatedName).m_130940_(ChatFormatting.WHITE);
            guiGraphics.m_280614_(this.minecraft.f_91062_, (Component)mainText, left + 35, top + 7, 0xFFFFFF, true);
            if (this.historyEntry.position() != null) {
                BlockPos pos = this.historyEntry.position();
                String yString = pos.m_123342_() == -1145 ? "~" : String.valueOf(pos.m_123342_());
                String posString = pos.m_123341_() + ", " + yString + ", " + pos.m_123343_();
                Object dimensionName = "";
                String tpY = pos.m_123342_() == -1145 ? "~" : String.valueOf(pos.m_123342_());
                String tpCommand = "/tp @s " + pos.m_123341_() + " " + tpY + " " + pos.m_123343_();
                if (this.historyEntry.dimension() != null) {
                    dimensionName = " (" + this.historyEntry.dimension().m_135782_().m_135815_() + ")";
                    tpCommand = "/execute as @s in " + String.valueOf(this.historyEntry.dimension().m_135782_()) + " run " + tpCommand;
                }
                String finalTpCommand = tpCommand;
                MutableComponent posComponent = Component.m_237113_((String)(posString + (String)dimensionName)).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, finalTpCommand)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
                guiGraphics.m_280430_(this.minecraft.f_91062_, (Component)posComponent, left + 35, top + 20, 0xFFFFFF);
            } else {
                guiGraphics.m_280430_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)"gui.tudigong.history.pos_na").m_130940_(ChatFormatting.DARK_GRAY), left + 35, top + 20, 0xFFFFFF);
            }
            String timestamp = new SimpleDateFormat("yy/MM/dd HH:mm").format(new Date(this.historyEntry.timestamp()));
            int timestampWidth = this.minecraft.f_91062_.m_92895_(timestamp);
            int rightPadding = this.teleportButton.f_93624_ ? 65 : 30;
            guiGraphics.m_280488_(this.minecraft.f_91062_, timestamp, left + width - timestampWidth - rightPadding, top + 7, 0xAAAAAA);
            this.deleteButton.m_252865_(left + width - this.deleteButton.m_5711_() - 5);
            this.deleteButton.m_253211_(top + (height - this.deleteButton.m_93694_()) / 2);
            this.deleteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.teleportButton.f_93624_) {
                this.teleportButton.m_252865_(this.deleteButton.m_252754_() - this.teleportButton.m_5711_() - 5);
                this.teleportButton.m_253211_(top + (height - this.teleportButton.m_93694_()) / 2);
                this.teleportButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.teleportButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.deleteButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237113_((String)this.historyEntry.searchTerm());
        }
    }
}

