/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.client.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.p1nero.tudigong.TuDiGongMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;

@OnlyIn(value=Dist.CLIENT)
public class SearchHistoryManager {
    private static final int MAX_HISTORY_SIZE = 20;
    private static final Deque<SearchHistoryEntry> HISTORY = new ArrayDeque<SearchHistoryEntry>(20);
    private static final File HISTORY_FILE = new File(FMLPaths.CONFIGDIR.get().toFile(), "tudigong/search_history.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void addEntry(SearchHistoryEntry entry) {
        HISTORY.removeIf(e -> e.equals(entry));
        HISTORY.addFirst(entry);
        if (HISTORY.size() > 20) {
            HISTORY.removeLast();
        }
        SearchHistoryManager.save();
    }

    public static void remove(SearchHistoryEntry entry) {
        HISTORY.remove(entry);
        SearchHistoryManager.save();
    }

    public static Deque<SearchHistoryEntry> getHistory() {
        return HISTORY;
    }

    public static void clearHistory() {
        HISTORY.clear();
        SearchHistoryManager.save();
    }

    public static void save() {
        HISTORY_FILE.getParentFile().mkdirs();
        ArrayList<HistorySaveEntry> saveEntries = new ArrayList<HistorySaveEntry>();
        for (SearchHistoryEntry entry : HISTORY) {
            saveEntries.add(new HistorySaveEntry(entry));
        }
        try (FileWriter writer = new FileWriter(HISTORY_FILE);){
            GSON.toJson(saveEntries, (Appendable)writer);
        }
        catch (IOException e) {
            TuDiGongMod.LOGGER.error("Failed to save search history", (Throwable)e);
        }
    }

    public static void load() {
        if (!HISTORY_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(HISTORY_FILE);){
            Type listType = new TypeToken<List<HistorySaveEntry>>(){}.getType();
            List saveEntries = (List)GSON.fromJson((Reader)reader, listType);
            if (saveEntries != null) {
                HISTORY.clear();
                for (HistorySaveEntry saveEntry : saveEntries) {
                    HISTORY.add(saveEntry.toHistoryEntry());
                }
            }
        }
        catch (Exception e) {
            TuDiGongMod.LOGGER.error("Failed to load search history", (Throwable)e);
        }
    }

    public record SearchHistoryEntry(String searchTerm, Component type, @Nullable BlockPos position, @Nullable ResourceKey<Level> dimension, long timestamp) {
    }

    private static class HistorySaveEntry {
        String searchTerm;
        String type;
        int[] position;
        String dimension;
        long timestamp;

        public HistorySaveEntry(SearchHistoryEntry entry) {
            this.searchTerm = entry.searchTerm();
            this.type = Component.Serializer.m_130703_((Component)entry.type());
            if (entry.position() != null) {
                this.position = new int[]{entry.position().m_123341_(), entry.position().m_123342_(), entry.position().m_123343_()};
            }
            if (entry.dimension() != null) {
                this.dimension = entry.dimension().m_135782_().toString();
            }
            this.timestamp = entry.timestamp();
        }

        public SearchHistoryEntry toHistoryEntry() {
            MutableComponent typeComp = Component.Serializer.m_130701_((String)this.type);
            BlockPos pos = this.position != null ? new BlockPos(this.position[0], this.position[1], this.position[2]) : null;
            ResourceKey dimKey = this.dimension != null ? ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)this.dimension)) : null;
            return new SearchHistoryEntry(this.searchTerm, (Component)typeComp, pos, (ResourceKey<Level>)dimKey, this.timestamp);
        }
    }
}

