/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.client.screen;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.dialog_lib.network.packet.serverbound.HandleNpcEntityPlayerInteractPacket;
import com.p1nero.tudigong.client.screen.HistoryScreen;
import com.p1nero.tudigong.client.widget.ResourceList;
import com.p1nero.tudigong.network.TDGPacketHandler;
import com.p1nero.tudigong.network.packet.server.HandleSearchPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.simple.SimpleChannel;

@OnlyIn(value=Dist.CLIENT)
public class StructureSearchScreen
extends Screen {
    private int tudigongId;
    private EditBox searchBox;
    private ResourceList resourceList;
    private Button searchButton;
    private boolean found;
    public static final BiMap<ResourceLocation, String> STRUCTURE_NAME_MAP = HashBiMap.create();
    public static final Map<String, Set<ResourceLocation>> STRUCTURE_TAGS = new HashMap<String, Set<ResourceLocation>>();
    public static final Map<String, Set<ResourceLocation>> STRUCTURE_MOD_IDS = new HashMap<String, Set<ResourceLocation>>();
    public static final Map<String, Set<ResourceLocation>> STRUCTURE_SETS = new HashMap<String, Set<ResourceLocation>>();
    public static final Map<String, Set<ResourceLocation>> STRUCTURE_TYPES = new HashMap<String, Set<ResourceLocation>>();
    public static final Map<ResourceLocation, ResourceLocation> STRUCTURE_TO_TYPE_MAP = new HashMap<ResourceLocation, ResourceLocation>();
    public static final Map<ResourceLocation, List<ResourceLocation>> STRUCTURE_DIMENSIONS = new HashMap<ResourceLocation, List<ResourceLocation>>();

    public StructureSearchScreen(int tudigongId) {
        super((Component)Component.m_237113_((String)""));
        this.tudigongId = tudigongId;
    }

    protected void m_7856_() {
        super.m_7856_();
        int inputBoxWidth = 200;
        int buttonWidth = 80;
        int totalWidth = inputBoxWidth + buttonWidth + 5;
        int leftPos = (this.f_96543_ - totalWidth) / 2;
        int topPos = 50;
        this.searchBox = new EditBox(this.f_96547_, leftPos, topPos + 11, inputBoxWidth, 20, (Component)Component.m_237115_((String)"gui.tudigong.search.placeholder"));
        this.searchBox.m_94199_(32500);
        this.searchBox.m_94144_("");
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.tudigong.history.button"), button -> this.f_96541_.m_91152_((Screen)new HistoryScreen(this))).m_252987_(leftPos + inputBoxWidth + 5, topPos, buttonWidth, 20).m_253136_());
        this.searchButton = Button.m_253074_((Component)Component.m_237115_((String)"button.tudigong.ask"), this::onSearchButtonPressed).m_252987_(leftPos + inputBoxWidth + 5, topPos + 22, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.searchButton);
        int listY = topPos + 44 + 2;
        this.resourceList = new ResourceList(Minecraft.m_91087_(), inputBoxWidth, this.f_96544_, listY, this.f_96544_ - 30, 31, STRUCTURE_NAME_MAP, this.searchBox, STRUCTURE_TAGS, STRUCTURE_MOD_IDS, STRUCTURE_SETS, STRUCTURE_DIMENSIONS, STRUCTURE_TYPES, STRUCTURE_TO_TYPE_MAP);
        this.resourceList.m_93496_(false);
        this.resourceList.m_93507_(leftPos);
        this.m_142416_((GuiEventListener)this.resourceList);
        this.searchBox.m_94151_(this.resourceList::refresh);
        this.resourceList.refresh(null);
        this.m_264313_((GuiEventListener)this.searchBox);
    }

    private void onSearchButtonPressed(Button button) {
        button.m_7435_(Minecraft.m_91087_().m_91106_());
        String searchString = this.searchBox.m_94155_().trim();
        if (searchString.isEmpty()) {
            return;
        }
        String searchToSend = STRUCTURE_NAME_MAP.containsValue((Object)searchString) ? ((ResourceLocation)STRUCTURE_NAME_MAP.inverse().get((Object)searchString)).toString() : searchString;
        DialoguePacketRelay.sendToServer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new HandleSearchPacket(this.tudigongId, searchToSend, true));
        this.found = true;
        this.m_7379_();
    }

    public void m_7379_() {
        super.m_7379_();
        if (!this.found) {
            DialoguePacketRelay.sendToServer((Object)new HandleNpcEntityPlayerInteractPacket(this.tudigongId, 0));
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.m_93696_()) {
            if (keyCode == 258) {
                this.resourceList.handleTabCompletion();
                return true;
            }
            if (keyCode == 257) {
                this.onSearchButtonPressed(this.searchButton);
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public int getTudigongId() {
        return this.tudigongId;
    }

    public boolean m_7043_() {
        return false;
    }
}

