/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong.block.custom;

import com.p1nero.tudigong.TDGConfig;
import com.p1nero.tudigong.TuDiGongMod;
import com.p1nero.tudigong.block.TDGBlockEntities;
import com.p1nero.tudigong.entity.TDGEntities;
import com.p1nero.tudigong.entity.TudiGongEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TuDiTempleBlockEntity
extends BlockEntity {
    private int shiftCount;
    private int resetTimer;
    private int cooldown;
    private boolean release = true;
    private TudiGongEntity tudiGongEntity;

    public TuDiTempleBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TDGBlockEntities.TUDI_TEMPLE_ENTITY.get(), blockPos, blockState);
    }

    public void reset() {
        this.shiftCount = 0;
        this.resetTimer = 0;
        this.cooldown = (Integer)TDGConfig.TEMPLE_SUMMON_COOLDOWN_TICKS.get();
        this.release = true;
        this.tudiGongEntity = null;
    }

    public static <T extends BlockEntity> void tick(Level pLevel, BlockPos pPos, BlockState state, T t) {
        if (t instanceof TuDiTempleBlockEntity) {
            TuDiTempleBlockEntity tuDiTempleBlockEntity = (TuDiTempleBlockEntity)t;
            tuDiTempleBlockEntity.tick(pLevel, pPos, state);
        }
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState state) {
        Vec3 center = pPos.m_252807_();
        pLevel.m_45976_(Player.class, new AABB(center, center).m_82400_(3.0)).forEach(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (((Boolean)TDGConfig.GUIDE_MODE.get()).booleanValue()) {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"block.tudigong.tudi_temple.tip"), true);
                }
                if (this.tudiGongEntity == null && this.cooldown <= 0) {
                    if (serverPlayer.m_6144_()) {
                        if (this.release) {
                            ++this.shiftCount;
                            this.resetTimer = (Integer)TDGConfig.TEMPLE_SUMMON_RESET_TICKS.get();
                            this.release = false;
                        }
                    } else {
                        this.release = true;
                        if (this.shiftCount >= (Integer)TDGConfig.TEMPLE_SUMMON_SHIFT_COUNT.get()) {
                            this.tudiGongEntity = (TudiGongEntity)((EntityType)TDGEntities.TU_DI_GONG.get()).m_262496_(serverPlayer.m_284548_(), pPos.m_6630_(1), MobSpawnType.MOB_SUMMONED);
                            if (this.tudiGongEntity != null) {
                                this.tudiGongEntity.setHomePos(pPos);
                                this.tudiGongEntity.m_146922_(((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_().m_122435_());
                                serverPlayer.m_5661_((Component)ComponentUtils.m_130748_((Component)this.tudiGongEntity.m_5446_()).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"entity.tudigong.tudigong.tudigong.answer1")), false);
                                TuDiGongMod.finishAdvancement("tudigong:sincerity", serverPlayer);
                                TDGConfig.GUIDE_MODE.set((Object)false);
                            }
                            this.shiftCount = 0;
                        }
                    }
                }
            }
        });
        if (!pLevel.f_46443_) {
            if (this.resetTimer > 0) {
                --this.resetTimer;
                if (this.resetTimer == 0) {
                    this.shiftCount = 0;
                }
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.tudiGongEntity != null && this.tudiGongEntity.m_21224_()) {
                this.tudiGongEntity = null;
            }
        }
    }
}

