/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tudigong;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.tudigong.TDGConfig;
import com.p1nero.tudigong.block.TDGBlockEntities;
import com.p1nero.tudigong.block.TDGBlocks;
import com.p1nero.tudigong.command.ExportStructuresCommand;
import com.p1nero.tudigong.entity.TDGEntities;
import com.p1nero.tudigong.entity.TudiGongEntity;
import com.p1nero.tudigong.item.TDGItemTabs;
import com.p1nero.tudigong.item.TDGItems;
import com.p1nero.tudigong.network.TDGPacketHandler;
import com.p1nero.tudigong.network.packet.client.SyncBiomeDimensionsPacket;
import com.p1nero.tudigong.network.packet.client.SyncResourceKeysPacket;
import com.p1nero.tudigong.network.packet.client.SyncStructureDimensionsPacket;
import com.p1nero.tudigong.network.packet.client.SyncStructureSetsPacket;
import com.p1nero.tudigong.network.packet.client.SyncStructureTagsPacket;
import com.p1nero.tudigong.network.packet.client.SyncStructureTypesPacket;
import com.p1nero.tudigong.util.StructureTagManager;
import com.p1nero.tudigong.util.StructureUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="tudigong")
public class TuDiGongMod {
    public static final String MOD_ID = "tudigong";
    public static final Logger LOGGER = LogUtils.getLogger();

    public TuDiGongMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        TDGEntities.REGISTRY.register(modEventBus);
        TDGBlocks.REGISTRY.register(modEventBus);
        TDGBlockEntities.REGISTRY.register(modEventBus);
        TDGItems.REGISTRY.register(modEventBus);
        TDGItemTabs.REGISTRY.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerJoinLevel);
        MinecraftForge.EVENT_BUS.addListener(this::onServerChat);
        MinecraftForge.EVENT_BUS.addListener(this::onBlockChange);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        modEventBus.addListener(this::onDatapackLoad);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TDGConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TDGPacketHandler.register();
        event.enqueueWork(StructureTagManager::load);
    }

    private void onServerChat(ServerChatEvent event) {
        if (event.getRawText().contains("\u571f\u5730") || event.getRawText().toLowerCase(Locale.ROOT).contains("tudi")) {
            TudiGongEntity tudiGongEntity;
            ServerPlayer serverPlayer = event.getPlayer();
            if (!serverPlayer.m_20310_(2)) {
                return;
            }
            ServerLevel serverLevel = serverPlayer.m_284548_();
            Vec3 center = serverPlayer.m_20182_();
            if (serverPlayer.m_9236_().m_8055_(serverPlayer.m_20097_().m_7495_()).m_204336_(BlockTags.f_144274_) && serverLevel.m_45976_(TudiGongEntity.class, new AABB(center, center).m_82400_(10.0)).isEmpty() && (tudiGongEntity = (TudiGongEntity)((EntityType)TDGEntities.TU_DI_GONG.get()).m_262496_(serverPlayer.m_284548_(), serverPlayer.m_20097_().m_6630_(1), MobSpawnType.MOB_SUMMONED)) != null) {
                TuDiGongMod.finishAdvancement("tudigong:sincerity", serverPlayer);
                serverPlayer.m_5661_((Component)ComponentUtils.m_130748_((Component)tudiGongEntity.m_5446_()).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"entity.tudigong.tudigong.tudigong.answer1")), false);
            }
        }
    }

    private void onPlayerJoinLevel(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TuDiGongMod.syncRegistry(serverPlayer, Registries.f_256944_);
            TuDiGongMod.syncRegistry(serverPlayer, Registries.f_256952_);
            DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new SyncStructureTagsPacket(StructureTagManager.getTags()), (ServerPlayer)serverPlayer);
            TuDiGongMod.syncStructureSets(serverPlayer);
            TuDiGongMod.syncStructureDimensions(serverPlayer);
            TuDiGongMod.syncBiomeDimensions(serverPlayer);
            TuDiGongMod.syncStructureTypes(serverPlayer);
        }
    }

    public static void syncBiomeDimensions(ServerPlayer serverPlayer) {
        HashMap<ResourceLocation, List<ResourceLocation>> biomeDimensions = new HashMap<ResourceLocation, List<ResourceLocation>>();
        Registry biomeRegistry = serverPlayer.m_284548_().m_9598_().m_175515_(Registries.f_256952_);
        biomeRegistry.m_203611_().forEach(biomeHolder -> biomeHolder.m_203543_().ifPresent(biomeResourceKey -> {
            ArrayList<ResourceLocation> dims = new ArrayList<ResourceLocation>();
            for (ServerLevel level : serverPlayer.m_20194_().m_129785_()) {
                if (!level.m_7726_().m_8481_().m_62218_().m_207840_().contains(biomeHolder)) continue;
                dims.add(level.m_46472_().m_135782_());
            }
            if (!dims.isEmpty()) {
                biomeDimensions.put(biomeResourceKey.m_135782_(), dims);
            }
        }));
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new SyncBiomeDimensionsPacket(biomeDimensions), (ServerPlayer)serverPlayer);
    }

    public static void syncRegistry(ServerPlayer serverPlayer, ResourceKey<? extends Registry<?>> registry) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        serverPlayer.m_284548_().m_9598_().m_254861_(registry).ifPresent(registryLookup -> registryLookup.m_255209_().forEach(resourceKey -> resourceLocations.add(resourceKey.m_135782_())));
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new SyncResourceKeysPacket(resourceLocations, registry == Registries.f_256944_), (ServerPlayer)serverPlayer);
    }

    public static void syncStructureSets(ServerPlayer serverPlayer) {
        HashMap<String, Set<ResourceLocation>> structureSets = new HashMap<String, Set<ResourceLocation>>();
        Registry registry = serverPlayer.m_284548_().m_9598_().m_175515_(Registries.f_256998_);
        registry.m_6579_().forEach(entry -> {
            ResourceLocation setLocation = ((ResourceKey)entry.getKey()).m_135782_();
            HashSet structures = new HashSet();
            ((StructureSet)entry.getValue()).f_210003_().forEach(selectionEntry -> selectionEntry.f_210026_().m_203543_().ifPresent(key -> structures.add(key.m_135782_())));
            if (!structures.isEmpty()) {
                structureSets.put(setLocation.toString(), structures);
            }
        });
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new SyncStructureSetsPacket(structureSets), (ServerPlayer)serverPlayer);
    }

    public static void syncStructureDimensions(ServerPlayer serverPlayer) {
        HashMap<ResourceLocation, List<ResourceLocation>> structureDimensions = new HashMap<ResourceLocation, List<ResourceLocation>>();
        Registry structureRegistry = serverPlayer.m_284548_().m_9598_().m_175515_(Registries.f_256944_);
        structureRegistry.forEach(structure -> {
            List<ResourceLocation> dims;
            ResourceLocation key = structureRegistry.m_7981_(structure);
            if (key != null && !(dims = StructureUtils.getGeneratingDimensionKeys(serverPlayer.m_284548_(), structure)).isEmpty()) {
                structureDimensions.put(key, dims);
            }
        });
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new SyncStructureDimensionsPacket(structureDimensions), (ServerPlayer)serverPlayer);
    }

    public static void syncStructureTypes(ServerPlayer serverPlayer) {
        DialoguePacketRelay.sendToPlayer((SimpleChannel)TDGPacketHandler.INSTANCE, (Object)new SyncStructureTypesPacket(StructureUtils.getTypeKeysToStructureKeys(serverPlayer.m_284548_()).asMap(), StructureUtils.getStructureKeysToTypeKeys(serverPlayer.m_284548_())), (ServerPlayer)serverPlayer);
    }

    private void onBlockChange(BlockEvent.EntityPlaceEvent event) {
        Direction[] directionArray = event.getLevel();
        if (directionArray instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)directionArray;
            if (event.getPlacedBlock().m_60713_(Blocks.f_50081_)) {
                for (Direction direction : Direction.values()) {
                    BlockState blockstate;
                    BlockPos blockpos = event.getPos().m_121945_(direction);
                    if (!serverLevel.m_46805_(blockpos) || !(blockstate = serverLevel.m_8055_(blockpos)).m_60713_((Block)TDGBlocks.TUDI_TEMPLE.get())) continue;
                    Vec3 center = event.getPos().m_252807_();
                    serverLevel.m_45976_(Player.class, new AABB(center, center).m_82400_(3.0)).forEach(player -> player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 2400, 1, false, false, true)));
                    Entity entity = event.getEntity();
                    if (!(entity instanceof ServerPlayer)) break;
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    TuDiGongMod.finishAdvancement("tudigong:sincerity2", serverPlayer);
                    break;
                }
            }
        }
    }

    private void onDatapackLoad(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA && ((Boolean)TDGConfig.GENERATE_TEMPLE.get()).booleanValue()) {
            this.addNewDatapack(event, "tu_di_temple");
        }
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        ExportStructuresCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void addNewDatapack(AddPackFindersEvent event, String name) {
        Path resourcePath = ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"packs/" + name});
        Pack pack = Pack.m_245429_((String)name, (Component)Component.m_237113_((String)name), (boolean)true, path -> new PathPackResources(path, resourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10529_);
        event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
    }

    public static void finishAdvancement(Advancement advancement, ServerPlayer serverPlayer) {
        AdvancementProgress progress = serverPlayer.m_8960_().m_135996_(advancement);
        if (!progress.m_8193_()) {
            for (String criteria : progress.m_8219_()) {
                serverPlayer.m_8960_().m_135988_(advancement, criteria);
            }
        }
    }

    public static void finishAdvancement(String resourceLocation, ServerPlayer serverPlayer) {
        Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(ResourceLocation.parse((String)resourceLocation));
        if (advancement == null) {
            LOGGER.error("advancement:\"{}\" is null!", (Object)resourceLocation);
            return;
        }
        TuDiGongMod.finishAdvancement(advancement, serverPlayer);
    }
}

