/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.common.network.packets;

import com.black_dog20.tabstats.client.ClientDataManager;
import com.black_dog20.tabstats.common.utils.PlayerStat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketPlayers {
    private final Map<UUID, PlayerStat> playerStats;

    public PacketPlayers(Map<UUID, PlayerStat> playerStats) {
        this.playerStats = playerStats;
    }

    public static void encode(PacketPlayers msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.playerStats.size());
        for (Map.Entry<UUID, PlayerStat> playerKvP : msg.playerStats.entrySet()) {
            PlayerStat stat = playerKvP.getValue();
            buffer.m_130077_(playerKvP.getKey());
            buffer.m_130072_(stat.playerName(), Short.MAX_VALUE);
            buffer.writeInt(stat.deaths());
            buffer.writeInt(stat.kills());
            buffer.writeInt(stat.playTime());
            buffer.writeLong(stat.lastOnline());
        }
    }

    public static PacketPlayers decode(FriendlyByteBuf buffer) {
        HashMap<UUID, PlayerStat> map = new HashMap<UUID, PlayerStat>();
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            UUID uuid = buffer.m_130259_();
            map.put(uuid, new PlayerStat(uuid, buffer.m_130136_(Short.MAX_VALUE), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readLong()));
        }
        return new PacketPlayers(map);
    }

    public static class Handler {
        public static void handle(PacketPlayers msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ClientDataManager.PLAYER_STATS = msg.playerStats;
            }));
            ctx.get().setPacketHandled(true);
        }
    }
}

