/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.client.overlays;

import com.black_dog20.tabstats.client.ClientDataManager;
import com.black_dog20.tabstats.client.columns.OfflineHeadColumn;
import com.black_dog20.tabstats.client.keybinds.Keybinds;
import com.black_dog20.tabstats.common.utils.PlayerStat;
import com.black_dog20.tabstats.common.utils.Translations;
import com.black_dog20.tabstats.repack.bml.client.DrawingContext;
import com.black_dog20.tabstats.repack.bml.client.overlay.GameOverlay;
import com.black_dog20.tabstats.repack.bml.client.rows.Row;
import com.black_dog20.tabstats.repack.bml.client.rows.RowHelper;
import com.black_dog20.tabstats.repack.bml.client.rows.columns.BlankColumn;
import com.black_dog20.tabstats.repack.bml.client.rows.columns.Column;
import com.black_dog20.tabstats.repack.bml.client.rows.columns.HeadColumn;
import com.black_dog20.tabstats.repack.bml.client.rows.columns.ITextComponentColumn;
import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class PlayerTabStatListOverlay
extends GameOverlay.Pre {
    private static final Ordering<PlayerStat> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private final Minecraft minecraft;
    private final Font fontRenderer;
    private final ItemRenderer itemRenderer;
    private long lastRenderTime = Util.m_137550_();
    private int ticks = 0;
    private int page = 1;

    public PlayerTabStatListOverlay() {
        this.minecraft = Minecraft.m_91087_();
        this.fontRenderer = this.minecraft.f_91062_;
        this.itemRenderer = this.minecraft.m_91291_();
    }

    @Override
    public void onRender(GuiGraphics guiGraphics, int width, int height) {
        int y = 10;
        boolean z = false;
        if (Util.m_137550_() - 2000L > this.lastRenderTime) {
            this.page = 1;
            this.ticks = 1;
        }
        Objects.requireNonNull(this.fontRenderer);
        int itemsPerPage = (int)Math.floor((height - 7 * y) / 9);
        List<Row> rows = this.getRows();
        int maxPages = (int)Math.ceil((double)rows.size() / (double)itemsPerPage);
        if (this.ticks % 300 == 0) {
            this.page = this.page >= maxPages ? 1 : ++this.page;
            this.ticks = 1;
        }
        rows = this.getPagedRows(rows, itemsPerPage);
        int maxWidth = RowHelper.getMaxWidth(rows);
        int x = width / 2 - maxWidth / 2;
        DrawingContext drawingContext = new DrawingContext(guiGraphics, width, height, x, y, (float)z, this.fontRenderer);
        y = RowHelper.drawRowsWithBackground(drawingContext, rows);
        guiGraphics.m_280430_(this.fontRenderer, Translations.PAGE.get(this.page, maxPages), width / 2 + 2, y + 2, -1);
        ++this.ticks;
        this.lastRenderTime = Util.m_137550_();
    }

    @Override
    public boolean doRender(NamedGuiOverlay overlay) {
        if (overlay.id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
            return Keybinds.SHOW.m_90857_();
        }
        return false;
    }

    @Override
    public boolean doesCancelEvent() {
        return true;
    }

    @SubscribeEvent
    public void onExtraOverlayRender(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.PLAYER_LIST.id()) && event.isCancelable() && Keybinds.SHOW.m_90857_()) {
            event.setCanceled(true);
        }
    }

    private List<Row> getRows() {
        List playerStats = ClientDataManager.PLAYER_STATS.values().stream().filter(playerStat -> playerStat.deaths() != -1).collect(Collectors.toList());
        List list = ENTRY_ORDERING.sortedCopy(playerStats);
        ClientPacketListener nethandlerplayclient = this.minecraft.f_91074_.f_108617_;
        Collection playerInfos = nethandlerplayclient.m_105142_();
        List onlineUuids = playerInfos.stream().map(PlayerInfo::m_105312_).map(GameProfile::getId).collect(Collectors.toList());
        return list.stream().map(playerStat -> this.buildRow((PlayerStat)playerStat, onlineUuids)).collect(Collectors.toCollection(LinkedList::new));
    }

    private Row buildRow(PlayerStat playerStat, List<UUID> onlineUuids) {
        Row.RowBuilder builder = new Row.RowBuilder();
        Player entityplayer = Minecraft.m_91087_().f_91073_.m_46003_(playerStat.uuid());
        return builder.withColumn(this.getHeadColumn(playerStat, onlineUuids), this::isNotLocalOnly).withColumn(ITextComponentColumn.of("name", this.getPlayerName(playerStat))).withColumn(BlankColumn.of("nameSpace", 6)).withColumn(ITextComponentColumn.of("lastSeen", this.getPlayerLastSeen(playerStat), Column.Alignment.CENTER), this::isNotLocalOnly).withColumn(BlankColumn.of("lastSeenSpace", 6), this::isNotLocalOnly).withColumn(ITextComponentColumn.of("timePlayed", this.getPlayerTimePlayed(playerStat), Column.Alignment.CENTER)).withColumn(BlankColumn.of("timePlayedSpace", 6)).withColumn(ITextComponentColumn.of("kill", this.getPlayerKills(playerStat), Column.Alignment.CENTER)).withColumn(BlankColumn.of("killSpace", 6)).withColumn(ITextComponentColumn.of("death", this.getPlayerDeaths(playerStat), Column.Alignment.CENTER)).withColumn(BlankColumn.of("deathSpace", 6)).withColumn(ITextComponentColumn.of("deathPerHour", this.getPlayerDeathsPerHour(playerStat), Column.Alignment.CENTER)).withColumn(BlankColumn.of("deathPerHourSpace", 6)).build();
    }

    private Column getHeadColumn(PlayerStat playerStat, List<UUID> onlineUuids) {
        if (onlineUuids.contains(playerStat.uuid()) && this.minecraft.f_91074_.f_108617_.m_104949_(playerStat.uuid()) != null) {
            PlayerInfo playerInfo = this.minecraft.f_91074_.f_108617_.m_104949_(playerStat.uuid());
            return HeadColumn.of("head", playerInfo);
        }
        return OfflineHeadColumn.of("head", playerStat.uuid(), playerStat.playerName());
    }

    private Row buildTitleRow() {
        Row.RowBuilder builder = new Row.RowBuilder();
        return builder.withColumn(BlankColumn.of("head", 10), this::isNotLocalOnly).withColumn(ITextComponentColumn.of("name", this.getTitleComponent(Translations.NAME))).withColumn(BlankColumn.of("nameSpace", 6)).withColumn(ITextComponentColumn.of("lastSeen", this.getTitleComponent(Translations.LAST_SEEN), Column.Alignment.CENTER), this::isNotLocalOnly).withColumn(BlankColumn.of("lastSeenSpace", 6), this::isNotLocalOnly).withColumn(ITextComponentColumn.of("timePlayed", this.getTitleComponent(Translations.TIME_PLAYED), Column.Alignment.CENTER)).withColumn(BlankColumn.of("timePlayedSpace", 6)).withColumn(ITextComponentColumn.of("kill", this.getTitleComponent(Translations.KILLS), Column.Alignment.CENTER)).withColumn(BlankColumn.of("killSpace", 6)).withColumn(ITextComponentColumn.of("death", this.getTitleComponent(Translations.DEATHS), Column.Alignment.CENTER)).withColumn(BlankColumn.of("deathSpace", 6)).withColumn(ITextComponentColumn.of("deathPerHour", this.getTitleComponent(Translations.DEATHS_PER_HOUR), Column.Alignment.CENTER)).withColumn(BlankColumn.of("deathPerHourSpace", 6)).build();
    }

    private boolean isNotLocalOnly() {
        return !Minecraft.m_91087_().m_91091_();
    }

    private Component getTitleComponent(Translations title) {
        return title.get(ChatFormatting.DARK_GREEN);
    }

    private List<Row> getPagedRows(List<Row> rows, int itemsPerPage) {
        LinkedList result = rows.stream().skip((this.page - 1) * itemsPerPage).limit(itemsPerPage).collect(Collectors.toCollection(LinkedList::new));
        result.addFirst(this.buildTitleRow());
        return result;
    }

    private Component getPlayerName(PlayerStat playerStat) {
        return Component.m_237113_((String)playerStat.playerName());
    }

    private Component getPlayerLastSeen(PlayerStat playerStat) {
        if (playerStat.lastOnline() == 0L) {
            return Translations.NOW.get(ChatFormatting.GREEN);
        }
        if (playerStat.lastOnline() < 0L) {
            return Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED);
        }
        return Component.m_237113_((String)PlayerTabStatListOverlay.formatTime(playerStat.lastOnline()));
    }

    private Component getPlayerTimePlayed(PlayerStat playerStat) {
        int playTime = playerStat.playTime();
        if (playTime < 0) {
            return Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED);
        }
        return Component.m_237113_((String)PlayerTabStatListOverlay.formatTime((long)playTime / 20L));
    }

    private Component getPlayerKills(PlayerStat playerStat) {
        int kills = playerStat.kills();
        if (kills < 0) {
            return Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED);
        }
        return Component.m_237113_((String)Integer.toString(kills));
    }

    private Component getPlayerDeaths(PlayerStat playerStat) {
        int deaths = playerStat.deaths();
        if (deaths < 0) {
            return Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED);
        }
        return Component.m_237113_((String)Integer.toString(deaths));
    }

    private Component getPlayerDeathsPerHour(PlayerStat playerStat) {
        int playTime = playerStat.playTime();
        int deaths = playerStat.deaths();
        if (playTime < 0 || deaths < 0) {
            return Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED);
        }
        double hours = (double)((long)playTime / 20L) / 3600.0;
        if (hours != 0.0) {
            double deathsPerHour = (double)deaths / hours;
            return Component.m_237113_((String)(deathsPerHour < 0.0 ? "-" : String.format("%.2f", deathsPerHour)));
        }
        return Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED);
    }

    public static String formatTime(long secs) {
        StringBuilder sb = new StringBuilder();
        long days = secs / 86400L;
        long hours = secs / 3600L % 24L;
        long minutes = secs / 60L % 60L;
        if (days > 0L) {
            sb.append(days);
            sb.append("d ");
        }
        if (hours > 0L || days > 0L) {
            if (hours < 10L) {
                sb.append("0");
            }
            sb.append(hours);
            sb.append("h ");
        }
        if (minutes < 10L) {
            sb.append("0");
        }
        sb.append(minutes);
        sb.append("m");
        return sb.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PlayerComparator
    implements Comparator<PlayerStat> {
        PlayerComparator() {
        }

        @Override
        public int compare(PlayerStat player1, PlayerStat player2) {
            return Comparator.comparing(PlayerStat::getLastOnlineOrNull, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(PlayerStat::playTime).reversed().thenComparing(PlayerStat::deaths).thenComparing(PlayerStat::kills).reversed().compare(player1, player2);
        }
    }
}

