/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.client.columns;

import com.black_dog20.tabstats.repack.bml.client.rows.RowDrawingContext;
import com.black_dog20.tabstats.repack.bml.client.rows.columns.Column;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.resources.ResourceLocation;

public class OfflineHeadColumn
extends Column {
    private static final Map<UUID, PlayerInfo> playerInfoCache = new ConcurrentHashMap<UUID, PlayerInfo>();
    private final UUID uuid;
    private final String playerName;
    private final boolean display;

    protected OfflineHeadColumn(String id, UUID uuid, String playerName, Column.Alignment alignment) {
        super(id, alignment);
        this.uuid = uuid;
        this.playerName = playerName;
        this.display = Minecraft.m_91087_().m_91090_() || Minecraft.m_91087_().m_91403_().m_104910_().m_129535_();
    }

    public static OfflineHeadColumn of(String id, UUID uuid, String playerName) {
        return new OfflineHeadColumn(id, uuid, playerName, Column.Alignment.CENTER);
    }

    @Override
    public int getWidth() {
        if (this.display) {
            return 10;
        }
        return 0;
    }

    @Override
    public void render(RowDrawingContext context) {
        PlayerInfo info;
        if (!playerInfoCache.containsKey(this.uuid)) {
            Minecraft.m_91087_().m_91089_();
            boolean flag = Optional.ofNullable(Minecraft.m_91087_().m_91089_()).map(ServerData::m_242962_).orElse(false);
            info = new PlayerInfo(new GameProfile(this.uuid, this.playerName), flag);
            info.m_105337_();
            playerInfoCache.put(this.uuid, info);
        } else {
            info = playerInfoCache.get(this.uuid);
        }
        if (this.display) {
            ResourceLocation location = info.m_105337_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
            int l2 = 8;
            int i3 = 8;
            context.guiGraphics.m_280411_(location, (int)context.x, (int)context.y, 8, 8, 8.0f, (float)l2, 8, i3, 64, 64);
            int j3 = 8;
            int k3 = 8;
            context.guiGraphics.m_280411_(location, (int)context.x, (int)context.y, 8, 8, 40.0f, (float)j3, 8, k3, 64, 64);
        }
    }

    @Override
    public int getHeight() {
        if (this.display) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return 9;
        }
        return 0;
    }
}

