/*
 * Decompiled with CFR 0.152.
 */
package com.github.dodo.dodosmobs.message;

import com.github.dodo.dodosmobs.DodosMobs;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdateBossBar {
    private UUID bossBar;
    private int renderType;

    public MessageUpdateBossBar(UUID bossBar, int renderType) {
        this.bossBar = bossBar;
        this.renderType = renderType;
    }

    public static MessageUpdateBossBar read(FriendlyByteBuf buf) {
        return new MessageUpdateBossBar(buf.m_130259_(), buf.readInt());
    }

    public static void write(MessageUpdateBossBar message, FriendlyByteBuf buf) {
        buf.m_130077_(message.bossBar);
        buf.writeInt(message.renderType);
    }

    public static void handle(MessageUpdateBossBar message, Supplier<NetworkEvent.Context> context) {
        context.get().setPacketHandled(true);
        ServerPlayer playerSided = context.get().getSender();
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            playerSided = DodosMobs.PROXY.getClientSidePlayer();
        }
        if (message.renderType == -1) {
            DodosMobs.PROXY.removeBossBarRender(message.bossBar);
        } else {
            DodosMobs.PROXY.setBossBarRender(message.bossBar, message.renderType);
        }
    }
}

