/*
 * Decompiled with CFR 0.152.
 */
package com.github.dodo.dodosmobs.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="dodosmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DodoMobs_Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    private static ForgeConfigSpec.BooleanValue buildBoolean(ForgeConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }

    private static ForgeConfigSpec.IntValue buildInt(ForgeConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ForgeConfigSpec.DoubleValue buildDouble(ForgeConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.DoubleValue Bone_Chimera_HealthMultiplier;
        public final ForgeConfigSpec.DoubleValue Bone_Chimera_DamageMultiplier;
        public final ForgeConfigSpec.DoubleValue Dead_Horn_HealthMultiplier;
        public final ForgeConfigSpec.DoubleValue Dead_Horn_DamageMultiplier;
        public final ForgeConfigSpec.DoubleValue Mecha_Dino_HealthMultiplier;
        public final ForgeConfigSpec.DoubleValue Mecha_Dino_DamageMultiplier;
        public final ForgeConfigSpec.DoubleValue LizardMan_Guardian_HealthMultiplier;
        public final ForgeConfigSpec.DoubleValue LizardMan_Guardian_DamageMultiplier;
        public final ForgeConfigSpec.IntValue Return_Home_Tick;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            builder.push("Bone Chimera");
            this.Bone_Chimera_HealthMultiplier = DodoMobs_Config.buildDouble(builder, "Bone Chimera HealthMultiplier", 1.0, 0.0, 1000000.0, "Bone Chimera's Health Multiplier");
            this.Bone_Chimera_DamageMultiplier = DodoMobs_Config.buildDouble(builder, "Bone Chimera DamageMultiplier", 1.0, 0.0, 1000000.0, "Bone Chimera's Damage Multiplier");
            builder.pop();
            builder.push("Dead Horn");
            this.Dead_Horn_HealthMultiplier = DodoMobs_Config.buildDouble(builder, "Dead Horn HealthMultiplier", 1.0, 0.0, 1000000.0, "Dead Horn's Health Multiplier");
            this.Dead_Horn_DamageMultiplier = DodoMobs_Config.buildDouble(builder, "Dead Horn DamageMultiplier", 1.0, 0.0, 1000000.0, "Dead Horn's Damage Multiplier");
            builder.pop();
            builder.push("Mecha Dino");
            this.Mecha_Dino_HealthMultiplier = DodoMobs_Config.buildDouble(builder, "Mecha Dino HealthMultiplier", 1.0, 0.0, 1000000.0, "Mecha Dino's Health Multiplier");
            this.Mecha_Dino_DamageMultiplier = DodoMobs_Config.buildDouble(builder, "Mecha Dino DamageMultiplier", 1.0, 0.0, 1000000.0, "Mecha Dino's Damage Multiplier");
            builder.pop();
            builder.push("LizardMan Guardian");
            this.LizardMan_Guardian_HealthMultiplier = DodoMobs_Config.buildDouble(builder, "Mecha Dino HealthMultiplier", 1.0, 0.0, 1000000.0, "Mecha Dino's Health Multiplier");
            this.LizardMan_Guardian_DamageMultiplier = DodoMobs_Config.buildDouble(builder, "Mecha Dino DamageMultiplier", 1.0, 0.0, 1000000.0, "Mecha Dino's Damage Multiplier");
            builder.pop();
            builder.push("etc");
            this.Return_Home_Tick = DodoMobs_Config.buildInt(builder, "ReturnHomeTick", 20, 0, 200, "If the boss leaves the summoned location and there is no target, it returns to the summoned location. When set to 0, it does not return");
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue ScreenShake;
        public final ForgeConfigSpec.BooleanValue CustomBossBar;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("Etc");
            this.ScreenShake = DodoMobs_Config.buildBoolean(builder, "ScreenShake(on/off)", true, "ScreenShake(on/off)");
            this.CustomBossBar = DodoMobs_Config.buildBoolean(builder, "CustomBossBar(on/off)", true, "CustomBossBar(on/off)");
            builder.pop();
        }
    }
}

