/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.capability;

import com.p1nero.invincible.capability.InvinciblePlayer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mod.EventBusSubscriber(modid="invincible")
public class InvinciblePlayerCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<InvinciblePlayer> INVINCIBLE_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<InvinciblePlayer>(){});
    private InvinciblePlayer invinciblePlayer = null;
    private final LazyOptional<InvinciblePlayer> optional = LazyOptional.of(this::createInvinciblePlayer);

    private InvinciblePlayer createInvinciblePlayer() {
        if (this.invinciblePlayer == null) {
            this.invinciblePlayer = new InvinciblePlayer();
        }
        return this.invinciblePlayer;
    }

    public static InvinciblePlayer get(Player player) {
        return (InvinciblePlayer)player.getCapability(INVINCIBLE_PLAYER).orElse((Object)new InvinciblePlayer());
    }

    public static InvinciblePlayer get(PlayerPatch<?> playerPatch) {
        return InvinciblePlayerCapabilityProvider.get((Player)playerPatch.getOriginal());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == INVINCIBLE_PLAYER) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createInvinciblePlayer().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createInvinciblePlayer().loadNBTData(tag);
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(INVINCIBLE_PLAYER).ifPresent(oldStore -> event.getEntity().getCapability(INVINCIBLE_PLAYER).ifPresent(newStore -> newStore.copyFrom((InvinciblePlayer)oldStore)));
        }
    }
}

