/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.bsb;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="better_structure_block", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BetterStructureBlockConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.IntValue SEARCH_SIZE = BetterStructureBlockConfig.createInt("search_size", 80, "\u641c\u7d22\u89d2\u843d\u65b9\u5757\u7684\u8303\u56f4");
    public static final ForgeConfigSpec.BooleanValue LOAD_DIRECTLY = BetterStructureBlockConfig.createBool("load_directly", false, "\u662f\u5426\u7acb\u5373\u52a0\u8f7d");
    public static final ForgeConfigSpec.BooleanValue DESTROY_AFTER_LOAD = BetterStructureBlockConfig.createBool("destroy_after_load", false, "\u662f\u5426\u5728\u52a0\u8f7d\u540e\u81ea\u6bc1");
    public static final ForgeConfigSpec.BooleanValue DISABLE_CLIENT_MESSAGE_DISPLAY = BetterStructureBlockConfig.createBool("disable_client_message_display", true, "\u7981\u7528\u5ba2\u6237\u7aef\u663e\u793a");
    static final ForgeConfigSpec SPEC = BUILDER.build();

    private static ForgeConfigSpec.BooleanValue createBool(String key, boolean defaultValue, String ... comment) {
        return BUILDER.comment(comment).translation("config.better_structure_block." + key).define(key, defaultValue);
    }

    private static ForgeConfigSpec.IntValue createInt(String key, int defaultValue, String ... comment) {
        return BUILDER.comment(comment).translation("config.better_structure_block." + key).defineInRange(key, defaultValue, 0, Integer.MAX_VALUE);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"better_structure_block").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"load_directly").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> BetterStructureBlockConfig.setConfig(LOAD_DIRECTLY, BoolArgumentType.getBool((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"disable_client_message_display").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> BetterStructureBlockConfig.setConfig(DISABLE_CLIENT_MESSAGE_DISPLAY, BoolArgumentType.getBool((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"destroy_after_load").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> BetterStructureBlockConfig.setConfig(DESTROY_AFTER_LOAD, BoolArgumentType.getBool((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"search_size").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> BetterStructureBlockConfig.setConfig(SEARCH_SIZE, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource())))));
    }

    private static <T> int setConfig(ForgeConfigSpec.ConfigValue<T> config, T value, CommandSourceStack stack) {
        config.set(value);
        if (stack.m_230897_()) {
            Objects.requireNonNull(stack.m_230896_()).m_213846_((Component)Component.m_237113_((String)("Successfully set to : " + value)));
        }
        return 0;
    }
}

