/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kenddie.fantasyarmor.client.armor.model.lib.FAArmorModel;
import net.kenddie.fantasyarmor.client.armor.render.lib.FAArmorRenderer;
import net.kenddie.fantasyarmor.config.FAArmorEffectsConfig;
import net.kenddie.fantasyarmor.config.FAConfig;
import net.kenddie.fantasyarmor.item.armor.FAArmorAttributes;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public abstract class FAArmorItem
extends ArmorItem
implements GeoItem {
    private static final Map<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (Map)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        map.put(ArmorItem.Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        map.put(ArmorItem.Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        map.put(ArmorItem.Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final FAArmorSet armorSet;
    private final Supplier<FAArmorAttributes> attributesSupplier;
    private Multimap<Attribute, AttributeModifier> cachedModifiers;

    protected FAArmorItem(FAArmorSet armorSet, ArmorItem.Type type, Supplier<FAArmorAttributes> attributesSupplier) {
        super((ArmorMaterial)ArmorMaterials.NETHERITE, type, new Item.Properties().m_41487_(1).m_41486_());
        this.armorSet = armorSet;
        this.attributesSupplier = attributesSupplier;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (FAConfig.showDescriptions) {
            super.m_7373_(stack, world, tooltip, flag);
            String translationKey = this.m_5524_() + ".tooltip";
            tooltip.add((Component)Component.m_237115_((String)translationKey));
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<? extends FAArmorItem> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = FAArmorItem.this.createArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != this.f_265916_.m_266308_() || !FAConfig.applyModifiers) {
            return super.getAttributeModifiers(slot, stack);
        }
        if (this.cachedModifiers == null) {
            this.cachedModifiers = this.buildModifiers();
        }
        return this.cachedModifiers;
    }

    private Multimap<Attribute, AttributeModifier> buildModifiers() {
        FAArmorAttributes armorAttributes = this.attributesSupplier.get();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(this.f_265916_);
        if (armorAttributes.armor() != 0.0) {
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor", armorAttributes.armor(), AttributeModifier.Operation.ADDITION));
        }
        if (armorAttributes.armorToughness() != 0.0) {
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", armorAttributes.armorToughness(), AttributeModifier.Operation.ADDITION));
        }
        if (armorAttributes.knockbackResistance() != 0.0) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", armorAttributes.knockbackResistance(), AttributeModifier.Operation.ADDITION));
        }
        if (armorAttributes.movementSpeed() != 0.0) {
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Armor movement speed", armorAttributes.movementSpeed(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (armorAttributes.maxHealth() != 0.0) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, "Armor health gain", armorAttributes.maxHealth(), AttributeModifier.Operation.ADDITION));
        }
        if (armorAttributes.attackDamage() != 0.0) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "Armor attack damage", armorAttributes.attackDamage(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (armorAttributes.attackSpeed() != 0.0) {
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(uuid, "Armor attack speed", armorAttributes.attackSpeed(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (armorAttributes.luck() != 0.0) {
            builder.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(uuid, "Armor luck", armorAttributes.luck(), AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected GeoArmorRenderer<? extends FAArmorItem> createArmorRenderer() {
        return new FAArmorRenderer(new FAArmorModel(this.armorSet.getGeoPath(), this.armorSet.getTexturePath()));
    }

    public List<MobEffectInstance> getFullSetEffects() {
        return ((FAArmorEffectsConfig)FAArmorEffectsConfig.ARMOR_EFFECTS_CONFIGS.getOrDefault(this.armorSet.getName(), null)).getEffects();
    }
}

