/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.client.armor.render.lib;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.kenddie.fantasyarmor.FantasyArmor;
import net.kenddie.fantasyarmor.client.armor.render.lib.FARenderUtils;
import net.kenddie.fantasyarmor.config.FAConfig;
import net.kenddie.fantasyarmor.item.armor.FAArmorItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class FAArmorRenderer<T extends FAArmorItem>
extends GeoArmorRenderer<T> {
    protected GeoBone cape = null;
    protected GeoBone frontCape = null;
    protected GeoBone leftLegCloth = null;
    protected GeoBone rightLegCloth = null;
    protected GeoBone braid = null;
    protected GeoBone epicFightCape = null;

    public FAArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    @Nullable
    public GeoBone getCapeBone(GeoModel<T> model) {
        return model.getBone("armorCape").orElse(null);
    }

    @Nullable
    public GeoBone getFrontCapeBone(GeoModel<T> model) {
        return model.getBone("armorFrontCape").orElse(null);
    }

    @Nullable
    public GeoBone getLeftLegClothBone(GeoModel<T> model) {
        return model.getBone("armorLeftLegCloth").orElse(null);
    }

    @Nullable
    public GeoBone getRightLegClothBone(GeoModel<T> model) {
        return model.getBone("armorRightLegCloth").orElse(null);
    }

    @Nullable
    public GeoBone getBraidBone(GeoModel<T> model) {
        return model.getBone("armorBraid").orElse(null);
    }

    @Nullable
    public GeoBone getEpicFightCapeBone(GeoModel<T> model) {
        return model.getBone("armorCapeEpicFight").orElse(null);
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        super.grabRelevantBones(bakedModel);
        GeoModel model = this.getGeoModel();
        this.cape = this.getCapeBone(model);
        this.frontCape = this.getFrontCapeBone(model);
        this.leftLegCloth = this.getLeftLegClothBone(model);
        this.rightLegCloth = this.getRightLegClothBone(model);
        this.braid = this.getBraidBone(model);
        this.epicFightCape = this.getEpicFightCapeBone(model);
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        super.applyBoneVisibilityBySlot(currentSlot);
        switch (currentSlot) {
            case HEAD: {
                this.setBoneVisible(this.braid, true);
                this.setBoneVisible(this.cape, false);
                this.setBoneVisible(this.epicFightCape, false);
                this.setBoneVisible(this.frontCape, false);
                this.setBoneVisible(this.leftLegCloth, false);
                this.setBoneVisible(this.rightLegCloth, false);
                break;
            }
            case CHEST: {
                boolean showCape = FAConfig.showCapes;
                boolean useEpicFightCape = FantasyArmor.isEpicFightLoaded && !FAConfig.epicFightNotStaticCapes;
                this.setBoneVisible(this.cape, showCape && !useEpicFightCape);
                this.setBoneVisible(this.epicFightCape, showCape && useEpicFightCape);
                this.setBoneVisible(this.frontCape, true);
                this.setBoneVisible(this.leftLegCloth, true);
                this.setBoneVisible(this.rightLegCloth, true);
                this.setBoneVisible(this.braid, false);
                break;
            }
            case LEGS: 
            case FEET: {
                this.setBoneVisible(this.braid, false);
                this.setBoneVisible(this.cape, false);
                this.setBoneVisible(this.epicFightCape, false);
                this.setBoneVisible(this.frontCape, false);
                this.setBoneVisible(this.leftLegCloth, false);
                this.setBoneVisible(this.rightLegCloth, false);
                break;
            }
        }
    }

    public void applyBoneVisibilityByPart(EquipmentSlot currentSlot, ModelPart currentPart, HumanoidModel<?> model) {
        super.applyBoneVisibilityByPart(currentSlot, currentPart, model);
        if (currentPart == model.f_102810_) {
            boolean useEpicFightCape;
            boolean showCape = FAConfig.showCapes;
            boolean bl = useEpicFightCape = FantasyArmor.isEpicFightLoaded && !FAConfig.epicFightNotStaticCapes;
            if (this.cape != null) {
                this.cape.setHidden(!showCape || useEpicFightCape);
            }
            if (this.epicFightCape != null) {
                this.epicFightCape.setHidden(!showCape || !useEpicFightCape);
            }
            if (this.frontCape != null) {
                this.frontCape.setHidden(false);
            }
            if (this.leftLegCloth != null) {
                this.leftLegCloth.setHidden(false);
            }
            if (this.rightLegCloth != null) {
                this.rightLegCloth.setHidden(false);
            }
        } else if (currentPart == model.f_102808_ && this.braid != null) {
            this.braid.setHidden(false);
        }
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Player player;
        Entity entity;
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.frontCape != null) {
            FARenderUtils.setFrontLegCapeAngle(this, this.frontCape);
        }
        if (this.cape != null) {
            entity = this.currentEntity;
            if (entity instanceof Player) {
                player = (Player)entity;
                FARenderUtils.applyCapeRotation(player, this.cape, partialTick);
            } else {
                this.cape.updateRotation((float)(-Math.toRadians(5.0)), 0.0f, 0.0f);
            }
        }
        if (this.braid != null && (entity = this.currentEntity) instanceof Player) {
            player = (Player)entity;
            FARenderUtils.applyBraidRotation(player, this.braid, partialTick);
        }
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        ModelPart leftLegPart;
        super.applyBaseTransformations(baseModel);
        if (this.cape != null) {
            ModelPart bodyPart = baseModel.f_102810_;
            float yPos = this.f_102817_ ? bodyPart.f_104201_ - 3.5f : bodyPart.f_104201_;
            this.cape.updatePosition(bodyPart.f_104200_, yPos, bodyPart.f_104202_);
        }
        if (this.frontCape != null) {
            leftLegPart = baseModel.f_102814_;
            this.frontCape.updatePosition(leftLegPart.f_104200_ - 1.95f, 13.0f - leftLegPart.f_104201_, leftLegPart.f_104202_ - 0.1f);
        }
        if (this.leftLegCloth != null) {
            leftLegPart = baseModel.f_102814_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.leftLegCloth);
            this.leftLegCloth.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
        }
        if (this.rightLegCloth != null) {
            ModelPart rightLegPart = baseModel.f_102813_;
            RenderUtils.matchModelPartRot((ModelPart)rightLegPart, (CoreGeoBone)this.rightLegCloth);
            this.rightLegCloth.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - rightLegPart.f_104201_, rightLegPart.f_104202_);
        }
    }

    public void m_8009_(boolean pVisible) {
        super.m_8009_(pVisible);
        boolean showCape = FAConfig.showCapes && pVisible;
        boolean useEpicFightCape = FantasyArmor.isEpicFightLoaded && !FAConfig.epicFightNotStaticCapes;
        this.setBoneVisible(this.cape, showCape && !useEpicFightCape);
        this.setBoneVisible(this.epicFightCape, showCape && useEpicFightCape);
        this.setBoneVisible(this.cape, pVisible);
        this.setBoneVisible(this.frontCape, pVisible);
        this.setBoneVisible(this.leftLegCloth, pVisible);
        this.setBoneVisible(this.rightLegCloth, pVisible);
        this.setBoneVisible(this.braid, pVisible);
        this.setBoneVisible(this.epicFightCape, pVisible);
    }
}

