/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;
import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.TaskScreenRenderer;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.item.LootCrateItem;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.StructureTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClientEventHandler {
    private static final ResourceLocation QUESTS_BUTTON = new ResourceLocation("ftbquests", "quests");
    static boolean creativeTabRebuildPending = false;
    private List<ObservationTask> observationTasks = null;
    private ObservationTask currentlyObserving = null;
    private long currentlyObservingTicks = 0L;
    private final List<FormattedCharSequence> pinnedQuestText = new ArrayList<FormattedCharSequence>();
    public static TextureAtlasSprite inputOnlySprite;
    public static TextureAtlasSprite tankSprite;
    public static TextureAtlasSprite feEnergyEmptySprite;
    public static TextureAtlasSprite feEnergyFullSprite;
    public static TextureAtlasSprite trEnergyEmptySprite;
    public static TextureAtlasSprite trEnergyFullSprite;

    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::registerItemColors);
        ClientLifecycleEvent.CLIENT_SETUP.register(this::registerBERs);
        SidebarButtonCreatedEvent.EVENT.register(this::onSidebarButtonCreated);
        ClearFileCacheEvent.EVENT.register(this::onFileCacheClear);
        ClientTickEvent.CLIENT_PRE.register(this::onKeyEvent);
        CustomClickEvent.EVENT.register(this::onCustomClick);
        ClientTickEvent.CLIENT_PRE.register(this::onClientTick);
        ClientGuiEvent.RENDER_HUD.register(this::onScreenRender);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(this::onPlayerLogin);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::onPlayerLogout);
    }

    public static void onTextureStitchPost(TextureAtlas textureAtlas) {
        if (textureAtlas.m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            inputOnlySprite = textureAtlas.m_118316_(TaskScreenRenderer.INPUT_ONLY_TEXTURE);
            tankSprite = textureAtlas.m_118316_(TaskScreenRenderer.TANK_TEXTURE);
            feEnergyEmptySprite = textureAtlas.m_118316_(TaskScreenRenderer.FE_ENERGY_EMPTY_TEXTURE);
            feEnergyFullSprite = textureAtlas.m_118316_(TaskScreenRenderer.FE_ENERGY_FULL_TEXTURE);
            trEnergyEmptySprite = textureAtlas.m_118316_(TaskScreenRenderer.TR_ENERGY_EMPTY_TEXTURE);
            trEnergyFullSprite = textureAtlas.m_118316_(TaskScreenRenderer.TR_ENERGY_FULL_TEXTURE);
        }
    }

    private void registerBERs(Minecraft minecraft) {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)FTBQuestsBlockEntities.CORE_TASK_SCREEN.get()), TaskScreenRenderer::new);
    }

    private void registerItemColors(Minecraft minecraft) {
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> {
            LootCrate crate = LootCrateItem.getCrate(stack);
            return crate == null ? -1 : 0xFF000000 | crate.getColor().rgb();
        }, (ItemLike[])new ItemLike[]{(ItemLike)FTBQuestsItems.LOOTCRATE.get()});
    }

    private void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().getId().equals((Object)QUESTS_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (ClientQuestFile.exists()) {
                    if (ClientQuestFile.INSTANCE.isDisableGui() && !ClientQuestFile.INSTANCE.canEdit()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.selfTeamData.isLocked()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.selfTeamData.hasUnclaimedRewards(Minecraft.m_91087_().f_91074_.m_20148_(), ClientQuestFile.INSTANCE)) {
                        return "[!]";
                    }
                }
                return "";
            });
        }
    }

    private void onFileCacheClear(BaseQuestFile file) {
        if (!file.isServerSide()) {
            this.observationTasks = null;
        }
    }

    private void onKeyEvent(Minecraft mc) {
        if (ClientQuestFile.exists() && (!ClientQuestFile.INSTANCE.isDisableGui() || ClientQuestFile.INSTANCE.canEdit()) && FTBQuestsClient.KEY_QUESTS.m_90859_()) {
            ClientQuestFile.openGui();
        }
    }

    private EventResult onCustomClick(CustomClickEvent event) {
        if (event.id().m_135827_().equals("ftbquests") && "open_gui".equals(event.id().m_135815_())) {
            double mx = Minecraft.m_91087_().f_91067_.m_91589_();
            double my = Minecraft.m_91087_().f_91067_.m_91594_();
            Minecraft.m_91087_().m_91152_(null);
            if (ClientQuestFile.openGui() != null) {
                InputConstants.m_84833_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)212993, (double)mx, (double)my);
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private void onClientTick(Minecraft mc) {
        if (mc.f_91073_ != null && ClientQuestFile.exists() && mc.f_91074_ != null) {
            this.collectPinnedQuests(ClientQuestFile.INSTANCE);
            if (this.observationTasks == null) {
                this.observationTasks = ClientQuestFile.INSTANCE.collect(ObservationTask.class);
            }
            if (this.observationTasks.isEmpty()) {
                return;
            }
            this.currentlyObserving = null;
            TeamData selfTeamData = ClientQuestFile.INSTANCE.selfTeamData;
            if (mc.f_91077_ != null && mc.f_91077_.m_6662_() != HitResult.Type.MISS) {
                for (ObservationTask task : this.observationTasks) {
                    if (selfTeamData.isCompleted(task) || !task.observe((Player)mc.f_91074_, mc.f_91077_) || !selfTeamData.canStartTasks(task.getQuest())) continue;
                    this.currentlyObserving = task;
                    break;
                }
            }
            if (this.currentlyObserving != null) {
                if (!mc.m_91104_()) {
                    ++this.currentlyObservingTicks;
                }
                if (this.currentlyObservingTicks >= this.currentlyObserving.getTimer()) {
                    new SubmitTaskMessage(this.currentlyObserving.id).sendToServer();
                    selfTeamData.addProgress(this.currentlyObserving, 1L);
                    this.currentlyObserving = null;
                    this.currentlyObservingTicks = 0L;
                }
            } else {
                this.currentlyObservingTicks = 0L;
            }
        }
    }

    private void onPlayerLogin(LocalPlayer localPlayer) {
        if (creativeTabRebuildPending) {
            FTBQuestsClient.rebuildCreativeTabs();
            creativeTabRebuildPending = false;
        }
    }

    private void onPlayerLogout(@Nullable LocalPlayer localPlayer) {
        StructureTask.syncKnownStructureList(List.of());
    }

    private void collectPinnedQuests(ClientQuestFile file) {
        TeamData data = file.selfTeamData;
        ArrayList pinnedQuests = new ArrayList();
        LongSet pinnedIds = data.getPinnedQuestIds(FTBQuestsClient.getClientPlayer());
        if (!pinnedIds.isEmpty()) {
            if (pinnedIds.contains(1L)) {
                file.forAllQuests(quest -> {
                    if (!data.isCompleted((QuestObject)quest) && data.canStartTasks((Quest)quest) && quest.isVisible(data)) {
                        pinnedQuests.add(quest);
                    }
                });
            } else {
                pinnedIds.longStream().mapToObj(file::getQuest).filter(Objects::nonNull).forEach(pinnedQuests::add);
            }
        }
        Minecraft mc = Minecraft.m_91087_();
        this.pinnedQuestText.clear();
        for (int i = 0; i < pinnedQuests.size(); ++i) {
            Quest quest2 = (Quest)pinnedQuests.get(i);
            if (i > 0) {
                this.pinnedQuestText.add(FormattedCharSequence.f_13691_);
            }
            this.pinnedQuestText.addAll(mc.f_91062_.m_92923_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{mc.f_91062_.m_92865_().m_92389_((FormattedText)quest2.getTitle(), 160, Style.f_131099_.m_131136_(Boolean.valueOf(true))), Component.m_237113_((String)" ").m_130940_(ChatFormatting.DARK_AQUA).m_130946_(data.getRelativeProgress(quest2) + "%")}), 500));
            for (Task task : quest2.getTasks()) {
                if (data.isCompleted(task)) continue;
                this.pinnedQuestText.addAll(mc.f_91062_.m_92923_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{mc.f_91062_.m_92865_().m_92389_((FormattedText)task.getMutableTitle().m_130940_(ChatFormatting.GRAY), 160, Style.f_131099_.m_131157_(ChatFormatting.GRAY)), Component.m_237113_((String)" ").m_130940_(ChatFormatting.GREEN).m_130946_(task.formatProgress(data, data.getProgress(task))).m_130946_("/").m_130946_(task.formatMaxProgress())}), 500));
            }
        }
    }

    private void onScreenRender(GuiGraphics graphics, float tickDelta) {
        if (!ClientQuestFile.exists()) {
            return;
        }
        ClientQuestFile file = ClientQuestFile.INSTANCE;
        Minecraft mc = Minecraft.m_91087_();
        int cy = mc.m_91268_().m_85446_() / 2;
        if (this.currentlyObserving != null) {
            int cx = mc.m_91268_().m_85445_() / 2;
            MutableComponent cot = this.currentlyObserving.getMutableTitle().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE});
            int sw = mc.f_91062_.m_92852_((FormattedText)cot);
            int bw = Math.max(sw, 100);
            Color4I.DARK_GRAY.withAlpha(130).draw(graphics, cx - bw / 2 - 3, cy - 63, bw + 6, 29);
            GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)(cx - bw / 2 - 3), (int)(cy - 63), (int)(bw + 6), (int)29, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            graphics.m_280430_(mc.f_91062_, (Component)cot, cx - sw / 2, cy - 60, 0xFFFFFF);
            double completed = (double)((float)this.currentlyObservingTicks + tickDelta) / (double)this.currentlyObserving.getTimer();
            GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)(cx - bw / 2), (int)(cy - 49), (int)bw, (int)12, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            Color4I.LIGHT_BLUE.withAlpha(130).draw(graphics, cx - bw / 2 + 1, cy - 48, (int)(((double)bw - 2.0) * completed), 10);
            String cop = this.currentlyObservingTicks * 100L / this.currentlyObserving.getTimer() + "%";
            graphics.m_280488_(mc.f_91062_, cop, cx - mc.f_91062_.m_92895_(cop) / 2, cy - 47, 0xFFFFFF);
        }
        if (!this.pinnedQuestText.isEmpty()) {
            int width = 0;
            for (FormattedCharSequence s : this.pinnedQuestText) {
                width = Math.max(width, (int)mc.f_91062_.m_92865_().m_92336_(s));
            }
            width += 8;
            Objects.requireNonNull(mc.f_91062_);
            int height = 9 * this.pinnedQuestText.size() + 8;
            float scale = ((Double)ThemeProperties.PINNED_QUEST_SIZE.get(file)).floatValue();
            int insetX = (Integer)FTBQuestsClientConfig.PINNED_QUESTS_INSET_X.get();
            int insetY = (Integer)FTBQuestsClientConfig.PINNED_QUESTS_INSET_Y.get();
            PanelPositioning.PanelPos pos = ((PanelPositioning)FTBQuestsClientConfig.PINNED_QUESTS_POS.get()).getPanelPos(mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_(), (int)((float)width * scale), (int)((float)height * scale), insetX, insetY);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)pos.x(), (float)pos.y(), 100.0f);
            graphics.m_280168_().m_85841_(scale, scale, 1.0f);
            GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)0, (int)0, (int)width, (int)height, (Color4I)Color4I.BLACK.withAlpha(100), (boolean)false);
            Color4I.BLACK.withAlpha(100).draw(graphics, 0, 0, width, height);
            graphics.m_280168_().m_252880_(4.0f, 4.0f, 0.0f);
            for (int i = 0; i < this.pinnedQuestText.size(); ++i) {
                Font font = mc.f_91062_;
                Objects.requireNonNull(mc.f_91062_);
                graphics.m_280648_(font, this.pinnedQuestText.get(i), 0, i * 9, -1);
            }
            graphics.m_280168_().m_85849_();
        }
    }
}

