/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.logic.LocateCommandLogic;
import brightspark.asynclocator.mixins.CommandSourceStackAccess;
import brightspark.asynclocator.platform.Services;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LocateCommand.class})
public class LocateCommandMixin {
    @Inject(method={"locateStructure"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkGenerator;findNearestMapStructure(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/HolderSet;Lnet/minecraft/core/BlockPos;IZ)Lcom/mojang/datafixers/util/Pair;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void findLocationAsync(CommandSourceStack sourceStack, ResourceOrTagKeyArgument.Result<Structure> structureResult, CallbackInfoReturnable<Integer> cir, Registry<Structure> registry, HolderSet<Structure> holderset) {
        if (!Services.CONFIG.locateCommandEnabled()) {
            return;
        }
        CommandSource source = ((CommandSourceStackAccess)sourceStack).getSource();
        if (source instanceof ServerPlayer || source instanceof MinecraftServer) {
            ALConstants.logDebug("Intercepted LocateCommand#locate call", new Object[0]);
            LocateCommandLogic.locateAsync(sourceStack, structureResult, holderset);
            cir.setReturnValue((Object)0);
        }
    }
}

