/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.potatoCannon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AllPotatoProjectileRenderModes {
    public static void init() {
    }

    private static void register(String name, Codec<? extends PotatoProjectileRenderMode> codec) {
        Registry.m_122965_(CreateBuiltInRegistries.POTATO_PROJECTILE_RENDER_MODE, (ResourceLocation)Create.asResource(name), codec);
    }

    private static int entityRandom(Entity entity, int maxValue) {
        return System.identityHashCode(entity) * 31 % maxValue;
    }

    static {
        AllPotatoProjectileRenderModes.register("billboard", Billboard.CODEC);
        AllPotatoProjectileRenderModes.register("tumble", Tumble.CODEC);
        AllPotatoProjectileRenderModes.register("toward_motion", TowardMotion.CODEC);
        AllPotatoProjectileRenderModes.register("stuck_to_entity", StuckToEntity.CODEC);
    }

    public static enum Billboard implements PotatoProjectileRenderMode
    {
        INSTANCE;

        public static final Codec<Billboard> CODEC;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack ms, PotatoProjectileEntity entity, float pt) {
            Minecraft mc = Minecraft.m_91087_();
            Vec3 p1 = mc.m_91288_().m_20299_(pt);
            Vec3 diff = entity.m_20191_().m_82399_().m_82546_(p1);
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(AngleHelper.deg((double)Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_)) + 180.0f)).rotateXDegrees(AngleHelper.deg((double)Mth.m_14136_((double)diff.f_82480_, (double)Mth.m_14116_((float)((float)(diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_))))));
        }

        @Override
        public Codec<? extends PotatoProjectileRenderMode> codec() {
            return CODEC;
        }

        static {
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }

    public static enum Tumble implements PotatoProjectileRenderMode
    {
        INSTANCE;

        public static final Codec<Tumble> CODEC;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack ms, PotatoProjectileEntity entity, float pt) {
            Billboard.INSTANCE.transform(ms, entity, pt);
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateZDegrees(((float)entity.f_19797_ + pt) * 2.0f * (float)AllPotatoProjectileRenderModes.entityRandom((Entity)entity, 16))).rotateXDegrees(((float)entity.f_19797_ + pt) * (float)AllPotatoProjectileRenderModes.entityRandom((Entity)entity, 32));
        }

        @Override
        public Codec<? extends PotatoProjectileRenderMode> codec() {
            return CODEC;
        }

        static {
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }

    public record TowardMotion(int spriteAngleOffset, float spin) implements PotatoProjectileRenderMode
    {
        public static final Codec<TowardMotion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("sprite_angle_offset").forGetter(i -> i.spriteAngleOffset), (App)Codec.FLOAT.fieldOf("spin").forGetter(i -> Float.valueOf(i.spin))).apply((Applicative)instance, TowardMotion::new));

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack ms, PotatoProjectileEntity entity, float pt) {
            Vec3 diff = entity.m_20184_();
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(AngleHelper.deg((double)Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_)))).rotateXDegrees(270.0f + AngleHelper.deg((double)Mth.m_14136_((double)diff.f_82480_, (double)(-Mth.m_14116_((float)((float)(diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_)))))));
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(((float)entity.f_19797_ + pt) * 20.0f * this.spin + (float)AllPotatoProjectileRenderModes.entityRandom((Entity)entity, 360))).rotateZDegrees((float)(-this.spriteAngleOffset));
        }

        @Override
        public Codec<? extends PotatoProjectileRenderMode> codec() {
            return CODEC;
        }
    }

    public record StuckToEntity(Vec3 offset) implements PotatoProjectileRenderMode
    {
        public static final Codec<StuckToEntity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.f_231074_.fieldOf("offset").forGetter(i -> i.offset)).apply((Applicative)instance, StuckToEntity::new));

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack ms, PotatoProjectileEntity entity, float pt) {
            TransformStack.of((PoseStack)ms).rotateYDegrees(AngleHelper.deg((double)Mth.m_14136_((double)this.offset.f_82479_, (double)this.offset.f_82481_)));
        }

        @Override
        public Codec<? extends PotatoProjectileRenderMode> codec() {
            return CODEC;
        }
    }
}

