/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlock;
import com.simibubi.create.content.equipment.clipboard.ClipboardScreen;
import com.simibubi.create.content.logistics.AddressEditBoxHelper;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ClipboardBlockEntity
extends SmartBlockEntity {
    public ItemStack dataContainer = AllBlocks.CLIPBOARD.asStack();
    private UUID lastEdit;

    public ClipboardBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateWrittenState();
    }

    public void onEditedBy(Player player) {
        this.lastEdit = player.m_20148_();
        this.notifyUpdate();
        this.updateWrittenState();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::advertiseToAddressHelper);
        }
    }

    public void updateWrittenState() {
        boolean shouldBeWritten;
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.CLIPBOARD.has(blockState)) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean isWritten = (Boolean)blockState.m_61143_((Property)ClipboardBlock.WRITTEN);
        boolean bl = shouldBeWritten = this.dataContainer.m_41783_() != null;
        if (isWritten == shouldBeWritten) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)ClipboardBlock.WRITTEN, (Comparable)Boolean.valueOf(shouldBeWritten)));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("Item", (Tag)this.dataContainer.serializeNBT());
        if (clientPacket && this.lastEdit != null) {
            tag.m_128362_("LastEdit", this.lastEdit);
        }
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.dataContainer = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
        if (!AllBlocks.CLIPBOARD.isIn(this.dataContainer)) {
            this.dataContainer = AllBlocks.CLIPBOARD.asStack();
        }
        if (clientPacket) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.readClientSide(tag));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void readClientSide(CompoundTag tag) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (!(screen instanceof ClipboardScreen)) {
            return;
        }
        ClipboardScreen cs = (ClipboardScreen)screen;
        if (tag.m_128441_("LastEdit") && tag.m_128342_("LastEdit").equals(mc.f_91074_.m_20148_())) {
            return;
        }
        if (!this.f_58858_.equals((Object)cs.targetedBlock)) {
            return;
        }
        cs.reopenWith(this.dataContainer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void advertiseToAddressHelper() {
        AddressEditBoxHelper.advertiseClipboard(this);
    }
}

