/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.epicfight.animation.type.wraithon;

import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.merlin204.wraithon.entity.wraithon.EntityOBBCollider;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.WraithonEntityPatch;
import org.merlin204.wraithon.entity.wraithon.WraithonPartEntity;
import org.merlin204.wraithon.epicfight.animation.WraithonAnimations;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.IWraithonAnimation;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.BasicAttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class WraithonAttackAnimation
extends AvalonAttackAnimation
implements IWraithonAnimation {
    public WraithonAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature, play_speed, damageMulti);
    }

    public WraithonAttackAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti, AvalonAttackAnimation.AvalonPhase ... phases) {
        super(convertTime, path, armature, play_speed, damageMulti, phases);
    }

    public WraithonAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AvalonAttackAnimation.AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, phases);
    }

    public WraithonAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti, AvalonAttackAnimation.AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, play_speed, damageMulti, phases);
    }

    public WraithonAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float damageMulti, AvalonAttackAnimation.AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, damageMulti, phases);
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        WraithonEntityPatch wraithonEntityPatch;
        super.begin(entitypatch);
        if (entitypatch instanceof WraithonEntityPatch && !((DynamicAnimation)(wraithonEntityPatch = (WraithonEntityPatch)entitypatch).getAnimator().getPlayerFor(null).getAnimation().get()).isLinkAnimation()) {
            ((WraithonEntity)wraithonEntityPatch.getOriginal()).updateYRotBeforeRotation();
        }
    }

    protected void attackTick(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
        AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        float prevElapsedTime = player.getPrevElapsedTime();
        float elapsedTime = player.getElapsedTime();
        EntityState prevState = ((DynamicAnimation)animation.get()).getState(entitypatch, prevElapsedTime);
        EntityState state = ((DynamicAnimation)animation.get()).getState(entitypatch, elapsedTime);
        List activePhases = this.getActivePhases(elapsedTime);
        for (AttackAnimation.Phase phase : activePhases) {
            if (prevElapsedTime < phase.start && elapsedTime >= phase.start && phase instanceof AvalonAttackAnimation.AvalonPhase) {
                AvalonAttackAnimation.AvalonPhase avalonPhase = (AvalonAttackAnimation.AvalonPhase)phase;
                avalonPhase.resetAttackRecord(entitypatch);
            }
            if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
                MobPatch mobpatch = (MobPatch)entitypatch;
                ((Mob)mobpatch.getOriginal()).m_21573_().m_26573_();
                ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
            }
            if (!prevState.attacking() && !state.attacking() && (prevState.getLevel() > 2 || state.getLevel() <= 2)) continue;
            if (!prevState.attacking() || (prevElapsedTime < phase.start || prevElapsedTime >= phase.end) && (state.attacking() || prevState.getLevel() <= 2 && state.getLevel() > 2)) {
                entitypatch.playSound(this.getSwingSound(entitypatch, phase), 10.0f, 0.0f, 0.0f);
                entitypatch.removeHurtEntities();
            }
            this.hurtCollidingEntities(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
        }
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        if (prevElapsedTime < phase.start && elapsedTime >= phase.start) {
            entitypatch.getCurrentlyActuallyHitEntities().clear();
            entitypatch.getCurrentlyAttackTriedEntities().clear();
            if (phase instanceof AvalonAttackAnimation.AvalonPhase) {
                AvalonAttackAnimation.AvalonPhase avalonPhase = (AvalonAttackAnimation.AvalonPhase)phase;
                avalonPhase.resetAttackRecord(entitypatch);
            }
        }
        float phasePrevTime = Math.max(prevElapsedTime, phase.start);
        float phaseCurrentTime = Math.min(elapsedTime, phase.end);
        float phasePreDelay = phase.start + phase.preDelay;
        float phaseContact = phase.start + phase.contact;
        if (phaseCurrentTime < phasePreDelay || phasePrevTime >= phaseContact) {
            return;
        }
        List list = phase.getCollidingEntities(entitypatch, (AttackAnimation)this, phasePrevTime, phaseCurrentTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
        if (!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            while (hitEntities.next()) {
                Player player;
                boolean canAttack;
                Entity target = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(target);
                boolean bl = canAttack = trueEntity != null && trueEntity.m_6084_() && !entitypatch.getCurrentlyActuallyHitEntities().contains(trueEntity) && !entitypatch.isTargetInvulnerable(target);
                if (phase instanceof AvalonAttackAnimation.AvalonPhase) {
                    AvalonAttackAnimation.AvalonPhase avalonPhase = (AvalonAttackAnimation.AvalonPhase)phase;
                    boolean bl2 = canAttack = canAttack && avalonPhase.tryAttack(entitypatch, (Entity)trueEntity);
                }
                if (!canAttack || !entity.m_142582_(target)) continue;
                float number = 0.1f;
                if (target instanceof LivingEntity) {
                    LivingEntity hurtLivingEntity = (LivingEntity)target;
                    if (!hurtLivingEntity.m_21220_().isEmpty()) {
                        ArrayList<MobEffectInstance> waitToRemove = new ArrayList<MobEffectInstance>();
                        for (MobEffectInstance effectInstance : hurtLivingEntity.m_21220_()) {
                            if (effectInstance.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL) {
                                number += (float)(effectInstance.m_19564_() + 1) * 0.1f;
                                waitToRemove.add(effectInstance);
                                continue;
                            }
                            number += (float)(effectInstance.m_19564_() + 1) * 0.15f;
                        }
                        for (MobEffectInstance effectInstance : waitToRemove) {
                            hurtLivingEntity.m_21195_(effectInstance.m_19544_());
                            if (!(hurtLivingEntity instanceof Player)) continue;
                            player = (Player)hurtLivingEntity;
                            MutableComponent translatedMessage = Component.m_237115_((String)"mod.wraithon.tip_1").m_7220_((Component)effectInstance.m_19544_().m_19482_().m_6881_().m_130948_(Style.f_131099_.m_178520_(effectInstance.m_19544_().m_19484_()).m_131136_(Boolean.valueOf(true))));
                            player.m_213846_((Component)translatedMessage);
                        }
                    }
                    if (!(hurtLivingEntity instanceof Player)) {
                        hurtLivingEntity.m_21153_(hurtLivingEntity.m_21223_() - hurtLivingEntity.m_21233_() * number);
                        ((LivingEntity)entitypatch.getOriginal()).m_5634_(hurtLivingEntity.m_21233_() * number);
                    }
                }
                number = Math.min(number, 0.9f);
                EpicFightDamageSource damageSource = this.getEpicFightDamageSource(entitypatch, target, phase);
                int prevInvulTime = target.f_19802_;
                target.f_19802_ = 0;
                AttackResult attackResult = entitypatch.attack(damageSource, target, phase.hand);
                target.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    LivingEntity hurtLivingEntity;
                    if (!(!(target instanceof LivingEntity) || (hurtLivingEntity = (LivingEntity)target) instanceof Player && (player = (Player)hurtLivingEntity).m_7500_())) {
                        hurtLivingEntity.m_21153_(hurtLivingEntity.m_21223_() - hurtLivingEntity.m_21233_() * number);
                        ((LivingEntity)entitypatch.getOriginal()).m_5634_(hurtLivingEntity.m_21233_() * number);
                    }
                    target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getHitSound(entitypatch, phase), target.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)target.m_9236_(), entitypatch, target, phase);
                }
                entitypatch.getCurrentlyActuallyHitEntities().add(trueEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrentlyAttackTriedEntities().add(trueEntity);
            }
        }
    }

    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        if (entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor()).isEnd()) {
            JointTransform jt = pose.orElseEmpty("Root");
            jt.rotation().set(0.0f, 0.0f, 0.0f, 1.0f);
        }
        super.modifyPose(animation, pose, entitypatch, time, partialTicks);
    }

    public void end(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        WraithonEntityPatch wraithonEntityPatch;
        super.end(entityPatch, nextAnimation, isEnd);
        if (entityPatch instanceof WraithonEntityPatch && !((DynamicAnimation)(wraithonEntityPatch = (WraithonEntityPatch)entityPatch).getAnimator().getPlayerFor(null).getAnimation().get()).isLinkAnimation()) {
            ((WraithonEntity)wraithonEntityPatch.getOriginal()).setRotating(false);
        }
        if (!entityPatch.isLogicalClient()) {
            entityPatch.reserveAnimation(WraithonAnimations.WRAITHON_IDLE);
        }
    }

    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, float playbackTime, float partialTicks) {
        super.renderDebugging(poseStack, buffer, entitypatch, playbackTime, partialTicks);
        AnimationPlayer animPlayer = entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.accessor);
        float prevElapsedTime = animPlayer.getPrevElapsedTime();
        float elapsedTime = animPlayer.getElapsedTime();
        if (entitypatch instanceof WraithonEntityPatch) {
            WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entitypatch;
            for (WraithonPartEntity part : ((WraithonEntity)wraithonEntityPatch.getOriginal()).getSubEntities()) {
                for (Joint joint : part.entityOBBColliderMap.keySet()) {
                    EntityOBBCollider collider = part.entityOBBColliderMap.get(joint);
                    collider.draw(poseStack, buffer, entitypatch, (AttackAnimation)this, joint, prevElapsedTime, elapsedTime, partialTicks, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
                }
            }
        }
    }
}

