/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.epicfight.animation.type.wraithon;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;
import org.merlin204.wraithon.entity.wraithon.EntityOBBCollider;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.WraithonEntityPatch;
import org.merlin204.wraithon.entity.wraithon.WraithonPartEntity;
import org.merlin204.wraithon.epicfight.animation.WraithonAnimations;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.IWraithonAnimation;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class WraithonActionAnimation
extends ActionAnimation
implements IWraithonAnimation {
    public WraithonActionAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.REMOVE_DELTA_MOVEMENT, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.MOVE_VERTICAL, false);
    }

    public WraithonActionAnimation(float transitionTime, float postDelay, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.REMOVE_DELTA_MOVEMENT, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.MOVE_VERTICAL, false);
    }

    public void begin(LivingEntityPatch<?> entityPatch) {
        WraithonEntityPatch wraithonEntityPatch;
        super.begin(entityPatch);
        if (entityPatch instanceof WraithonEntityPatch && !((DynamicAnimation)(wraithonEntityPatch = (WraithonEntityPatch)entityPatch).getAnimator().getPlayerFor(null).getAnimation().get()).isLinkAnimation()) {
            ((WraithonEntity)wraithonEntityPatch.getOriginal()).updateYRotBeforeRotation();
        }
    }

    public void end(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        WraithonEntityPatch wraithonEntityPatch;
        super.end(entityPatch, nextAnimation, isEnd);
        if (entityPatch instanceof WraithonEntityPatch && !((DynamicAnimation)(wraithonEntityPatch = (WraithonEntityPatch)entityPatch).getAnimator().getPlayerFor(null).getAnimation().get()).isLinkAnimation()) {
            ((WraithonEntity)wraithonEntityPatch.getOriginal()).setRotating(false);
        }
        if (!entityPatch.isLogicalClient()) {
            entityPatch.reserveAnimation(WraithonAnimations.WRAITHON_IDLE);
        }
    }

    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        if (entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor()).isEnd()) {
            JointTransform jt = pose.orElseEmpty("Root");
            jt.rotation().set(0.0f, 0.0f, 0.0f, 1.0f);
        }
        super.modifyPose(animation, pose, entitypatch, time, partialTicks);
    }

    protected void move(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> animation) {
        if (this.validateMovement(entityPatch, animation) && ((Boolean)this.getState(EntityState.INACTION, entityPatch, entityPatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor()).getElapsedTime())).booleanValue()) {
            LivingEntity livingentity = (LivingEntity)entityPatch.getOriginal();
            Vec3 vec3o = this.getCoordVector(entityPatch, animation);
            Vec3 vec3 = vec3o.m_82490_(1.0);
            livingentity.m_6478_(MoverType.SELF, vec3);
        }
    }

    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, float playbackTime, float partialTicks) {
        AnimationPlayer animPlayer = entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.accessor);
        float prevElapsedTime = animPlayer.getPrevElapsedTime();
        float elapsedTime = animPlayer.getElapsedTime();
        if (entitypatch instanceof WraithonEntityPatch) {
            WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entitypatch;
            for (WraithonPartEntity part : ((WraithonEntity)wraithonEntityPatch.getOriginal()).getSubEntities()) {
                for (Joint joint : part.entityOBBColliderMap.keySet()) {
                    EntityOBBCollider collider = part.entityOBBColliderMap.get(joint);
                    collider.draw(poseStack, buffer, entitypatch, (StaticAnimation)this, joint, prevElapsedTime, elapsedTime, partialTicks, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
                }
            }
        }
    }
}

