/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.entity.wraithon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.merlin204.wraithon.WraithonConfig;
import org.merlin204.wraithon.entity.wraithon.WraithonArmature;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.WraithonEntityPatch;
import org.merlin204.wraithon.entity.wraithon.client.EmptyEntityModel;
import org.merlin204.wraithon.entity.wraithon.client.WraithonMesh;
import org.merlin204.wraithon.entity.wraithon.client.WraithonPartMesh;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedWraithonRenderer
extends PatchedLivingEntityRenderer<WraithonEntity, WraithonEntityPatch, EmptyEntityModel<WraithonEntity>, LivingEntityRenderer<WraithonEntity, EmptyEntityModel<WraithonEntity>>, WraithonMesh> {
    public static final Meshes.MeshAccessor<WraithonMesh> MAIN = Meshes.MeshAccessor.create((String)"wraithon", (String)"entity/wraithon/wraithon_main", jsonModelLoader -> (WraithonMesh)jsonModelLoader.loadSkinnedMesh(WraithonMesh::new));
    public static final Meshes.MeshAccessor<WraithonMesh> SLIME = Meshes.MeshAccessor.create((String)"wraithon", (String)"entity/wraithon/wraithon_slime", jsonModelLoader -> (WraithonMesh)jsonModelLoader.loadSkinnedMesh(WraithonMesh::new));
    public static final ResourceLocation MAIN_TEX = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_main.png");
    public static final ResourceLocation SLIME_TEX = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_slime.png");
    public static final ResourceLocation SWORD_TEX = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_sword.png");
    public static final ResourceLocation SPEAR_TEX = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_spear.png");
    public static final List<ResourceLocation> LIGHT_TEXTURES = List.of(ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_0.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_1.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_2.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_3.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_4.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_5.png"));

    public void render(WraithonEntity entity, WraithonEntityPatch entityPatch, LivingEntityRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Armature armature = WraithonArmature.WRAITHON_ARMATURE.get();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, (LivingEntity)entity, (LivingEntityPatch)entityPatch, partialTicks);
        this.setArmaturePose((LivingEntityPatch)entityPatch, armature, partialTicks);
        ResourceLocation lightTex = LIGHT_TEXTURES.get(entity.getState());
        ((WraithonMesh)MAIN.get()).draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)MAIN_TEX), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
        if (((Boolean)WraithonConfig.ARACHNOPHOBIA_MODE.get()).booleanValue()) {
            ((WraithonMesh)SLIME.get()).draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)SLIME_TEX), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
        }
        PatchedWraithonRenderer.draw(entityPatch.SWORD_L, entityPatch, armature, buffer, poseStack, packedLight, partialTicks);
        PatchedWraithonRenderer.draw(entityPatch.SWORD_R, entityPatch, armature, buffer, poseStack, packedLight, partialTicks);
        PatchedWraithonRenderer.draw(entityPatch.FLY_SWORD_L, entityPatch, armature, buffer, poseStack, packedLight, partialTicks);
        PatchedWraithonRenderer.draw(entityPatch.FLY_SWORD_R, entityPatch, armature, buffer, poseStack, packedLight, partialTicks);
        PatchedWraithonRenderer.draw(entityPatch.SPEAR, entityPatch, armature, buffer, poseStack, packedLight, partialTicks);
        PatchedWraithonRenderer.drawWithLight(entityPatch.LEG_F_L, entityPatch, armature, buffer, poseStack, packedLight, lightTex, partialTicks);
        PatchedWraithonRenderer.drawWithLight(entityPatch.LEG_F_R, entityPatch, armature, buffer, poseStack, packedLight, lightTex, partialTicks);
        PatchedWraithonRenderer.drawWithLight(entityPatch.LEG_M_L, entityPatch, armature, buffer, poseStack, packedLight, lightTex, partialTicks);
        PatchedWraithonRenderer.drawWithLight(entityPatch.LEG_M_R, entityPatch, armature, buffer, poseStack, packedLight, lightTex, partialTicks);
        PatchedWraithonRenderer.drawWithLight(entityPatch.LEG_B_L, entityPatch, armature, buffer, poseStack, packedLight, lightTex, partialTicks);
        PatchedWraithonRenderer.drawWithLight(entityPatch.LEG_B_R, entityPatch, armature, buffer, poseStack, packedLight, lightTex, partialTicks);
        ((WraithonMesh)MAIN.get()).draw(poseStack, buffer, RenderType.m_234338_((ResourceLocation)lightTex), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
        this.renderLayer(renderer, (LivingEntityPatch)entityPatch, (LivingEntity)entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            entityPatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.m_85849_();
    }

    public PatchedWraithonRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
    }

    public AssetAccessor<WraithonMesh> getDefaultMesh() {
        return MAIN;
    }

    public static void draw(WraithonPartMesh wraithonPartMesh, WraithonEntityPatch entityPatch, Armature armature, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        int drawTick = wraithonPartMesh.drawTick;
        boolean shouldDraw = wraithonPartMesh.shouldDraw();
        String hidePath = wraithonPartMesh.hidePath;
        ResourceLocation tex = wraithonPartMesh.tex;
        int number = (int)(Math.min((float)drawTick + partialTicks, 20.0f) / 20.0f * 60.0f);
        Meshes.MeshAccessor MESH = Meshes.MeshAccessor.create((String)"wraithon", (String)wraithonPartMesh.mesh, jsonModelLoader -> (WraithonMesh)jsonModelLoader.loadSkinnedMesh(WraithonMesh::new));
        if (shouldDraw) {
            if (number != 60 && number != 0) {
                ResourceLocation hideTex = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)(hidePath + "/" + number + ".png"));
                ((WraithonMesh)MESH.get()).draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)hideTex), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
            } else {
                ((WraithonMesh)MESH.get()).draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)tex), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
            }
        } else if (number != 0) {
            ResourceLocation hideTex = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)(hidePath + "/" + number + ".png"));
            ((WraithonMesh)MESH.get()).draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)hideTex), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
        }
    }

    public static void drawWithLight(WraithonPartMesh wraithonPartMesh, WraithonEntityPatch entityPatch, Armature armature, MultiBufferSource buffer, PoseStack poseStack, int packedLight, ResourceLocation light, float partialTicks) {
        int drawTick = wraithonPartMesh.drawTick;
        boolean shouldDraw = wraithonPartMesh.shouldDraw();
        String hidePath = wraithonPartMesh.hidePath;
        ResourceLocation tex = wraithonPartMesh.tex;
        int number = (int)(Math.min((float)drawTick + partialTicks, 20.0f) / 20.0f * 60.0f);
        Meshes.MeshAccessor MESH = Meshes.MeshAccessor.create((String)"wraithon", (String)wraithonPartMesh.mesh, jsonModelLoader -> (WraithonMesh)jsonModelLoader.loadSkinnedMesh(WraithonMesh::new));
        if (shouldDraw) {
            if (number != 60 && number != 0) {
                ResourceLocation hideTex = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)(hidePath + "/" + number + ".png"));
                ((WraithonMesh)MESH.get()).draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)hideTex), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
            } else {
                ((WraithonMesh)MESH.get()).draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)tex), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
                ((WraithonMesh)MESH.get()).draw(poseStack, buffer, RenderType.m_234338_((ResourceLocation)light), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
            }
        } else if (number != 0) {
            ResourceLocation hideTex = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)(hidePath + "/" + number + ".png"));
            ((WraithonMesh)MESH.get()).draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)hideTex), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
        }
    }
}

