/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.entity.wraithon.ai;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class WraithonAtkPredictCondition<T extends LivingEntityPatch<?>>
implements Condition<T> {
    private final AnimationManager.AnimationAccessor<? extends AttackAnimation> animationAccessor;
    private final int interpolation;

    public WraithonAtkPredictCondition(AnimationManager.AnimationAccessor<? extends AttackAnimation> animationAccessor, int interpolation) {
        this.animationAccessor = animationAccessor;
        this.interpolation = interpolation;
    }

    public boolean predicate(T livingEntityPatch) {
        AttackAnimation animation = (AttackAnimation)this.animationAccessor.get();
        for (AttackAnimation.Phase phase : animation.phases) {
            float atkTime = phase.contact - phase.preDelay;
            float timeStep = atkTime / (float)this.interpolation;
            for (int i = 0; i < this.interpolation; ++i) {
                float start = phase.preDelay + (float)i * timeStep;
                float end = phase.preDelay + (float)(i + 1) * timeStep;
                List list = phase.getCollidingEntities(livingEntityPatch, animation, start, end, animation.getPlaySpeed(livingEntityPatch, (DynamicAnimation)animation));
                for (Entity entity : list) {
                    Player player;
                    if (entity == livingEntityPatch.getTarget()) {
                        return true;
                    }
                    if (!(entity instanceof Player) || (player = (Player)entity).m_7500_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Condition<T> read(CompoundTag compoundTag) throws IllegalArgumentException {
        return null;
    }

    public CompoundTag serializePredicate() {
        return null;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

