/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.entity.wraithon;

import com.merlin204.avalon.util.AvalonParticleUtils;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.merlin204.wraithon.WraithonMod;
import org.merlin204.wraithon.avalon.WraithonVFXManagers;
import org.merlin204.wraithon.entity.wraithon.EntityOBBCollider;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.WraithonEntityPatch;
import org.merlin204.wraithon.entity.wraithon.client.WraithonPartMesh;
import org.merlin204.wraithon.network.PacketHandler;
import org.merlin204.wraithon.network.PacketRelay;
import org.merlin204.wraithon.network.packet.SyncPartEntityBrokenPacket;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class WraithonPartEntity
extends PartEntity<WraithonEntity> {
    public final WraithonEntity parentMob;
    public final Joint joint;
    private final EntityDimensions size;
    private final Vec3 offset;
    private final int RECOVER_TIME;
    private int recoverTimer;
    private float damageReduce;
    private float maxDamageTaken;
    private float currentTakenDamage;
    protected static final EntityDataAccessor<Boolean> BROKEN = SynchedEntityData.m_135353_(WraithonPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    private WraithonPartMesh wraithonPartMesh;
    public HashMap<Joint, EntityOBBCollider> entityOBBColliderMap;

    public WraithonPartEntity(WraithonEntity pParentMob, Joint joint, float pWidth, float pHeight, Vec3 offset, float damageReduce, float maxDamageTaken, HashMap<Joint, EntityOBBCollider> OBBMap) {
        super((Entity)pParentMob);
        this.size = EntityDimensions.m_20395_((float)pWidth, (float)pHeight);
        this.m_6210_();
        this.parentMob = pParentMob;
        this.joint = joint;
        this.offset = offset;
        this.damageReduce = damageReduce;
        this.maxDamageTaken = maxDamageTaken;
        this.RECOVER_TIME = 300;
        this.entityOBBColliderMap = OBBMap;
    }

    public void SyncEntityJointOBBCollider(WraithonEntityPatch parentEntityPatch) {
        AnimationPlayer player = parentEntityPatch.getAnimator().getPlayerFor(null);
        DynamicAnimation nowAnimation = (DynamicAnimation)player.getAnimation().get();
        float prevElapsedTime = player.getPrevElapsedTime();
        float ElapsedTime = player.getElapsedTime();
        float playSpeed = nowAnimation.getPlaySpeed((LivingEntityPatch)parentEntityPatch, nowAnimation);
        for (Joint joint : this.entityOBBColliderMap.keySet()) {
            this.entityOBBColliderMap.get(joint).updateOBBCollider((LivingEntityPatch<?>)parentEntityPatch, nowAnimation, prevElapsedTime, ElapsedTime, joint, playSpeed);
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(BROKEN, (Object)false);
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        this.setBroken(pCompound.m_128471_("broken"));
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        pCompound.m_128379_("broken", this.isBroken());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setWraithonPartMesh(@Nullable WraithonPartMesh wraithonPartMesh) {
        this.wraithonPartMesh = wraithonPartMesh;
    }

    public void addDamageTaken(float damageIn) {
        this.currentTakenDamage += damageIn;
        if (this.currentTakenDamage > this.maxDamageTaken) {
            this.setBroken(true);
            this.currentTakenDamage = 0.0f;
        }
    }

    public void setRecoverTimer(int recoverTimer) {
        this.recoverTimer = recoverTimer;
    }

    public void setBroken(boolean isBroken) {
        this.m_20088_().m_135381_(BROKEN, (Object)isBroken);
        if (!this.m_9236_().f_46443_) {
            if (isBroken) {
                WraithonMod.LOGGER.debug("\u90e8\u4f4d\u7834\u574f\uff1a{}", (Object)this.joint.getName());
            }
            SyncPartEntityBrokenPacket packet = new SyncPartEntityBrokenPacket(this.parentMob.m_19879_(), this.joint.getId(), isBroken);
            PacketRelay.sendToAll(PacketHandler.INSTANCE, packet);
        } else if (isBroken) {
            AvalonParticleUtils.createSphereParticles((Level)this.m_9236_(), (Vec3)this.m_20182_(), (ParticleOptions)this.parentMob.getStateParticleTypes(), (double)2.0, (double)1.0, (double)1.5, (int)30);
        }
    }

    public boolean isBroken() {
        return (Boolean)this.m_20088_().m_135370_(BROKEN);
    }

    public void m_8119_() {
        WraithonEntityPatch parentEntityPatch;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isBroken() && this.recoverTimer < this.RECOVER_TIME) {
                ++this.recoverTimer;
                if (this.recoverTimer > this.RECOVER_TIME) {
                    this.setBroken(false);
                    this.recoverTimer = 0;
                }
            }
        } else if (this.wraithonPartMesh != null) {
            boolean isBroken = this.isBroken();
            this.wraithonPartMesh.setShouldDraw(!isBroken);
        }
        if ((parentEntityPatch = (WraithonEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.parentMob, WraithonEntityPatch.class)).isLogicalClient() && Minecraft.m_91087_().m_91290_().m_114377_() && !FMLEnvironment.production) {
            this.SyncEntityJointOBBCollider(parentEntityPatch);
        }
    }

    public void setDamageReduce(float damageReduce) {
        this.damageReduce = damageReduce;
    }

    public float getDamageReduce() {
        return this.damageReduce / (float)(this.parentMob.getPhase() + 1);
    }

    public void setMaxDamageTaken(float maxDamageTaken) {
        this.maxDamageTaken = maxDamageTaken;
    }

    public float getMaxDamageTaken() {
        return this.maxDamageTaken;
    }

    public Vec3 getYOffset() {
        return this.offset;
    }

    public EntityDimensions getSize() {
        return this.size;
    }

    public boolean isLeg() {
        return this.joint.getName().contains("leg");
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.parentMob.m_142340_();
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() != null && (double)pSource.m_7639_().m_20270_((Entity)this.parentMob) >= this.parentMob.m_21172_(Attributes.f_22277_)) {
            return false;
        }
        if (pSource.m_7639_() == this.parentMob) {
            return false;
        }
        if (this.parentMob.isAnyDamageTypeInRange(pSource, pAmount)) {
            return true;
        }
        if (!this.isBroken()) {
            pAmount *= this.getDamageReduce();
        }
        this.addDamageTaken(pAmount);
        MobEffectInstance currentDamageResistance = this.parentMob.m_21124_(MobEffects.f_19606_);
        if (currentDamageResistance != null) {
            if (currentDamageResistance.m_19564_() == 4) {
                LivingEntity livingEntity;
                this.parentMob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 30, 0, false, false, false));
                Entity entity = pSource.m_7639_();
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_20096_()) {
                    WraithonVFXManagers.SWORD_1.spawnVFXEntity((LivingEntity)this.parentMob, livingEntity.m_20318_(0.0f), Vec3f.ZERO, 1.0f);
                }
            } else {
                this.parentMob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 30, currentDamageResistance.m_19564_() + 1, false, false, false));
            }
        } else {
            this.parentMob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 30, 0, false, false, false));
        }
        return this.parentMob.m_6469_(pSource, pAmount);
    }

    public boolean m_7306_(@NotNull Entity pEntity) {
        return this == pEntity || this.parentMob == pEntity;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return this.size;
    }

    public boolean m_142391_() {
        return false;
    }
}

