/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.entity.wraithon;

import com.merlin204.avalon.entity.ai.AvalonCombatBehaviors;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.joml.Vector3f;
import org.merlin204.wraithon.client.sound.WraithonSounds;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.WraithonPartEntity;
import org.merlin204.wraithon.entity.wraithon.ai.WraithonAttackGoal;
import org.merlin204.wraithon.entity.wraithon.ai.WraithonChaseGoal;
import org.merlin204.wraithon.entity.wraithon.ai.WraithonCombatBehaviors;
import org.merlin204.wraithon.entity.wraithon.client.WraithonPartMesh;
import org.merlin204.wraithon.epicfight.animation.WraithonAnimations;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.IWraithonAnimation;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.WraithonActionAnimation;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.WraithonAttackAnimation;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;

public class WraithonEntityPatch
extends MobPatch<WraithonEntity> {
    public static final float SCALE = 1.0f;
    public final List<AnimationManager.AnimationAccessor<WraithonActionAnimation>> leftRotAnimations = List.of(WraithonAnimations.WRAITHON_ROTATE_L_40, WraithonAnimations.WRAITHON_ROTATE_L_60, WraithonAnimations.WRAITHON_ROTATE_L_80, WraithonAnimations.WRAITHON_ROTATE_L_100, WraithonAnimations.WRAITHON_ROTATE_L_120, WraithonAnimations.WRAITHON_ROTATE_L_140, WraithonAnimations.WRAITHON_ROTATE_L_160, WraithonAnimations.WRAITHON_ROTATE_L_180);
    public final List<AnimationManager.AnimationAccessor<WraithonActionAnimation>> rightRotAnimations = List.of(WraithonAnimations.WRAITHON_ROTATE_R_40, WraithonAnimations.WRAITHON_ROTATE_R_60, WraithonAnimations.WRAITHON_ROTATE_R_80, WraithonAnimations.WRAITHON_ROTATE_R_100, WraithonAnimations.WRAITHON_ROTATE_R_120, WraithonAnimations.WRAITHON_ROTATE_R_140, WraithonAnimations.WRAITHON_ROTATE_R_160, WraithonAnimations.WRAITHON_ROTATE_R_180);
    public static final ResourceLocation MAIN_TEX = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_main.png");
    public static final ResourceLocation SLIME_TEX = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_slime.png");
    public static final ResourceLocation SWORD_TEX = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_sword.png");
    public static final ResourceLocation SPEAR_TEX = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/entity/wraithon/wraithon_spear.png");
    public WraithonPartMesh SWORD_L = new WraithonPartMesh("entity/wraithon/wraithon_sword_l", SWORD_TEX, "textures/entity/wraithon/hide/sword");
    public WraithonPartMesh SWORD_R = new WraithonPartMesh("entity/wraithon/wraithon_sword_r", SWORD_TEX, "textures/entity/wraithon/hide/sword");
    public WraithonPartMesh FLY_SWORD_L = new WraithonPartMesh("entity/wraithon/wraithon_fly_sword_l", SWORD_TEX, "textures/entity/wraithon/hide/sword");
    public WraithonPartMesh FLY_SWORD_R = new WraithonPartMesh("entity/wraithon/wraithon_fly_sword_r", SWORD_TEX, "textures/entity/wraithon/hide/sword");
    public WraithonPartMesh SPEAR = new WraithonPartMesh("entity/wraithon/wraithon_spear", SPEAR_TEX, "textures/entity/wraithon/hide/spear");
    public WraithonPartMesh LEG_F_R = new WraithonPartMesh("entity/wraithon/wraithon_leg_f_r", MAIN_TEX, "textures/entity/wraithon/hide/main");
    public WraithonPartMesh LEG_F_L = new WraithonPartMesh("entity/wraithon/wraithon_leg_f_l", MAIN_TEX, "textures/entity/wraithon/hide/main");
    public WraithonPartMesh LEG_B_R = new WraithonPartMesh("entity/wraithon/wraithon_leg_b_r", MAIN_TEX, "textures/entity/wraithon/hide/main");
    public WraithonPartMesh LEG_B_L = new WraithonPartMesh("entity/wraithon/wraithon_leg_b_l", MAIN_TEX, "textures/entity/wraithon/hide/main");
    public final WraithonPartMesh LEG_M_R = new WraithonPartMesh("entity/wraithon/wraithon_leg_m_r", MAIN_TEX, "textures/entity/wraithon/hide/main");
    public final WraithonPartMesh LEG_M_L = new WraithonPartMesh("entity/wraithon/wraithon_leg_m_l", MAIN_TEX, "textures/entity/wraithon/hide/main");
    public final List<WraithonPartMesh> partMeshes = List.of(this.SWORD_L, this.SWORD_R, this.FLY_SWORD_L, this.FLY_SWORD_R, this.SPEAR, this.LEG_F_R, this.LEG_F_L, this.LEG_B_R, this.LEG_B_L, this.LEG_M_R, this.LEG_M_L);

    protected void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, WraithonAnimations.WRAITHON_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, WraithonAnimations.WRAITHON_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, WraithonAnimations.WRAITHON_DEATH);
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
    }

    protected void initAI() {
        super.initAI();
        ((WraithonEntity)this.original).f_21345_.m_25352_(0, (Goal)new WraithonAttackGoal(this, (AvalonCombatBehaviors<WraithonEntityPatch>)WraithonCombatBehaviors.PHASE1.build((MobPatch)this)));
        ((WraithonEntity)this.original).f_21345_.m_25352_(1, (Goal)new WraithonChaseGoal(this, 5.0f));
    }

    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((WraithonEntity)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((WraithonEntity)this.original).m_20202_() != null ? LivingMotions.MOUNT : (!(((WraithonEntity)this.original).m_20184_().f_82480_ < (double)-0.55f) && !this.isAirborneState() ? ((double)((WraithonEntity)this.original).f_267362_.m_267731_() > 0.4 ? (((WraithonEntity)this.original).m_5912_() ? LivingMotions.CHASE : LivingMotions.WALK) : LivingMotions.IDLE) : LivingMotions.FALL)));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (((WraithonEntity)this.original).m_9236_().f_46443_) {
            for (WraithonPartMesh wraithonPartMesh : this.partMeshes) {
                wraithonPartMesh.tick();
            }
        }
        this.correctYRot(this.getAnimator().getPose(1.0f));
        this.syncPartEntities();
    }

    public void correctYRot(Pose pose) {
        DynamicAnimation animation = (DynamicAnimation)this.getAnimator().getPlayerFor(null).getAnimation().get();
        if (animation instanceof WraithonActionAnimation || animation instanceof WraithonAttackAnimation) {
            JointTransform transform;
            Vector3f euler = new Vector3f();
            if (animation instanceof LinkAnimation) {
                LinkAnimation linkAnimation = (LinkAnimation)animation;
                DynamicAnimation fromAnim = (DynamicAnimation)linkAnimation.getFromAnimation().get();
                if (!(fromAnim instanceof ActionAnimation)) {
                    return;
                }
                transform = fromAnim.getPoseByTime((LivingEntityPatch)this, fromAnim.getTotalTime(), 1.0f).get("Root");
            } else {
                transform = pose.get("Root");
            }
            if (transform != null) {
                float yaw = (float)WraithonEntityPatch.calculateRotationAngle(transform);
                float yModelRot = ((WraithonEntity)this.getOriginal()).getCorrectYRot(1.0f) + yaw;
                this.setYRot(yModelRot);
                this.setYRotO(yModelRot);
                ((WraithonEntity)this.getOriginal()).m_146922_(yModelRot);
                ((WraithonEntity)this.getOriginal()).m_5618_(yModelRot);
                ((WraithonEntity)this.getOriginal()).m_5616_(yModelRot);
                ((WraithonEntity)this.getOriginal()).f_19859_ = yModelRot;
                ((WraithonEntity)this.getOriginal()).f_20884_ = yModelRot;
                ((WraithonEntity)this.getOriginal()).f_20886_ = yModelRot;
            }
        }
    }

    public static double calculateRotationAngle(JointTransform jointTransform) {
        double w = jointTransform.rotation().w;
        double x = jointTransform.rotation().x;
        double y = jointTransform.rotation().y;
        double z = jointTransform.rotation().z;
        double safeW = Math.max(-1.0, Math.min(1.0, w));
        double angleRad = 2.0 * Math.acos(safeW);
        if (y < 0.0) {
            angleRad = -angleRad;
        }
        double angleDeg = Math.toDegrees(angleRad);
        if ((angleDeg %= 360.0) < -180.0) {
            angleDeg += 360.0;
        } else if (angleDeg >= 180.0) {
            angleDeg -= 360.0;
        }
        return angleDeg;
    }

    public void syncPartEntities() {
        for (WraithonPartEntity part : ((WraithonEntity)this.getOriginal()).getWraithonParts()) {
            if (part == null) continue;
            Vec3 newPos = AvalonAnimationUtils.getJointWorldPos((LivingEntityPatch)this, (Joint)part.joint);
            part.m_20219_(newPos.m_82549_(part.getYOffset()));
        }
    }

    public boolean isTargetInDegree(Entity target) {
        return this.isTargetInDegree(target, -10.0f, 10.0f);
    }

    public boolean isTargetInDegree(Entity target, float min, float max) {
        Vec3 selfPos;
        Vec3 targetPos = target.m_20182_();
        double theta = MathUtils.getYRotOfVector((Vec3)targetPos.m_82546_(selfPos = ((WraithonEntity)this.getOriginal()).m_20182_()));
        double delta = theta - MathUtils.getYRotOfVector((Vec3)((WraithonEntity)this.getOriginal()).m_20252_(1.0f));
        return delta > (double)min && delta < (double)max;
    }

    public void turnRight() {
        Vec3 selfPos;
        Vec3 targetPos = this.getTarget().m_20182_();
        double theta = MathUtils.getYRotOfVector((Vec3)targetPos.m_82546_(selfPos = ((WraithonEntity)this.getOriginal()).m_20182_()));
        double delta = theta - MathUtils.getYRotOfVector((Vec3)((WraithonEntity)this.getOriginal()).m_20252_(1.0f));
        if (delta > 30.0 && delta < 180.0) {
            this.turnRight(delta);
        }
    }

    public void turnLeft() {
        Vec3 selfPos;
        Vec3 targetPos = this.getTarget().m_20182_();
        double theta = MathUtils.getYRotOfVector((Vec3)targetPos.m_82546_(selfPos = ((WraithonEntity)this.getOriginal()).m_20182_()));
        double delta = theta - MathUtils.getYRotOfVector((Vec3)((WraithonEntity)this.getOriginal()).m_20252_(1.0f));
        if (delta < -30.0 && delta > -180.0) {
            this.turnLeft(-delta);
        }
    }

    public void turnRight(double degree) {
        if (degree < 30.0) {
            return;
        }
        ((WraithonEntity)this.getOriginal()).setRotating(true);
        int[] angles = new int[]{40, 60, 80, 100, 120, 140, 160, 180};
        int[] breakpoints = new int[angles.length - 1];
        for (int i = 0; i < breakpoints.length; ++i) {
            breakpoints[i] = (angles[i] + angles[i + 1]) / 2;
        }
        int roundedDegree = (int)Math.round(degree);
        int index = Arrays.binarySearch(breakpoints, roundedDegree);
        int insertionPoint = index >= 0 ? index + 1 : -(index + 1);
        this.playAnimationSynchronized((AssetAccessor<? extends StaticAnimation>)((AssetAccessor)this.rightRotAnimations.get(insertionPoint)), 0.15f);
    }

    public void turnLeft(double degree) {
        if (degree < 30.0) {
            return;
        }
        ((WraithonEntity)this.getOriginal()).setRotating(true);
        int[] angles = new int[]{40, 60, 80, 100, 120, 140, 160, 180};
        int[] breakpoints = new int[angles.length - 1];
        for (int i = 0; i < breakpoints.length; ++i) {
            breakpoints[i] = (angles[i] + angles[i + 1]) / 2;
        }
        int roundedDegree = (int)Math.round(degree);
        int index = Arrays.binarySearch(breakpoints, roundedDegree);
        int insertionPoint = index >= 0 ? index + 1 : -(index + 1);
        this.playAnimationSynchronized((AssetAccessor<? extends StaticAnimation>)((AssetAccessor)this.leftRotAnimations.get(insertionPoint)), 0.15f);
    }

    public boolean isRotating() {
        return ((WraithonEntity)this.getOriginal()).isRotating();
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        if (super.attack((EpicFightDamageSource)damageSource, (Entity)target, (InteractionHand)hand).resultType.dealtDamage()) {
            if (((WraithonEntity)this.getOriginal()).fireContainer.isFullState()) {
                super.attack(EpicFightDamageSources.fromVanillaDamageSource((DamageSource)((WraithonEntity)this.getOriginal()).m_269291_().m_269387_()), target, hand);
            } else if (((WraithonEntity)this.getOriginal()).witherContainer.isFullState()) {
                super.attack(EpicFightDamageSources.fromVanillaDamageSource((DamageSource)((WraithonEntity)this.getOriginal()).m_269291_().m_269251_()), target, hand);
            } else if (((WraithonEntity)this.getOriginal()).magicContainer.isFullState()) {
                super.attack(EpicFightDamageSources.fromVanillaDamageSource((DamageSource)((WraithonEntity)this.getOriginal()).m_269291_().m_269104_(this.getOriginal(), this.getOriginal())), target, hand);
            } else if (((WraithonEntity)this.getOriginal()).projectileContainer.isFullState()) {
                super.attack(EpicFightDamageSources.fromVanillaDamageSource((DamageSource)((WraithonEntity)this.getOriginal()).m_269291_().m_269299_(this.getOriginal(), (LivingEntity)this.getOriginal())), target, hand);
            } else if (((WraithonEntity)this.getOriginal()).outsideContainer.isFullState()) {
                super.attack(EpicFightDamageSources.fromVanillaDamageSource((DamageSource)((WraithonEntity)this.getOriginal()).m_269291_().m_287287_()), target, hand);
            }
        }
        return super.attack(damageSource, target, hand);
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return MathUtils.getModelMatrixIntegral((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((WraithonEntity)this.original).f_19860_, (float)((WraithonEntity)this.original).m_146909_(), (float)((WraithonEntity)this.getOriginal()).getCorrectYRot(partialTicks), (float)((WraithonEntity)this.getOriginal()).getCorrectYRot(partialTicks), (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f).scale(1.0f, 1.0f, 1.0f);
    }

    public void playAnimationSynchronized(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        if (animation.get() instanceof IWraithonAnimation) {
            super.playAnimationSynchronized(animation, transitionTimeModifier);
        }
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.BLADE_HIT.get();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        return (SoundEvent)WraithonSounds.VATANSEVER_WHOOSH_BIG.get();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return (HitParticleType)EpicFightParticles.HIT_BLADE.get();
    }

    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }
}

