/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.entity.wraithon;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlin204.wraithon.client.gui.WraithonBossBarRenderer;
import org.merlin204.wraithon.entity.WraithonEntities;
import org.merlin204.wraithon.entity.wraithon.EntityOBBCollider;
import org.merlin204.wraithon.entity.wraithon.WraithonArmature;
import org.merlin204.wraithon.entity.wraithon.WraithonEntityPatch;
import org.merlin204.wraithon.entity.wraithon.WraithonPartEntity;
import org.merlin204.wraithon.entity.wraithon.ai.WraithonTargetSelector;
import org.merlin204.wraithon.entity.wraithon.container.DamageContainer;
import org.merlin204.wraithon.epicfight.animation.WraithonAnimations;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.WraithonActionAnimation;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.WraithonAttackAnimation;
import org.merlin204.wraithon.network.PacketHandler;
import org.merlin204.wraithon.network.PacketRelay;
import org.merlin204.wraithon.network.packet.client.SyncBossBarPacket;
import org.merlin204.wraithon.worldgen.WraithonDimensions;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSetAttackTarget;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class WraithonEntity
extends PathfinderMob {
    private static final String NBT_Y_ROT = "YRotBeforeRotation";
    private static final String NBT_ROTATING = "Rotating";
    private static final String NBT_PHASE = "Phase";
    private static final String NBT_STATE = "State";
    private static final String NBT_FIRE = "FireContainer";
    private static final String NBT_WITHER = "WitherContainer";
    private static final String NBT_MAGIC = "MagicContainer";
    private static final String NBT_BORDER = "OutsideBorderContainer";
    private static final String NBT_PROJECTILE = "ProjectileContainer";
    private static final String NBT_KNOCKDOWN = "InKnockdown";
    public static final int START_PHASE = 0;
    public static final int MIDDLE_PHASE = 1;
    public static final int FINAL_PHASE = 2;
    public static final int DEFAULT_STATE = 0;
    public static final int FIRE_STATE = 1;
    public static final int WITHER_STATE = 2;
    public static final int MAGIC_STATE = 3;
    public static final int OUTSIDE_STATE = 4;
    public static final int PROJECTILE_STATE = 5;
    protected static EntityDataAccessor<Float> Y_ROT_BEFORE_ROTATION = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> FIRE_CONTAINER = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> WITHER_CONTAINER = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> MAGIC_CONTAINER = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> OUTSIDE_BORDER_CONTAINER = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> PROJECTILE_CONTAINER = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> HEALTH_OLD = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> ROTATING = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IN_KNOCKDOWN = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> TEMP_BROKEN = SynchedEntityData.m_135353_(WraithonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final WraithonPartEntity[] subEntities;
    private final List<WraithonPartEntity> legs;
    protected final WraithonPartEntity head;
    protected final WraithonPartEntity chest;
    protected final WraithonPartEntity tail;
    protected final WraithonPartEntity leg_F_3_R;
    protected final WraithonPartEntity leg_M_3_R;
    protected final WraithonPartEntity leg_B_3_R;
    protected final WraithonPartEntity leg_F_3_L;
    protected final WraithonPartEntity leg_M_3_L;
    protected final WraithonPartEntity leg_B_3_L;
    public HashMap<Joint, EntityOBBCollider> PartHeadOBBMap = new HashMap();
    public HashMap<Joint, EntityOBBCollider> PartChestOBBMap = new HashMap();
    public HashMap<Joint, EntityOBBCollider> PartTailOBBMap = new HashMap();
    public HashMap<Joint, EntityOBBCollider> PartLegFROBBMap = new HashMap();
    public HashMap<Joint, EntityOBBCollider> PartLegMROBBMap = new HashMap();
    public HashMap<Joint, EntityOBBCollider> PartLegBROBBMap = new HashMap();
    public HashMap<Joint, EntityOBBCollider> PartLegFLOBBMap = new HashMap();
    public HashMap<Joint, EntityOBBCollider> PartLegMLOBBMap = new HashMap();
    public HashMap<Joint, EntityOBBCollider> PartLegBLOBBMap = new HashMap();
    public final List<DamageContainer> damageContainers;
    public final DamageContainer fireContainer;
    public final DamageContainer witherContainer;
    public final DamageContainer magicContainer;
    public final DamageContainer outsideContainer;
    public final DamageContainer projectileContainer;
    protected final ServerBossEvent bossInfo;

    public WraithonEntity(EntityType<? extends WraithonEntity> pEntityType, Level pLevel) {
        super((EntityType)WraithonEntities.WRAITHON.get(), pLevel);
        WraithonArmature armature = (WraithonArmature)WraithonArmature.WRAITHON_ARMATURE.get();
        this.PartHeadOBBMap.put(armature.head, new EntityOBBCollider(0.5, 1.5, 0.5, 0.0, 0.0, 0.0));
        this.head = new WraithonPartEntity(this, armature.head, 1.5f, 1.5f, new Vec3(0.0, -0.5, 1.0), 0.5f, 9999999.0f, this.PartHeadOBBMap);
        this.PartChestOBBMap.put(armature.chest, new EntityOBBCollider(1.5, 3.0, 2.0, 0.0, -3.0, -1.0));
        this.chest = new WraithonPartEntity(this, armature.chest, 3.0f, 7.0f, new Vec3(0.0, -4.0, 0.0), 0.6f, 9999999.0f, this.PartChestOBBMap);
        this.PartTailOBBMap.put(armature.tail, new EntityOBBCollider(1.5, 4.0, 1.5, 0.0, 1.0, -0.6));
        this.tail = new WraithonPartEntity(this, armature.tail, 6.0f, 5.0f, new Vec3(0.0, -1.5, 0.0), 0.9f, 9999999.0f, this.PartTailOBBMap);
        this.PartLegFROBBMap.put(armature.leg_F_1_R, new EntityOBBCollider(0.6, 2.5, 0.6, 0.0, 1.0, 0.0));
        this.PartLegFROBBMap.put(armature.leg_F_3_R, new EntityOBBCollider(1.0, 3.0, 1.0, 0.0, 0.0, 0.5));
        this.leg_F_3_R = new WraithonPartEntity(this, armature.leg_F_3_R, 2.0f, 5.0f, new Vec3(0.0, -3.0, 0.0), 0.7f, 100.0f, this.PartLegFROBBMap);
        this.PartLegMROBBMap.put(armature.leg_M_1_R, new EntityOBBCollider(0.6, 2.5, 0.6, 0.0, 1.4, 0.0));
        this.PartLegMROBBMap.put(armature.leg_M_3_R, new EntityOBBCollider(0.6, 1.0, 0.6, 0.0, 0.0, 0.0));
        this.PartLegMROBBMap.put(armature.leg_M_4_R, new EntityOBBCollider(1.0, 3.0, 1.0, 0.0, 1.0, 0.0));
        this.leg_M_3_R = new WraithonPartEntity(this, armature.leg_M_3_R, 2.0f, 6.0f, new Vec3(0.0, -5.0, 0.0), 0.7f, 100.0f, this.PartLegMROBBMap);
        this.PartLegBROBBMap.put(armature.leg_B_1_R, new EntityOBBCollider(0.6, 2.5, 0.6, 0.0, 1.5, 0.0));
        this.PartLegBROBBMap.put(armature.leg_B_3_R, new EntityOBBCollider(1.0, 3.0, 1.0, 0.0, 0.0, 0.5));
        this.leg_B_3_R = new WraithonPartEntity(this, armature.leg_B_3_R, 2.0f, 5.0f, new Vec3(0.0, -3.0, 0.0), 0.7f, 100.0f, this.PartLegBROBBMap);
        this.PartLegFLOBBMap.put(armature.leg_F_1_L, new EntityOBBCollider(0.6, 2.5, 0.6, 0.0, 1.0, 0.0));
        this.PartLegFLOBBMap.put(armature.leg_F_3_L, new EntityOBBCollider(1.0, 3.0, 1.0, 0.0, 0.0, 0.5));
        this.leg_F_3_L = new WraithonPartEntity(this, armature.leg_F_3_L, 2.0f, 5.0f, new Vec3(0.0, -3.0, 0.0), 0.7f, 100.0f, this.PartLegFLOBBMap);
        this.PartLegMLOBBMap.put(armature.leg_M_1_L, new EntityOBBCollider(0.6, 2.5, 0.6, 0.0, 1.4, 0.0));
        this.PartLegMLOBBMap.put(armature.leg_M_3_L, new EntityOBBCollider(0.6, 1.0, 0.6, 0.0, 0.0, 0.0));
        this.PartLegMLOBBMap.put(armature.leg_M_4_L, new EntityOBBCollider(1.0, 3.0, 1.0, 0.0, 1.0, 0.0));
        this.leg_M_3_L = new WraithonPartEntity(this, armature.leg_M_3_L, 2.0f, 6.0f, new Vec3(0.0, -5.0, 0.0), 0.7f, 100.0f, this.PartLegMLOBBMap);
        this.PartLegBLOBBMap.put(armature.leg_B_1_L, new EntityOBBCollider(0.6, 2.5, 0.6, 0.0, 1.5, 0.0));
        this.PartLegBLOBBMap.put(armature.leg_B_3_L, new EntityOBBCollider(1.0, 3.0, 1.0, 0.0, 0.0, 0.5));
        this.leg_B_3_L = new WraithonPartEntity(this, armature.leg_B_3_L, 2.0f, 5.0f, new Vec3(0.0, -3.0, 0.0), 0.7f, 100.0f, this.PartLegBLOBBMap);
        this.subEntities = new WraithonPartEntity[]{this.head, this.chest, this.tail, this.leg_F_3_R, this.leg_M_3_R, this.leg_B_3_R, this.leg_F_3_L, this.leg_M_3_L, this.leg_B_3_L};
        this.legs = List.of(new WraithonPartEntity[]{this.leg_F_3_R, this.leg_M_3_R, this.leg_B_3_R, this.leg_F_3_L, this.leg_M_3_L, this.leg_B_3_L});
        if (this.m_9236_().f_46443_) {
            WraithonEntityPatch entityPatch = this.getPatch();
            this.leg_B_3_L.setWraithonPartMesh(entityPatch.LEG_B_L);
            this.leg_B_3_R.setWraithonPartMesh(entityPatch.LEG_B_R);
            this.leg_F_3_L.setWraithonPartMesh(entityPatch.LEG_F_L);
            this.leg_F_3_R.setWraithonPartMesh(entityPatch.LEG_F_R);
            this.leg_M_3_L.setWraithonPartMesh(entityPatch.LEG_M_L);
            this.leg_M_3_R.setWraithonPartMesh(entityPatch.LEG_M_R);
        }
        this.fireContainer = new DamageContainer(this, (TagKey<DamageType>)DamageTypeTags.f_268745_, FIRE_CONTAINER, 100, 1);
        this.witherContainer = new DamageContainer(this, List.of(DamageTypes.f_268493_, DamageTypes.f_268641_), WITHER_CONTAINER, 100, 2);
        this.magicContainer = new DamageContainer(this, List.of(DamageTypes.f_268515_, DamageTypes.f_268530_), MAGIC_CONTAINER, 100, 3);
        this.outsideContainer = new DamageContainer(this, List.of(DamageTypes.f_286973_, DamageTypes.f_268724_), OUTSIDE_BORDER_CONTAINER, 100, 4);
        this.projectileContainer = new DamageContainer(this, (TagKey<DamageType>)DamageTypeTags.f_268524_, PROJECTILE_CONTAINER, 100, 5);
        this.damageContainers = List.of(this.fireContainer, this.witherContainer, this.magicContainer, this.outsideContainer, this.projectileContainer);
        this.bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        if (!this.m_9236_().f_46443_) {
            WraithonBossBarRenderer.BOSSES.put(this.bossInfo.m_18860_(), this.m_19879_());
            PacketRelay.sendToAll(PacketHandler.INSTANCE, new SyncBossBarPacket(this.bossInfo.m_18860_(), this.m_19879_()));
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public static AttributeSupplier getDefaultAttribute() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22277_, 72.0).m_22268_(Attributes.f_22278_, 1000.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 50.0).m_22268_((Attribute)EpicFightAttributes.IMPACT.get(), 500.0).m_22268_((Attribute)EpicFightAttributes.WEIGHT.get(), 2000.0).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(Y_ROT_BEFORE_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATING, (Object)false);
        this.f_19804_.m_135372_(PHASE, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(FIRE_CONTAINER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(WITHER_CONTAINER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAGIC_CONTAINER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(OUTSIDE_BORDER_CONTAINER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PROJECTILE_CONTAINER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HEALTH_OLD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IN_KNOCKDOWN, (Object)false);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(PHASE, (Object)tag.m_128451_(NBT_PHASE));
        this.f_19804_.m_135381_(STATE, (Object)tag.m_128451_(NBT_STATE));
        this.f_19804_.m_135381_(FIRE_CONTAINER, (Object)Float.valueOf(tag.m_128457_(NBT_FIRE)));
        this.f_19804_.m_135381_(WITHER_CONTAINER, (Object)Float.valueOf(tag.m_128457_(NBT_WITHER)));
        this.f_19804_.m_135381_(MAGIC_CONTAINER, (Object)Float.valueOf(tag.m_128457_(NBT_MAGIC)));
        this.f_19804_.m_135381_(OUTSIDE_BORDER_CONTAINER, (Object)Float.valueOf(tag.m_128457_(NBT_BORDER)));
        this.f_19804_.m_135381_(PROJECTILE_CONTAINER, (Object)Float.valueOf(tag.m_128457_(NBT_PROJECTILE)));
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_(NBT_PHASE, ((Integer)this.f_19804_.m_135370_(PHASE)).intValue());
        tag.m_128405_(NBT_STATE, ((Integer)this.f_19804_.m_135370_(STATE)).intValue());
        tag.m_128350_(NBT_FIRE, ((Float)this.f_19804_.m_135370_(FIRE_CONTAINER)).floatValue());
        tag.m_128350_(NBT_WITHER, ((Float)this.f_19804_.m_135370_(WITHER_CONTAINER)).floatValue());
        tag.m_128350_(NBT_MAGIC, ((Float)this.f_19804_.m_135370_(MAGIC_CONTAINER)).floatValue());
        tag.m_128350_(NBT_BORDER, ((Float)this.f_19804_.m_135370_(OUTSIDE_BORDER_CONTAINER)).floatValue());
        tag.m_128350_(NBT_PROJECTILE, ((Float)this.f_19804_.m_135370_(PROJECTILE_CONTAINER)).floatValue());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new WraithonTargetSelector(this));
    }

    public void m_6710_(@Nullable LivingEntity pTarget) {
        if (!this.m_9236_().m_5776_()) {
            super.m_6710_(pTarget);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)new SPSetAttackTarget(this.m_19879_(), pTarget != null ? pTarget.m_19879_() : -1), (Entity)this, (Object[])new Object[0]);
        } else {
            super.m_6710_(pTarget);
        }
    }

    public boolean isRotating() {
        return (Boolean)this.m_20088_().m_135370_(ROTATING);
    }

    public void setRotating(boolean rotating) {
        this.m_20088_().m_135381_(ROTATING, (Object)rotating);
    }

    public void updateYRotBeforeRotation() {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(Y_ROT_BEFORE_ROTATION, (Object)Float.valueOf(this.m_146908_()));
        }
    }

    public float m_146908_() {
        if (this.isRotating()) {
            return this.getCorrectYRot(1.0f);
        }
        return super.m_146908_();
    }

    public float getCorrectYRot(float partialTick) {
        WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, WraithonEntityPatch.class);
        if (wraithonEntityPatch == null) {
            return this.m_5675_(partialTick);
        }
        DynamicAnimation animation = (DynamicAnimation)wraithonEntityPatch.getAnimator().getPlayerFor(null).getAnimation().get();
        if (animation instanceof WraithonActionAnimation || animation instanceof WraithonAttackAnimation) {
            return ((Float)this.m_20088_().m_135370_(Y_ROT_BEFORE_ROTATION)).floatValue();
        }
        return this.m_5675_(partialTick);
    }

    @Nullable
    public DamageContainer getMaxContainer() {
        float i = 0.0f;
        DamageContainer maxContainer = null;
        for (DamageContainer damageContainer : this.damageContainers) {
            if (!(i < damageContainer.getContainerValue())) continue;
            maxContainer = damageContainer;
            i = damageContainer.getContainerValue();
        }
        return maxContainer;
    }

    public DamageContainer getContainerByState() {
        return switch (this.getState()) {
            case 1 -> this.fireContainer;
            case 2 -> this.witherContainer;
            case 3 -> this.magicContainer;
            case 4 -> this.outsideContainer;
            case 5 -> this.projectileContainer;
            default -> null;
        };
    }

    public List<DamageContainer> getDamageContainers() {
        return this.damageContainers;
    }

    public WraithonPartEntity[] getSubEntities() {
        return this.subEntities;
    }

    public SimpleParticleType getStateParticleTypes() {
        return switch (this.getState()) {
            case 1 -> ParticleTypes.f_123744_;
            case 2 -> ParticleTypes.f_123746_;
            case 3 -> ParticleTypes.f_123799_;
            case 4 -> ParticleTypes.f_123765_;
            case 5 -> ParticleTypes.f_123796_;
            default -> ParticleTypes.f_123755_;
        };
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int newPhase) {
        this.f_19804_.m_135381_(PHASE, (Object)newPhase);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setState(int newState) {
        this.f_19804_.m_135381_(STATE, (Object)newState);
    }

    public boolean isInKnockdown() {
        return (Boolean)this.f_19804_.m_135370_(IN_KNOCKDOWN);
    }

    public void setKnockdown(boolean isKnockdown) {
        this.f_19804_.m_135381_(IN_KNOCKDOWN, (Object)isKnockdown);
    }

    public WraithonEntityPatch getPatch() {
        Level level;
        if (EpicFightCapabilities.getEntityPatch((Entity)this, WraithonEntityPatch.class) == null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WraithonEntity wraithonEntity = new WraithonEntity((EntityType<? extends WraithonEntity>)((EntityType)WraithonEntities.WRAITHON.get()), this.m_9236_());
            wraithonEntity.m_146884_(this.m_20182_());
            this.m_146870_();
            serverLevel.m_7967_((Entity)wraithonEntity);
        }
        return (WraithonEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, WraithonEntityPatch.class);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
        if (entity instanceof Player) {
            Vec3 pushDirection = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            double pushStrength = 0.1;
            entity.m_20256_(entity.m_20184_().m_82549_(pushDirection.m_82490_(pushStrength)));
        }
    }

    protected void m_6138_() {
        super.m_6138_();
        for (WraithonPartEntity part : this.getWraithonParts()) {
            if (part == null) continue;
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Player.class), part.getSize().m_20393_(part.m_20182_()), EntitySelector.m_20421_((Entity)this)).forEach(this::m_7324_);
                continue;
            }
            List list = this.m_9236_().m_6249_((Entity)this, part.getSize().m_20393_(part.m_20182_()), EntitySelector.m_20421_((Entity)this));
            if (list.isEmpty()) continue;
            for (Entity entity : list) {
                this.m_7324_(entity);
            }
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    @Nullable
    public WraithonPartEntity[] getWraithonParts() {
        return this.subEntities;
    }

    protected float m_6121_() {
        return 7.0f;
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        this.f_20916_ = 0;
        if (this.isDead()) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(@NotNull DamageSource pDamageSource) {
        if (this.getPhase() < 2) {
            if (this.getState() == 0) {
                int randomInt = this.m_217043_().m_188502_() % 5;
                randomInt = Math.abs(randomInt);
                this.getDamageContainers().get(randomInt).setContainerValue(9999.0f);
            } else {
                DamageContainer damageContainerOld = this.getContainerByState();
                int randomInt = this.m_217043_().m_188502_() % 5;
                randomInt = Math.abs(randomInt);
                this.setState(0);
                for (DamageContainer damageContainer : this.getDamageContainers()) {
                    damageContainer.clearContainer();
                    damageContainer.setContainerValue((float)damageContainer.maxValue * 0.5f);
                }
                if (this.getDamageContainers().get(randomInt) != damageContainerOld) {
                    this.getDamageContainers().get(randomInt).setContainerValue(9999.0f);
                } else {
                    this.getDamageContainers().get((randomInt + 1) % 5).setContainerValue(9999.0f);
                }
            }
            this.setPhase(this.getPhase() + 1);
            this.m_21153_(this.m_21233_());
            if (this.getPatch() != null) {
                this.getPatch().playAnimationSynchronized((AssetAccessor<? extends StaticAnimation>)WraithonAnimations.WRAITHON_CHANGE, 0.15f);
            }
        } else {
            if (this.getPatch() != null) {
                this.getPatch().playAnimationSynchronized((AssetAccessor<? extends StaticAnimation>)WraithonAnimations.WRAITHON_DEATH, 0.15f);
            }
            super.m_6667_(pDamageSource);
        }
    }

    public boolean isDead() {
        return this.f_20890_;
    }

    public boolean isAnyDamageTypeInRange(DamageSource damageSource, float pAmount) {
        boolean flag = false;
        for (DamageContainer container : this.damageContainers) {
            if (!container.containDamage(damageSource)) continue;
            container.onHurt(damageSource, pAmount);
            if (this.getPhase() == 0) {
                return true;
            }
            flag = true;
        }
        return flag;
    }

    public void m_8119_() {
        super.m_8119_();
        float healthO = ((Float)this.f_19804_.m_135370_(HEALTH_OLD)).floatValue();
        float health = this.m_21223_();
        if (healthO > health && (double)((healthO - health) / this.m_21233_()) > 0.02 && health > 10.0f) {
            this.m_21153_(healthO - this.m_21233_() * 0.02f);
        }
        for (DamageContainer container : this.damageContainers) {
            container.onTick();
        }
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ % 20 == 0) {
                this.getPatch();
                this.tickNearEntity();
                this.f_19804_.m_135381_(HEALTH_OLD, (Object)Float.valueOf(this.m_21223_()));
            }
            if (this.getPhase() == 2 && this.f_19797_ % 20 == 0 && this.m_21223_() > this.m_21233_() * 0.02f) {
                this.m_21153_(this.m_21223_() - this.m_21233_() * 0.01f);
            }
        }
        for (WraithonPartEntity part : this.subEntities) {
            part.m_8119_();
        }
    }

    private void tickNearEntity() {
        ServerLevel serverLevel;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46472_() == WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY) {
            serverLevel.m_8583_().forEach(entity -> {
                Player player;
                LivingEntity livingEntity;
                if (entity == this) {
                    return;
                }
                if (!entity.m_6084_()) {
                    return;
                }
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_20182_().m_82554_(this.m_20182_()) < 6.0) {
                    Vec3 entityPos = entity.m_20182_();
                    Vec3 direction = entityPos.m_82546_(this.m_20182_()).m_82541_();
                    Vec3 newPos = this.m_20182_().m_82549_(direction.m_82490_(5.5));
                    entity.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                }
                if (entity instanceof WraithonEntity) {
                    WraithonEntity wraithon = (WraithonEntity)((Object)entity);
                    if (wraithon.getPhase() < this.getPhase() && !this.m_213877_()) {
                        wraithon.m_146870_();
                    }
                    if (wraithon.getPhase() == this.getPhase() && wraithon.m_21223_() >= this.m_21223_() && !this.m_213877_()) {
                        wraithon.m_146870_();
                    }
                }
                if (!(!(entity.m_20182_().f_82480_ - this.m_20182_().f_82480_ > 8.0) || entity instanceof Player && (player = (Player)entity).m_7500_())) {
                    entity.m_20219_(entity.m_20182_().m_82492_(0.0, 8.0, 0.0));
                }
            });
        }
    }

    public float m_21223_() {
        if (this.m_9236_().f_46443_ && super.m_21223_() > 10000.0f) {
            return Math.max(((Float)this.f_19804_.m_135370_(HEALTH_OLD)).floatValue(), super.m_21223_());
        }
        return super.m_21223_();
    }

    public void updateState() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (DamageContainer container : this.damageContainers) {
            if (!container.isFullState()) continue;
            this.setState(container.stateCode);
            return;
        }
        this.setState(0);
    }

    public float getStepHeight() {
        return 5.0f;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected boolean m_7341_(Entity p_20339_) {
        return false;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }
}

