/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.client.gui;

import com.mojang.blaze3d.platform.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.container.DamageContainer;

public class WraithonBossBarRenderer {
    public static final Map<UUID, Integer> BOSSES = new HashMap<UUID, Integer>();
    public static final ResourceLocation BAR_LONG = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/gui/bossbar/bar_long.png");
    public static final ResourceLocation BAR_HEALTH = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/gui/bossbar/bar_health.png");
    public static final ResourceLocation BAR_SHORT = ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/gui/bossbar/bar_short.png");
    public static final List<ResourceLocation> CONTAINER_TEXTURES = List.of(ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/gui/bossbar/bar_container_1.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/gui/bossbar/bar_container_2.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/gui/bossbar/bar_container_3.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/gui/bossbar/bar_container_4.png"), ResourceLocation.fromNamespaceAndPath((String)"wraithon", (String)"textures/gui/bossbar/bar_container_5.png"));

    public static void tick() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderBossBar(GuiGraphics guiGraphics, LerpingBossEvent bossEvent, int x, int y) {
        Entity boss = null;
        if (BOSSES.isEmpty()) {
            return false;
        }
        if (BOSSES.containsKey(bossEvent.m_18860_()) && Minecraft.m_91087_().f_91073_ != null) {
            boss = Minecraft.m_91087_().f_91073_.m_6815_(BOSSES.get(bossEvent.m_18860_()).intValue());
        }
        if (boss instanceof WraithonEntity) {
            WraithonEntity wraithon = (WraithonEntity)boss;
            WraithonBossBarRenderer.drawHealth(guiGraphics, y, bossEvent, BAR_LONG, BAR_HEALTH);
            DamageContainer maxContainer = wraithon.getMaxContainer();
            if (wraithon.getContainerByState() != null) {
                maxContainer = wraithon.getContainerByState();
            }
            if (maxContainer != null) {
                WraithonBossBarRenderer.drawContainer(guiGraphics, y + 16, maxContainer, BAR_SHORT);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawHealth(GuiGraphics guiGraphics, int y, LerpingBossEvent event, ResourceLocation bgBarLocation, ResourceLocation frontBarLocation) {
        Window window = Minecraft.m_91087_().m_91268_();
        int x = window.m_85445_() / 2 - 128;
        guiGraphics.m_280411_(bgBarLocation, x, y, 256, 16, 0.0f, 0.0f, 256, 16, 256, 16);
        guiGraphics.m_280411_(frontBarLocation, x + 3, y, Mth.m_269140_((float)event.m_142717_(), (int)0, (int)250), 16, 0.0f, 0.0f, Mth.m_269140_((float)event.m_142717_(), (int)0, (int)250), 16, 256, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawContainer(GuiGraphics guiGraphics, int y, DamageContainer container, ResourceLocation bgBarLocation) {
        ResourceLocation frontBarLocation = CONTAINER_TEXTURES.get(container.stateCode - 1);
        Window window = Minecraft.m_91087_().m_91268_();
        int x = window.m_85445_() / 2 - 64;
        float rate = Math.min(container.getContainerValue(), (float)container.maxValue) / (float)container.maxValue;
        guiGraphics.m_280411_(bgBarLocation, x, y, 128, 8, 0.0f, 0.0f, 128, 8, 128, 8);
        guiGraphics.m_280411_(frontBarLocation, x + 3, y, Mth.m_269140_((float)rate, (int)0, (int)120), 8, 3.0f, 0.0f, Mth.m_269140_((float)rate, (int)0, (int)120), 8, 128, 8);
    }
}

